/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SpotDatafeedSubscription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class CreateSpotDatafeedSubscription
extends BaseCmd {
    public static final String[] BUCKET_DESC = new String[]{"The Amazon S3 bucket in which to store the spot instance datafeed."};
    public static final String BUCKET_ARG = "BUCKET";
    public static final String[] PREFIX_DESC = new String[]{"Optional prefix to be prepended to datafeed files."};
    public static final String PREFIX_ARG = "PREFIX";

    public CreateSpotDatafeedSubscription(String[] args) {
        super("ec2addsds", "ec2-create-spot-datafeed-subscription");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(CreateSpotDatafeedSubscription.createOptionWithArgs("b", "bucket", BUCKET_DESC, BUCKET_ARG));
        result.addOption(CreateSpotDatafeedSubscription.createOptionWithArgs("p", "prefix", PREFIX_DESC, PREFIX_ARG));
        return result;
    }

    protected String getOptionString() {
        return "--bucket bucket [--prefix prefix]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Creates the data feed for spot instances, enabling you to view ");
        System.out.println("     spot instance usage logs.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("bucket");
        this.printOption("prefix");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertOptionSet("bucket");
        String bucket = this.getOptionValue("bucket");
        String prefix = this.getOptionValue("prefix", "");
        RequestResultPair rsp = jec2.createSpotDatafeedSubscription(bucket, prefix);
        out.output(System.out, (SpotDatafeedSubscription)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new CreateSpotDatafeedSubscription(args).invoke();
    }
}

