/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.BetaIntegerCodec;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;
import java.nio.ByteBuffer;

public final class BetaIntegerEncoding
extends CRAMEncoding<Integer> {
    private final int offset;
    private final int bitsPerValue;

    public BetaIntegerEncoding(int offset, int bitsPerValue) {
        super(EncodingID.BETA);
        if (bitsPerValue < 0) {
            throw new IllegalArgumentException("Number of bits per value must not be negative");
        }
        if (bitsPerValue > 32) {
            throw new IllegalArgumentException("Number of bits per value must be 32 or lower");
        }
        this.offset = offset;
        this.bitsPerValue = bitsPerValue;
    }

    public static BetaIntegerEncoding fromSerializedEncodingParams(byte[] serializedParams) {
        ByteBuffer buffer = ByteBuffer.wrap(serializedParams);
        int offset = ITF8.readUnsignedITF8(buffer);
        int bitLimit = ITF8.readUnsignedITF8(buffer);
        return new BetaIntegerEncoding(offset, bitLimit);
    }

    @Override
    public byte[] toSerializedEncodingParams() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        ITF8.writeUnsignedITF8(this.bitsPerValue, buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Integer> buildCodec(SliceBlocksReadStreams sliceBlocksReadStreams, SliceBlocksWriteStreams sliceBlocksWriteStreams) {
        return new BetaIntegerCodec(sliceBlocksReadStreams == null ? null : sliceBlocksReadStreams.getCoreBlockInputStream(), sliceBlocksWriteStreams == null ? null : sliceBlocksWriteStreams.getCoreOutputStream(), this.offset, this.bitsPerValue);
    }

    public String toString() {
        return String.format("Offset: %d BitsPerValue: %d", this.offset, this.bitsPerValue);
    }
}

