/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.engine;

import com.xerox.VTM.engine.AnimManager;
import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.RectangularShape;
import com.xerox.VTM.glyphs.VRectangleST;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.ImageIcon;
import net.claribole.zvtm.glyphs.VImageST;

public class ScrollLayer
implements ComponentListener {
    static final Color PASTEL_BLUE = new Color(122, 120, 156);
    int MIN_SLIDER_SIZE = 5;
    Camera controlledCamera;
    View controlledView;
    Camera slC;
    VirtualSpace slVS;
    String slVSname;
    Glyph vgutter;
    Glyph vslider;
    Glyph upBt;
    Glyph downBt;
    RectangularShape vgutterRS;
    RectangularShape vsliderRS;
    RectangularShape upBtRS;
    RectangularShape downBtRS;
    Glyph hgutter;
    Glyph hslider;
    Glyph leftBt;
    Glyph rightBt;
    RectangularShape hgutterRS;
    RectangularShape hsliderRS;
    RectangularShape leftBtRS;
    RectangularShape rightBtRS;
    long[] observedRegionBounds = new long[4];
    long[] populatedRegionBounds = new long[4];
    int panelWidth;
    int panelHeight;

    public ScrollLayer(VirtualSpaceManager vsm, Camera cc) {
        this.controlledCamera = cc;
        this.slVSname = "scrollspace" + this.controlledCamera.getID();
        this.slVS = vsm.addVirtualSpace(this.slVSname);
        this.slC = vsm.addCamera(this.slVS);
        this.vgutter = new VRectangleST(0L, 0L, 0, 8L, 8L, Color.WHITE, PASTEL_BLUE, 1.0f);
        this.vslider = new VRectangleST(0L, 0L, 0, 8L, 8L, PASTEL_BLUE, PASTEL_BLUE, 1.0f);
        this.upBt = new VImageST(new ImageIcon(this.getClass().getResource("/images/button_up_16x16.png")).getImage(), 1.0f);
        this.downBt = new VImageST(new ImageIcon(this.getClass().getResource("/images/button_down_16x16.png")).getImage(), 1.0f);
        this.hgutter = new VRectangleST(0L, 0L, 0, 8L, 8L, Color.WHITE, PASTEL_BLUE, 1.0f);
        this.hslider = new VRectangleST(0L, 0L, 0, 8L, 8L, PASTEL_BLUE, PASTEL_BLUE, 1.0f);
        this.leftBt = new VImageST(new ImageIcon(this.getClass().getResource("/images/button_left_16x16.png")).getImage(), 1.0f);
        this.rightBt = new VImageST(new ImageIcon(this.getClass().getResource("/images/button_right_16x16.png")).getImage(), 1.0f);
        this.vgutterRS = (RectangularShape)((Object)this.vgutter);
        this.vsliderRS = (RectangularShape)((Object)this.vslider);
        this.upBtRS = (RectangularShape)((Object)this.upBt);
        this.downBtRS = (RectangularShape)((Object)this.downBt);
        this.hgutterRS = (RectangularShape)((Object)this.hgutter);
        this.hsliderRS = (RectangularShape)((Object)this.hslider);
        this.leftBtRS = (RectangularShape)((Object)this.leftBt);
        this.rightBtRS = (RectangularShape)((Object)this.rightBt);
        vsm.addGlyph(this.vgutter, this.slVS);
        vsm.addGlyph(this.vslider, this.slVS);
        vsm.addGlyph(this.upBt, this.slVS);
        vsm.addGlyph(this.downBt, this.slVS);
        vsm.addGlyph(this.hgutter, this.slVS);
        vsm.addGlyph(this.hslider, this.slVS);
        vsm.addGlyph(this.leftBt, this.slVS);
        vsm.addGlyph(this.rightBt, this.slVS);
    }

    public ScrollLayer(VirtualSpaceManager vsm, Camera cc, Glyph[] widgets) {
        this.controlledCamera = cc;
        this.slVSname = "scrollspace" + this.controlledCamera.getID();
        this.slVS = vsm.addVirtualSpace(this.slVSname);
        this.slC = vsm.addCamera(this.slVS);
        this.vgutter = widgets[0];
        this.vslider = widgets[1];
        this.upBt = widgets[2];
        this.downBt = widgets[3];
        this.hgutter = widgets[4];
        this.hslider = widgets[5];
        this.leftBt = widgets[6];
        this.rightBt = widgets[7];
        this.vgutterRS = (RectangularShape)((Object)this.vgutter);
        this.vsliderRS = (RectangularShape)((Object)this.vslider);
        this.upBtRS = (RectangularShape)((Object)this.upBt);
        this.downBtRS = (RectangularShape)((Object)this.downBt);
        this.hgutterRS = (RectangularShape)((Object)this.hgutter);
        this.hsliderRS = (RectangularShape)((Object)this.hslider);
        this.leftBtRS = (RectangularShape)((Object)this.leftBt);
        this.rightBtRS = (RectangularShape)((Object)this.rightBt);
        this.vgutter.setSensitivity(false);
        this.hgutter.setSensitivity(false);
        vsm.addGlyph(this.vgutter, this.slVS);
        vsm.addGlyph(this.vslider, this.slVS);
        vsm.addGlyph(this.upBt, this.slVS);
        vsm.addGlyph(this.downBt, this.slVS);
        vsm.addGlyph(this.hgutter, this.slVS);
        vsm.addGlyph(this.hslider, this.slVS);
        vsm.addGlyph(this.leftBt, this.slVS);
        vsm.addGlyph(this.rightBt, this.slVS);
    }

    public void setView(View v) {
        this.controlledView = v;
        this.controlledView.getPanel().addComponentListener(this);
        this.updateViewSize(v.getPanel());
        this.updateScrollBars();
    }

    public void setMinimumSliderSize(int s) {
        this.MIN_SLIDER_SIZE = s / 2;
        this.updateScrollBars();
    }

    public void virtualSpaceUpdated() {
        this.controlledCamera.getOwningSpace().findFarmostGlyphCoords(this.populatedRegionBounds);
        this.updateScrollBars();
    }

    public void cameraUpdated() {
        this.controlledView.getVisibleRegion(this.controlledCamera, this.observedRegionBounds);
        this.updateScrollBars();
    }

    void updateWidgetInvariants() {
        this.vgutter.vx = this.vslider.vx = Math.round(Math.ceil((double)this.panelWidth / 2.0 - (double)this.vgutterRS.getWidth()));
        this.downBt.vx = this.vslider.vx;
        this.upBt.vx = this.vslider.vx;
        this.upBt.vy = Math.round(Math.floor((double)this.panelHeight / 2.0 - (double)this.upBtRS.getHeight()));
        this.downBt.vy = Math.round(Math.ceil((double)(-this.panelHeight) / 2.0 + (double)this.downBtRS.getHeight() + 2.0 * (double)this.hgutterRS.getHeight()));
        this.vgutter.vy = Math.round(Math.ceil((double)(this.upBt.vy + this.downBt.vy) / 2.0));
        this.vgutterRS.setHeight(Math.round(Math.ceil((double)this.panelHeight / 2.0 - (double)this.hgutterRS.getHeight() - (double)this.upBtRS.getHeight() - (double)this.downBtRS.getHeight())));
        this.hgutter.vy = this.hslider.vy = Math.round(Math.floor((double)(-this.panelHeight) / 2.0 + (double)this.hgutterRS.getHeight()));
        this.rightBt.vy = this.hslider.vy;
        this.leftBt.vy = this.hslider.vy;
        this.leftBt.vx = Math.round(Math.ceil((double)(-this.panelWidth) / 2.0 + (double)this.leftBtRS.getWidth()));
        this.rightBt.vx = Math.round(Math.ceil((double)this.panelWidth / 2.0 - (double)this.rightBtRS.getWidth() - 2.0 * (double)this.vgutterRS.getWidth()));
        this.hgutter.vx = Math.round(Math.ceil((double)(this.leftBt.vx + this.rightBt.vx) / 2.0));
        this.hgutterRS.setWidth(Math.round(Math.ceil((double)this.panelWidth / 2.0 - (double)this.vgutterRS.getWidth() - (double)this.leftBtRS.getWidth() - (double)this.rightBtRS.getWidth())));
    }

    public void updateScrollBars() {
        this.updateVerticalScrollBar();
        this.updateHorizontalScrollBar();
    }

    public void updateVerticalScrollBar() {
        double ratio;
        long sliderSize;
        long totalHeight = this.populatedRegionBounds[1] - this.populatedRegionBounds[3];
        long observedHeight = this.observedRegionBounds[1] - this.observedRegionBounds[3];
        if (totalHeight < observedHeight) {
            observedHeight = totalHeight;
        }
        if ((sliderSize = Math.round((ratio = (double)observedHeight / (double)totalHeight) * (double)this.vgutterRS.getHeight())) < (long)this.MIN_SLIDER_SIZE) {
            sliderSize = this.MIN_SLIDER_SIZE;
        }
        this.vsliderRS.setHeight(sliderSize);
        long y = Math.round(2.0 * ((double)this.controlledCamera.posy - (double)(this.populatedRegionBounds[1] + this.populatedRegionBounds[3]) / 2.0) / (double)(this.populatedRegionBounds[1] - this.populatedRegionBounds[3]) * (double)this.vgutterRS.getHeight());
        if (y > this.upBt.vy - this.upBtRS.getHeight() - sliderSize) {
            y = this.upBt.vy - this.upBtRS.getHeight() - sliderSize;
        } else if (y < this.downBt.vy + this.downBtRS.getHeight() + sliderSize) {
            y = this.downBt.vy + this.downBtRS.getHeight() + sliderSize;
        }
        this.vslider.vy = y;
    }

    public void updateHorizontalScrollBar() {
        double ratio;
        long sliderSize;
        long totalWidth = this.populatedRegionBounds[2] - this.populatedRegionBounds[0];
        long observedWidth = this.observedRegionBounds[2] - this.observedRegionBounds[0];
        if (totalWidth < observedWidth) {
            observedWidth = totalWidth;
        }
        if ((sliderSize = Math.round((ratio = (double)observedWidth / (double)totalWidth) * (double)this.hgutterRS.getWidth())) < (long)this.MIN_SLIDER_SIZE) {
            sliderSize = this.MIN_SLIDER_SIZE;
        }
        this.hsliderRS.setWidth(sliderSize);
        long x = Math.round(2.0 * ((double)this.controlledCamera.posx - (double)(this.populatedRegionBounds[2] + this.populatedRegionBounds[0]) / 2.0) / (double)(this.populatedRegionBounds[2] - this.populatedRegionBounds[0]) * (double)this.hgutterRS.getWidth());
        if (x > this.rightBt.vx - this.rightBtRS.getWidth() - sliderSize) {
            x = this.rightBt.vx - this.rightBtRS.getWidth() - sliderSize;
        } else if (x < this.leftBt.vx + this.leftBtRS.getWidth() + sliderSize) {
            x = this.leftBt.vx + this.leftBtRS.getWidth() + sliderSize;
        }
        this.hslider.vx = x;
    }

    void updateCameraVerticalPosition() {
        this.controlledCamera.moveTo(this.controlledCamera.posx, Math.round((double)(this.vslider.vy * (this.populatedRegionBounds[1] - this.populatedRegionBounds[3])) / (2.0 * (double)this.vgutterRS.getHeight()) + (double)(this.populatedRegionBounds[1] + this.populatedRegionBounds[3]) / 2.0));
    }

    void updateCameraHorizontalPosition() {
        this.controlledCamera.moveTo(Math.round((double)(this.hslider.vx * (this.populatedRegionBounds[2] - this.populatedRegionBounds[0])) / (2.0 * (double)this.hgutterRS.getWidth()) + (double)(this.populatedRegionBounds[2] + this.populatedRegionBounds[0]) / 2.0), this.controlledCamera.posy);
    }

    public boolean cursorInside(int cx, int cy) {
        double coef = ((double)this.slC.focal + (double)this.slC.altitude) / (double)this.slC.focal;
        long vx = Math.round((double)(cx - this.panelWidth / 2) * coef + (double)this.slC.posx);
        long vy = Math.round((double)(this.panelHeight / 2 - cy) * coef + (double)this.slC.posy);
        return vx > this.vgutter.vx - this.vgutterRS.getWidth() || vy < this.hgutter.vy + this.hgutterRS.getHeight();
    }

    public Camera getWidgetCamera() {
        return this.slC;
    }

    public Camera getControlledCamera() {
        return this.controlledCamera;
    }

    public void draggingHorizontalSlider(int dx) {
        if (this.hslider.vx + (long)dx + this.hsliderRS.getWidth() < this.rightBt.vx - this.rightBtRS.getWidth() && this.hslider.vx + (long)dx - this.hsliderRS.getWidth() > this.leftBt.vx + this.leftBtRS.getWidth()) {
            this.hslider.move(dx, 0L);
            this.updateCameraHorizontalPosition();
        }
    }

    public void draggingVerticalSlider(int dy) {
        if (this.vslider.vy + (long)dy + this.vsliderRS.getHeight() < this.upBt.vy - this.upBtRS.getHeight() && this.vslider.vy + (long)dy - this.vsliderRS.getHeight() > this.downBt.vy + this.downBtRS.getHeight()) {
            this.vslider.move(0L, dy);
            this.updateCameraVerticalPosition();
        }
    }

    public void moveUp() {
        long dy = this.vsliderRS.getHeight();
        if (this.vslider.vy + dy + this.vsliderRS.getHeight() < this.upBt.vy - this.upBtRS.getHeight() && this.vslider.vy + dy - this.vsliderRS.getHeight() > this.downBt.vy + this.downBtRS.getHeight()) {
            this.vslider.move(0L, dy);
            this.updateCameraVerticalPosition();
        } else {
            this.vslider.moveTo(this.vslider.vx, this.upBt.vy - this.upBtRS.getHeight() - this.vsliderRS.getHeight());
            this.updateCameraVerticalPosition();
        }
    }

    public void moveDown() {
        long dy = -this.vsliderRS.getHeight();
        if (this.vslider.vy + dy + this.vsliderRS.getHeight() < this.upBt.vy - this.upBtRS.getHeight() && this.vslider.vy + dy - this.vsliderRS.getHeight() > this.downBt.vy + this.downBtRS.getHeight()) {
            this.vslider.move(0L, dy);
            this.updateCameraVerticalPosition();
        } else {
            this.vslider.moveTo(this.vslider.vx, this.downBt.vy + this.downBtRS.getHeight() + this.vsliderRS.getHeight());
            this.updateCameraVerticalPosition();
        }
    }

    public void moveLeft() {
        long dx = -this.hsliderRS.getWidth();
        if (this.hslider.vx + dx + this.hsliderRS.getWidth() < this.rightBt.vx - this.rightBtRS.getWidth() && this.hslider.vx + dx - this.hsliderRS.getWidth() > this.leftBt.vx + this.leftBtRS.getWidth()) {
            this.hslider.move(dx, 0L);
            this.updateCameraHorizontalPosition();
        } else {
            this.hslider.moveTo(this.leftBt.vx + this.leftBtRS.getWidth() + this.hsliderRS.getWidth(), this.hslider.vy);
            this.updateCameraHorizontalPosition();
        }
    }

    public void moveRight() {
        long dx = this.hsliderRS.getWidth();
        if (this.hslider.vx + dx + this.hsliderRS.getWidth() < this.rightBt.vx - this.rightBtRS.getWidth() && this.hslider.vx + dx - this.hsliderRS.getWidth() > this.leftBt.vx + this.leftBtRS.getWidth()) {
            this.hslider.move(dx, 0L);
            this.updateCameraHorizontalPosition();
        } else {
            this.hslider.moveTo(this.rightBt.vx - this.rightBtRS.getWidth() - this.hsliderRS.getWidth(), this.hslider.vy);
            this.updateCameraHorizontalPosition();
        }
    }

    public Glyph getVerticalSlider() {
        return this.vslider;
    }

    public Glyph getHorizontalSlider() {
        return this.hslider;
    }

    public Glyph getUpButton() {
        return this.upBt;
    }

    public Glyph getDownButton() {
        return this.downBt;
    }

    public Glyph getLeftButton() {
        return this.leftBt;
    }

    public Glyph getRightButton() {
        return this.rightBt;
    }

    public void fade(AnimManager am, int duration, float alphaOffset) throws ClassCastException {
        float[] FADE_IN_DATA = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, alphaOffset};
        am.createGlyphAnimation(duration, (short)9, FADE_IN_DATA, this.vgutter.getID());
        am.createGlyphAnimation(duration, (short)9, FADE_IN_DATA, this.vslider.getID());
        am.createGlyphAnimation(duration, (short)9, FADE_IN_DATA, this.upBt.getID());
        am.createGlyphAnimation(duration, (short)9, FADE_IN_DATA, this.downBt.getID());
        am.createGlyphAnimation(duration, (short)9, FADE_IN_DATA, this.hgutter.getID());
        am.createGlyphAnimation(duration, (short)9, FADE_IN_DATA, this.hslider.getID());
        am.createGlyphAnimation(duration, (short)9, FADE_IN_DATA, this.rightBt.getID());
        am.createGlyphAnimation(duration, (short)9, FADE_IN_DATA, this.leftBt.getID());
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.updateViewSize(e.getComponent());
    }

    public void componentShown(ComponentEvent e) {
    }

    void updateViewSize(Component c) {
        Dimension d = c.getSize();
        this.panelWidth = d.width;
        this.panelHeight = d.height;
        this.updateWidgetInvariants();
        this.cameraUpdated();
    }
}

