/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.Annotation;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.history.SSCMHistoryParser;
import org.opensolaris.opengrok.util.Executor;

public class SSCMRepository
extends Repository {
    private static final long serialVersionUID = 1L;
    public static final String CMD_PROPERTY_KEY = "org.opensolaris.opengrok.history.sscm";
    public static final String CMD_FALLBACK = "sscm";
    private static final Pattern ANNOTATE_PATTERN = Pattern.compile("^(\\w+)\\s+(\\d+)\\s+.*$");
    private static final String MYSCMSERVERINFO_FILE = ".MySCMServerInfo";
    private static final String BRANCH_PROPERTY = "SCMBranch";
    private static final String REPOSITORY_PROPERTY = "SCMRepository";

    public SSCMRepository() {
        this.setType("SSCM");
        this.setDatePattern("M/d/yyyy h:mm a");
        this.setRemote(true);
    }

    @Override
    boolean fileHasHistory(File file) {
        return true;
    }

    @Override
    boolean hasHistoryForDirectories() {
        return false;
    }

    @Override
    public boolean isWorking() {
        if (this.working == null) {
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            this.working = SSCMRepository.checkCmd(this.cmd, "version");
        }
        return this.working;
    }

    private Properties getProperties(File file) {
        Properties props = new Properties();
        File propFile = file.isDirectory() ? new File(file, MYSCMSERVERINFO_FILE) : new File(file.getParent(), MYSCMSERVERINFO_FILE);
        if (propFile.isFile()) {
            try (BufferedReader br = new BufferedReader(new FileReader(propFile));){
                props.load(br);
            }
            catch (IOException ex) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to work with {0} file of {1}: {2}", new Object[]{MYSCMSERVERINFO_FILE, this.getDirectoryName(), ex.getClass().toString()});
            }
        }
        return props;
    }

    Executor getHistoryLogExecutor(File file, String sinceRevision) throws IOException {
        String repo;
        ArrayList<String> argv = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        argv.add(this.cmd);
        argv.add("history");
        if (file.isDirectory()) {
            argv.add("/");
        } else {
            argv.add(file.getName());
        }
        if (sinceRevision != null && new Scanner(sinceRevision).hasNextInt()) {
            argv.add("-v" + (Integer.parseInt(sinceRevision) + 1) + ":" + Integer.MAX_VALUE);
        }
        argv.add("-w-");
        Properties props = this.getProperties(file);
        String branch = props.getProperty(BRANCH_PROPERTY);
        if (branch != null && !branch.isEmpty()) {
            argv.add("-b" + branch);
        }
        if ((repo = props.getProperty(REPOSITORY_PROPERTY)) != null && !repo.isEmpty()) {
            argv.add("-p" + repo);
        }
        return new Executor(argv, new File(this.getDirectoryName()));
    }

    @Override
    History getHistory(File file) throws HistoryException {
        return this.getHistory(file, null);
    }

    @Override
    History getHistory(File file, String sinceRevision) throws HistoryException {
        return new SSCMHistoryParser(this).parse(file, sinceRevision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream getHistoryGet(String parent, final String basename, String rev) {
        BufferedInputStream ret = null;
        File directory = new File(parent);
        Process process = null;
        try {
            String repo;
            final File tmp = File.createTempFile("opengrok", "tmp");
            String tmpName = tmp.getCanonicalPath();
            if (tmp.exists() && !tmp.delete()) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to remove temporary file used by history cache");
            }
            if (!tmp.mkdir()) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to create temporary directory used by history cache");
            }
            ArrayList<String> argv = new ArrayList<String>();
            this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
            argv.add(this.cmd);
            argv.add("get");
            argv.add(basename);
            argv.add("-d" + tmpName);
            Properties props = this.getProperties(directory);
            String branch = props.getProperty(BRANCH_PROPERTY);
            if (branch != null && !branch.isEmpty()) {
                argv.add("-b" + branch);
            }
            if ((repo = props.getProperty(REPOSITORY_PROPERTY)) != null && !repo.isEmpty()) {
                argv.add("-p" + repo);
            }
            if (rev != null) {
                argv.add("-v" + rev);
            }
            argv.add("-q");
            argv.add("-tmodify");
            argv.add("-wreplace");
            Executor exec = new Executor(argv, directory);
            int status = exec.exec();
            if (status != 0) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "Failed get revision {2} for: \"{0}\" Exit code: {1}", new Object[]{new File(parent, basename).getAbsolutePath(), String.valueOf(status), rev});
                InputStream inputStream = null;
                return inputStream;
            }
            ret = new BufferedInputStream(new FileInputStream(new File(tmp, basename))){

                @Override
                public void close() throws IOException {
                    super.close();
                    boolean deleteOnExit = false;
                    File tmpFile = new File(tmp, basename);
                    if (!tmpFile.delete()) {
                        deleteOnExit = true;
                        tmpFile.deleteOnExit();
                    }
                    if (deleteOnExit || !tmp.delete()) {
                        tmp.deleteOnExit();
                    }
                }
            };
        }
        catch (IOException exp) {
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Failed to get file: " + exp.getClass().toString(), exp);
        }
        finally {
            if (process != null) {
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException exp) {
                    process.destroy();
                }
            }
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean fileHasAnnotation(File file) {
        File propFile = new File(file.getParent(), MYSCMSERVERINFO_FILE);
        if (!propFile.isFile()) return false;
        try (BufferedReader br = new BufferedReader(new FileReader(propFile));){
            String line;
            String[] parts;
            do {
                if ((line = br.readLine()) == null) return false;
            } while (!(parts = line.split(";"))[0].equals(file.getName()));
            if (parts.length <= 2) return false;
            if (!new Scanner(parts[2]).hasNextInt()) return false;
            boolean bl = Integer.parseInt(parts[2]) > 1;
            return bl;
        }
        catch (IOException ex) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to work with {0} file of {1}: {2}", new Object[]{MYSCMSERVERINFO_FILE, this.getDirectoryName(), ex.getClass().toString()});
        }
        return false;
    }

    @Override
    Annotation annotate(File file, String revision) throws IOException {
        Executor exec;
        int status;
        String repo;
        ArrayList<String> argv = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        argv.add(this.cmd);
        argv.add("annotate");
        argv.add(file.getName());
        Properties props = this.getProperties(file);
        String branch = props.getProperty(BRANCH_PROPERTY);
        if (branch != null && !branch.isEmpty()) {
            argv.add("-b" + branch);
        }
        if ((repo = props.getProperty(REPOSITORY_PROPERTY)) != null && !repo.isEmpty()) {
            argv.add("-p" + repo);
        }
        if (revision != null) {
            argv.add("-aV:" + revision);
        }
        if ((status = (exec = new Executor(argv, file.getParentFile())).exec()) != 0) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Failed annotate for: {2} \"{0}\" Exit code: {1}", new Object[]{file.getAbsolutePath(), String.valueOf(status), revision});
        }
        return this.parseAnnotation(exec.getOutputReader(), file.getName());
    }

    protected Annotation parseAnnotation(Reader input, String fileName) throws IOException {
        BufferedReader in = new BufferedReader(input);
        Annotation ret = new Annotation(fileName);
        String line = "";
        int lineno = 0;
        boolean hasStarted = false;
        Matcher matcher = ANNOTATE_PATTERN.matcher(line);
        while ((line = in.readLine()) != null) {
            if (line.isEmpty()) continue;
            ++lineno;
            matcher.reset(line);
            if (matcher.find()) {
                hasStarted = true;
                String rev = matcher.group(2);
                String author = matcher.group(1);
                ret.addLine(rev, author, true);
                continue;
            }
            if (!hasStarted) continue;
            OpenGrokLogger.getLogger().log(Level.SEVERE, "Error: did not find annotation in line {0}: [{1}]", new Object[]{String.valueOf(lineno), line});
        }
        return ret;
    }

    @Override
    void update() throws IOException {
        String repo;
        File directory = new File(this.getDirectoryName());
        ArrayList<String> argv = new ArrayList<String>();
        this.ensureCommand(CMD_PROPERTY_KEY, CMD_FALLBACK);
        argv.add(this.cmd);
        argv.add("get");
        argv.add("/");
        Properties props = this.getProperties(directory);
        String branch = props.getProperty(BRANCH_PROPERTY);
        if (branch != null && !branch.isEmpty()) {
            argv.add("-b" + branch);
        }
        if ((repo = props.getProperty(REPOSITORY_PROPERTY)) != null && !repo.isEmpty()) {
            argv.add("-p" + repo);
        }
        argv.add("-r");
        argv.add("-q");
        argv.add("-tmodify");
        argv.add("-wreplace");
        Executor executor = new Executor(argv, directory);
        if (executor.exec() != 0) {
            throw new IOException(executor.getErrorString());
        }
    }

    @Override
    boolean isRepositoryFor(File file) {
        if (file.isDirectory()) {
            File f = new File(file, MYSCMSERVERINFO_FILE);
            return f.exists() && f.isFile();
        }
        return false;
    }
}

