require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_SLJITARCH_H)) {
    eval 'sub _ARM_SLJITARCH_H () {1;}' unless defined(&_ARM_SLJITARCH_H);
    require 'sys/cdefs.ph';
    if(defined(&_KERNEL)) {
	require 'machine/types.ph';
	require 'arm/cpufunc.ph';
    } else {
	require 'stddef.ph';
	require 'stdint.ph';
	require 'arm/sysarch.ph';
    }
    if(defined(&_ARM_ARCH_T2)) {
	eval 'sub SLJIT_CONFIG_ARM_THUMB2 () {1;}' unless defined(&SLJIT_CONFIG_ARM_THUMB2);
    }
 elsif(defined(&_ARM_ARCH_7)) {
	eval 'sub SLJIT_CONFIG_ARM_V7 () {1;}' unless defined(&SLJIT_CONFIG_ARM_V7);
    } else {
	eval 'sub SLJIT_CONFIG_ARM_V5 () {1;}' unless defined(&SLJIT_CONFIG_ARM_V5);
    }
    if(defined(&_KERNEL)) {
	eval 'sub SLJIT_CACHE_FLUSH {
	    my($from, $to) = @_;
    	    eval q( &cpu_icache_sync_range(( &vaddr_t)($from), ( &vsize_t)(($to) - ($from))));
	}' unless defined(&SLJIT_CACHE_FLUSH);
    } else {
	eval 'sub SLJIT_CACHE_FLUSH {
	    my($from, $to) = @_;
    	    eval q(( &void) &arm_sync_icache(( &uintptr_t), (($to) - ($from))));
	}' unless defined(&SLJIT_CACHE_FLUSH);
    }
}
1;
