/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.context.functions;

import org.intellij.lang.xpath.psi.XPathType;
import org.jetbrains.annotations.NotNull;

public class Parameter {
    public final XPathType type;
    public final Kind kind;

    public Parameter(@NotNull XPathType type, @NotNull Kind kind) {
        if (type == null) {
            Parameter.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            Parameter.$$$reportNull$$$0(1);
        }
        this.type = type;
        this.kind = kind;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type.getName());
        if (this.kind == Kind.OPTIONAL) {
            sb.append("?");
        }
        if (this.kind == Kind.VARARG) {
            sb.append("*");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Parameter parameter = (Parameter)o;
        if (this.kind != parameter.kind) {
            return false;
        }
        return this.type.equals(parameter.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.kind.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "type";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "kind";
                break;
            }
        }
        objectArray[1] = "org/intellij/lang/xpath/context/functions/Parameter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Kind {
        REQUIRED,
        OPTIONAL,
        VARARG;

    }
}

