/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionProvider;
import org.jetbrains.annotations.Nullable;

public class VcsSelectionUtil {
    private VcsSelectionUtil() {
    }

    @Nullable
    public static VcsSelection getSelection(VcsContext context) {
        VcsSelection selectionFromEditor = VcsSelectionUtil.getSelectionFromEditor(context);
        if (selectionFromEditor != null) {
            return selectionFromEditor;
        }
        for (VcsSelectionProvider provider : VcsSelectionProvider.EP_NAME.getExtensionList()) {
            try {
                VcsSelection vcsSelection = provider.getSelection(context);
                if (vcsSelection == null) continue;
                return vcsSelection;
            }
            catch (IndexNotReadyException indexNotReadyException) {
            }
        }
        return null;
    }

    @Nullable
    private static VcsSelection getSelectionFromEditor(VcsContext context) {
        Editor editor = context.getEditor();
        if (editor == null) {
            return null;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            return null;
        }
        return new VcsSelection(editor.getDocument(), selectionModel);
    }
}

