/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.commandLine;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CaseCollector;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurable;
import com.jetbrains.php.config.commandLine.PhpCommandLineCommand;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.debug.PhpDebugUtil;
import com.jetbrains.php.run.PhpCommandLineSettings;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCommandSettings {
    private static final NotNullFunction<String, String> ESCAPER = StringUtil.escaper((boolean)true, null);
    private static final String DISABLE_XDEBUG_OPTION = "-dxdebug.remote_enable=0";
    private static final PathMappingSettings.PathMapping[] EMPTY_MAPPINGS = new PathMappingSettings.PathMapping[0];
    private final List<String> myInvalidPathArguments;
    private final PhpCommandLineCommand myCommand;
    @NotNull
    private final PhpCommandLinePathProcessor myPathProcessor;
    @Nullable
    private final PhpSdkAdditionalData myAdditionalData;
    private PathMappingSettings.PathMapping myAdditionalMappings;

    public PhpCommandSettings(@NotNull String binary, @NotNull PhpCommandLinePathProcessor pathProcessor, @Nullable PhpSdkAdditionalData additionalData) {
        if (binary == null) {
            PhpCommandSettings.$$$reportNull$$$0(0);
        }
        if (pathProcessor == null) {
            PhpCommandSettings.$$$reportNull$$$0(1);
        }
        this.myAdditionalMappings = null;
        this.myCommand = new PhpCommandLineCommand(binary);
        this.myPathProcessor = pathProcessor;
        this.myAdditionalData = additionalData;
        this.myInvalidPathArguments = new SmartList();
    }

    @NotNull
    public static PhpCommandSettings createHelperCommand(@NotNull String pathToBinary, boolean remote) {
        if (pathToBinary == null) {
            PhpCommandSettings.$$$reportNull$$$0(2);
        }
        PhpCommandSettings command = new PhpCommandSettings(pathToBinary, remote ? PhpCommandLinePathProcessor.IDENTICAL : PhpCommandLinePathProcessor.LOCAL, null);
        command.addOption(DISABLE_XDEBUG_OPTION);
        PhpCommandSettings phpCommandSettings = command;
        if (phpCommandSettings == null) {
            PhpCommandSettings.$$$reportNull$$$0(3);
        }
        return phpCommandSettings;
    }

    public void setScript(@NotNull String scriptPath) {
        if (scriptPath == null) {
            PhpCommandSettings.$$$reportNull$$$0(4);
        }
        this.setScript(scriptPath, true);
    }

    public void setScript(@NotNull String scriptPath, boolean processScriptPath) {
        if (scriptPath == null) {
            PhpCommandSettings.$$$reportNull$$$0(5);
        }
        String processedPath = processScriptPath ? this.processPathParameter(scriptPath) : scriptPath;
        this.myCommand.setScript(processedPath);
    }

    @NotNull
    private String processPathParameter(@NotNull String path) {
        if (path == null) {
            PhpCommandSettings.$$$reportNull$$$0(6);
        }
        if (!this.myPathProcessor.canProcess(path)) {
            this.myInvalidPathArguments.add(path);
        }
        String string = this.myPathProcessor.process(path);
        if (string == null) {
            PhpCommandSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void addConfigurationOptions(@NotNull List<PhpConfigurationOption> options) {
        if (options == null) {
            PhpCommandSettings.$$$reportNull$$$0(8);
        }
        this.myCommand.addConfigurationOptions(options);
    }

    public void importCommandLineSettings(@NotNull PhpCommandLineSettings settings, @Nullable String defaultWorkingDir) {
        if (settings == null) {
            PhpCommandSettings.$$$reportNull$$$0(9);
        }
        this.myCommand.importCommandLineSettings(settings, defaultWorkingDir);
    }

    public void setAdditionalMapping(@NotNull PathMappingSettings.PathMapping mapping) {
        if (mapping == null) {
            PhpCommandSettings.$$$reportNull$$$0(10);
        }
        this.myAdditionalMappings = mapping;
    }

    @NotNull
    public PathMappingSettings.PathMapping[] getAdditionalMappings() {
        PathMappingSettings.PathMapping[] pathMappingArray;
        if (this.myAdditionalMappings == null) {
            pathMappingArray = EMPTY_MAPPINGS;
        } else {
            PathMappingSettings.PathMapping[] pathMappingArray2 = new PathMappingSettings.PathMapping[1];
            pathMappingArray = pathMappingArray2;
            pathMappingArray2[0] = this.myAdditionalMappings;
        }
        if (pathMappingArray == null) {
            PhpCommandSettings.$$$reportNull$$$0(11);
        }
        return pathMappingArray;
    }

    public void addEnvs(@NotNull Map<String, String> env) {
        if (env == null) {
            PhpCommandSettings.$$$reportNull$$$0(12);
        }
        this.myCommand.addEnvs(env);
    }

    public void addEnv(@NotNull String name, @NotNull String value) {
        if (name == null) {
            PhpCommandSettings.$$$reportNull$$$0(13);
        }
        if (value == null) {
            PhpCommandSettings.$$$reportNull$$$0(14);
        }
        this.myCommand.addEnv(name, value);
    }

    public void addArguments(@NotNull List<String> arguments) {
        if (arguments == null) {
            PhpCommandSettings.$$$reportNull$$$0(15);
        }
        this.myCommand.addArguments(arguments);
    }

    public void addArgument(@NotNull String arg) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(16);
        }
        this.myCommand.addArgument(arg);
    }

    public void addClassFqnArgument(@NotNull String arg) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(17);
        }
        this.myCommand.addArgument(this.bySsh() ? (String)ESCAPER.fun((Object)arg) : arg);
    }

    public void addPathArgument(@NotNull String arg) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(18);
        }
        this.myCommand.addArgument(this.processPathParameter(arg));
    }

    public void addPathArgument(@NotNull String arg, @NotNull String suffix) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(19);
        }
        if (suffix == null) {
            PhpCommandSettings.$$$reportNull$$$0(20);
        }
        this.myCommand.addArgument(this.processPathParameter(arg) + suffix);
    }

    public void addRelativePathArgument(@NotNull String arg, @NotNull String baseDir) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(21);
        }
        if (baseDir == null) {
            PhpCommandSettings.$$$reportNull$$$0(22);
        }
        this.addRelativePathArgument(arg, baseDir, "");
    }

    public void addRelativePathArgument(@NotNull String arg, @NotNull String baseDir, @NotNull String suffix) {
        if (arg == null) {
            PhpCommandSettings.$$$reportNull$$$0(23);
        }
        if (baseDir == null) {
            PhpCommandSettings.$$$reportNull$$$0(24);
        }
        if (suffix == null) {
            PhpCommandSettings.$$$reportNull$$$0(25);
        }
        String path = this.processPathParameter(arg);
        String base = this.myPathProcessor.process(baseDir);
        if (FileUtil.isAncestor((String)base, (String)path, (boolean)false)) {
            String relative = FileUtil.getRelativePath((String)base, (String)path, (char)(path.length() > 1 && path.charAt(1) == ':' ? 92 : 47));
            if (StringUtil.isNotEmpty((String)relative)) {
                this.myCommand.addArgument(relative + suffix);
            } else {
                this.myCommand.addArgument(path + suffix);
            }
        }
    }

    public PhpCommandSettings addOption(@NotNull String option) {
        if (option == null) {
            PhpCommandSettings.$$$reportNull$$$0(26);
        }
        this.myCommand.addOption(option);
        return this;
    }

    public boolean isRemote() {
        return this.myAdditionalData instanceof RemoteSdkAdditionalData;
    }

    @Nullable
    public PhpSdkAdditionalData getAdditionalData() {
        return this.myAdditionalData;
    }

    @NotNull
    public PhpCommandLinePathProcessor getPathProcessor() {
        PhpCommandLinePathProcessor phpCommandLinePathProcessor = this.myPathProcessor;
        if (phpCommandLinePathProcessor == null) {
            PhpCommandSettings.$$$reportNull$$$0(27);
        }
        return phpCommandLinePathProcessor;
    }

    public String getWorkingDirectory() {
        return this.myCommand.getWorkingDirectory();
    }

    public GeneralCommandLine createGeneralCommandLine() {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(this.myCommand.getPhpBinary());
        String workingDirectory = this.myCommand.getWorkingDirectory();
        if (workingDirectory != null) {
            commandLine.withWorkDirectory(this.myPathProcessor.process(workingDirectory));
        }
        for (String option : this.myCommand.getOptions()) {
            commandLine.addParameter(option);
        }
        String scriptPath = this.myCommand.getScriptPath();
        if (scriptPath != null) {
            commandLine.addParameter(scriptPath);
        }
        commandLine.addParameters(this.myCommand.getArgs());
        commandLine.withEnvironment(this.myCommand.getEnvs());
        commandLine.withParentEnvironmentType(this.myCommand.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        return commandLine;
    }

    protected boolean bySsh() {
        return this.isRemote() && CaseCollector.useRemoteCredentials((RemoteSdkAdditionalData)((RemoteSdkAdditionalData)this.getAdditionalData()));
    }

    public boolean hasInvalidPathArguments() {
        return this.isRemote() && !this.myInvalidPathArguments.isEmpty();
    }

    public void validateAndNotify(final @NotNull Project project) {
        if (project == null) {
            PhpCommandSettings.$$$reportNull$$$0(28);
        }
        if (this.hasInvalidPathArguments()) {
            assert (this.myAdditionalData != null);
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            StringBuilder source = new StringBuilder();
            if (manager != null) {
                source.append(manager.getPathMappingsSource(this.myAdditionalData));
            }
            String phpSection = PhpBundle.message("remote.interpreter.path.mappings.validation.php.section", new Object[0]);
            if (source.length() > 0) {
                source.append(" or at ");
            }
            source.append(phpSection);
            String title = PhpBundle.message("remote.interpreter.path.mappings.validation.title", new Object[0]);
            String message = PhpBundle.message("remote.interpreter.path.mappings.validation.message", source);
            NotificationListener listener = new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                    String description;
                    if (notification2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && "php_mappings".equals(description = event.getDescription())) {
                        PhpProjectConfigurable.createFix(project).run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/config/commandLine/PhpCommandSettings$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            PhpDebugUtil.showWarningNotification(project, title, message, listener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binary";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBinary";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/commandLine/PhpCommandSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/commandLine/PhpCommandSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createHelperCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processPathParameter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalMappings";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createHelperCommand";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 27: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setScript";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processPathParameter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurationOptions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "importCommandLineSettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalMapping";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addEnvs";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addEnv";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addArguments";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addArgument";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addClassFqnArgument";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addPathArgument";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addRelativePathArgument";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addOption";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "validateAndNotify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

