/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpWrongForeachArgumentTypeInspection
extends PhpInspection {
    private static final String ERROR_BATCH = PhpBundle.message("inspection.wrong.foreach.argument.type.problem.batch", new Object[0]);
    private static final PhpType UNSUPPORTED_TYPE_SET = new PhpType();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpWrongForeachArgumentTypeInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpForeach(ForeachStatement foreach) {
                PsiElement argument = foreach.getArgument();
                if (argument instanceof PhpTypedElement) {
                    Project project = argument.getProject();
                    PhpType argumentType = ((PhpTypedElement)argument).getType().global(project);
                    if (PhpType.isSubType((PhpType)argumentType, (PhpType)UNSUPPORTED_TYPE_SET)) {
                        String errorMessage = isOnTheFly ? PhpBundle.message("inspection.wrong.foreach.argument.type.problem", argumentType.toStringResolved()) : ERROR_BATCH;
                        holder.registerProblem(argument, errorMessage, new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpWrongForeachArgumentTypeInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    static {
        UNSUPPORTED_TYPE_SET.add(PhpType.STRING);
        UNSUPPORTED_TYPE_SET.add(PhpType.FLOAT);
        UNSUPPORTED_TYPE_SET.add(PhpType.INT);
        UNSUPPORTED_TYPE_SET.add(PhpType.BOOLEAN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpWrongForeachArgumentTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpWrongForeachArgumentTypeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

