/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpPathInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhpPathInfoSetExternalizer
implements DataExternalizer<Set<PhpPathInfo>> {
    public static final PhpPathInfoSetExternalizer INSTANCE = new PhpPathInfoSetExternalizer();

    public void save(@NotNull DataOutput out, Set<PhpPathInfo> value) throws IOException {
        if (out == null) {
            PhpPathInfoSetExternalizer.$$$reportNull$$$0(0);
        }
        out.writeInt(value.size());
        for (PhpPathInfo item : value) {
            PhpPathInfoSetExternalizer.saveItem(out, item);
        }
    }

    public Set<PhpPathInfo> read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            PhpPathInfoSetExternalizer.$$$reportNull$$$0(1);
        }
        int size = in.readInt();
        HashSet<PhpPathInfo> result = new HashSet<PhpPathInfo>(size);
        for (int i = 0; i < size; ++i) {
            result.add(PhpPathInfoSetExternalizer.readItem(in));
        }
        return result;
    }

    public static PhpPathInfo readItem(DataInput in) throws IOException {
        String coveredClassFQN = in.readUTF();
        String coveredMethodName = in.readUTF();
        String access = in.readUTF();
        boolean inverseAccess = in.readBoolean();
        if (!access.isEmpty()) {
            return PhpPathInfo.byAccess(coveredClassFQN, access, inverseAccess);
        }
        if (!coveredMethodName.isEmpty()) {
            return PhpPathInfo.byMethod(coveredClassFQN, coveredMethodName);
        }
        return PhpPathInfo.byClass(coveredClassFQN);
    }

    public static void saveItem(DataOutput out, PhpPathInfo value) throws IOException {
        out.writeUTF(value.getClassFQN());
        out.writeUTF(value.getMethodName());
        out.writeUTF(value.getAccess());
        out.writeBoolean(value.isInverseAccess());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpPathInfoSetExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

