/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class ThreeStateCheckBox
extends JCheckBox {
    public static final String THREE_STATE_CHECKBOX_STATE = "ThreeStateCheckbox.state";
    private State myState;
    private boolean myThirdStateEnabled = true;

    public ThreeStateCheckBox() {
        this(null, null, State.DONT_CARE);
    }

    public ThreeStateCheckBox(State initial) {
        this(null, null, initial);
    }

    public ThreeStateCheckBox(String text) {
        this(text, null, State.DONT_CARE);
    }

    public ThreeStateCheckBox(String text, State initial) {
        this(text, null, initial);
    }

    public ThreeStateCheckBox(String text, Icon icon) {
        this(text, icon, State.DONT_CARE);
    }

    public ThreeStateCheckBox(String text, Icon icon, State initial) {
        super(text, icon);
        this.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public void setSelected(boolean selected) {
                ThreeStateCheckBox.this.setState(ThreeStateCheckBox.this.nextState());
                this.fireStateChanged();
                this.fireItemStateChanged(new ItemEvent(this, 701, this, 1));
            }

            @Override
            public boolean isSelected() {
                return ThreeStateCheckBox.this.myState == State.SELECTED || UIUtil.isUnderAquaLookAndFeel() && ThreeStateCheckBox.this.myState == State.DONT_CARE;
            }
        });
        this.setState(initial);
    }

    @NotNull
    protected State nextState() {
        State state = ThreeStateCheckBox.nextState(this.myState, this.myThirdStateEnabled);
        if (state == null) {
            ThreeStateCheckBox.$$$reportNull$$$0(0);
        }
        return state;
    }

    @NotNull
    public static State nextState(@NotNull State state, boolean thirdStateEnabled) {
        if (state == null) {
            ThreeStateCheckBox.$$$reportNull$$$0(1);
        }
        switch (state) {
            case SELECTED: {
                State state2 = State.NOT_SELECTED;
                if (state2 == null) {
                    ThreeStateCheckBox.$$$reportNull$$$0(2);
                }
                return state2;
            }
            case NOT_SELECTED: {
                if (thirdStateEnabled) {
                    State state3 = State.DONT_CARE;
                    if (state3 == null) {
                        ThreeStateCheckBox.$$$reportNull$$$0(3);
                    }
                    return state3;
                }
                State state4 = State.SELECTED;
                if (state4 == null) {
                    ThreeStateCheckBox.$$$reportNull$$$0(4);
                }
                return state4;
            }
        }
        State state5 = State.SELECTED;
        if (state5 == null) {
            ThreeStateCheckBox.$$$reportNull$$$0(5);
        }
        return state5;
    }

    public boolean isThirdStateEnabled() {
        return this.myThirdStateEnabled;
    }

    public void setThirdStateEnabled(boolean thirdStateEnabled) {
        this.myThirdStateEnabled = thirdStateEnabled;
    }

    @Override
    public void setSelected(boolean b) {
        this.setState(b ? State.SELECTED : State.NOT_SELECTED);
    }

    public void setState(State state) {
        State oldState = this.myState;
        this.myState = state;
        String value = state == State.DONT_CARE ? "indeterminate" : null;
        this.putClientProperty("JButton.selectedState", value);
        this.firePropertyChange(THREE_STATE_CHECKBOX_STATE, (Object)oldState, (Object)state);
        this.repaint();
    }

    public State getState() {
        return this.myState;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (UIUtil.isUnderAquaLookAndFeel() || UIUtil.isUnderDefaultMacTheme() || UIUtil.isUnderWin10LookAndFeel() || UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            return;
        }
        if (this.getState() == State.DONT_CARE) {
            Icon icon = this.getIcon();
            if (icon == null) {
                icon = UIManager.getIcon("CheckBox.icon");
            }
            if (UIUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
                icon = JBUI.scale(EmptyIcon.create(20, 18));
            }
            if (icon != null) {
                Insets i = this.getInsets();
                Rectangle r = this.getBounds();
                Rectangle r1 = new Rectangle();
                r1.x = i.left;
                r1.y = i.top;
                r1.width = r.width - (i.right + r1.x);
                r1.height = r.height - (i.bottom + r1.y);
                Rectangle r2 = new Rectangle();
                Rectangle r3 = new Rectangle();
                SwingUtilities.layoutCompoundLabel(this, this.getFontMetrics(this.getFont()), this.getText(), icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), r1, r2, r3, this.getText() == null ? 0 : this.getIconTextGap());
                g.setColor(UIUtil.getTreeForeground());
                int height = r2.height / 10;
                int width = r2.width / 3;
                g.fillRect(r2.x + r2.width / 2 - width / 2, r2.y + r2.height / 2 - height / 2, width, height);
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleThreeStateCheckBox();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/ThreeStateCheckBox";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "nextState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/ThreeStateCheckBox";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "nextState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class AccessibleThreeStateCheckBox
    extends JCheckBox.AccessibleJCheckBox {
        protected AccessibleThreeStateCheckBox() {
            super(ThreeStateCheckBox.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            if (ThreeStateCheckBox.this.myThirdStateEnabled) {
                return AccessibleRole.TOGGLE_BUTTON;
            }
            return super.getAccessibleRole();
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            if (ThreeStateCheckBox.this.myThirdStateEnabled) {
                AccessibleStateSet set = super.getAccessibleStateSet();
                set.remove(AccessibleState.CHECKED);
                return set;
            }
            return super.getAccessibleStateSet();
        }

        @Override
        public String getAccessibleName() {
            if (ThreeStateCheckBox.this.myThirdStateEnabled) {
                return this.addStateDescription(super.getAccessibleName());
            }
            return super.getAccessibleName();
        }

        private String addStateDescription(String name) {
            switch (ThreeStateCheckBox.this.getState()) {
                case SELECTED: {
                    return AccessibleContextUtil.combineAccessibleStrings(name, "checked");
                }
                case NOT_SELECTED: {
                    return AccessibleContextUtil.combineAccessibleStrings(name, "not checked");
                }
                case DONT_CARE: {
                    return AccessibleContextUtil.combineAccessibleStrings(name, "partially checked");
                }
            }
            return name;
        }
    }

    public static enum State {
        SELECTED,
        NOT_SELECTED,
        DONT_CARE;

    }
}

