/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.ex;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class FileEditorManagerEx
extends FileEditorManager
implements BusyObject {
    private final List<EditorDataProvider> myDataProviders = new ArrayList<EditorDataProvider>();

    public static FileEditorManagerEx getInstanceEx(@NotNull Project project) {
        if (project == null) {
            FileEditorManagerEx.$$$reportNull$$$0(0);
        }
        return (FileEditorManagerEx)FileEditorManagerEx.getInstance((Project)project);
    }

    public abstract JComponent getComponent();

    @Nullable
    public abstract JComponent getPreferredFocusedComponent();

    @NotNull
    public abstract Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getFile(@NotNull FileEditor var1);

    public abstract void updateFilePresentation(@NotNull VirtualFile var1);

    public abstract EditorWindow getCurrentWindow();

    @NotNull
    public abstract Promise<EditorWindow> getActiveWindow();

    public abstract void setCurrentWindow(EditorWindow var1);

    public abstract void closeFile(@NotNull VirtualFile var1, @NotNull EditorWindow var2);

    public abstract void unsplitWindow();

    public abstract void unsplitAllWindow();

    public abstract int getWindowSplitCount();

    public abstract boolean hasSplitOrUndockedWindows();

    @NotNull
    public abstract EditorWindow[] getWindows();

    @NotNull
    public abstract VirtualFile[] getSiblings(@NotNull VirtualFile var1);

    public abstract void createSplitter(int var1, @Nullable EditorWindow var2);

    public abstract void changeSplitterOrientation();

    public abstract void flipTabs();

    public abstract boolean tabsMode();

    public abstract boolean isInSplitter();

    public abstract boolean hasOpenedFile();

    @Nullable
    public abstract VirtualFile getCurrentFile();

    @Nullable
    public abstract FileEditorWithProvider getSelectedEditorWithProvider(@NotNull VirtualFile var1);

    public abstract void closeAllFiles();

    @NotNull
    public abstract EditorsSplitters getSplitters();

    @NotNull
    public FileEditor[] openFile(@NotNull VirtualFile file2, boolean focusEditor) {
        if (file2 == null) {
            FileEditorManagerEx.$$$reportNull$$$0(1);
        }
        FileEditor[] fileEditorArray = (FileEditor[])this.openFileWithProviders(file2, focusEditor, false).getFirst();
        if (fileEditorArray == null) {
            FileEditorManagerEx.$$$reportNull$$$0(2);
        }
        return fileEditorArray;
    }

    @NotNull
    public FileEditor[] openFile(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForOpen) {
        if (file2 == null) {
            FileEditorManagerEx.$$$reportNull$$$0(3);
        }
        FileEditor[] fileEditorArray = (FileEditor[])this.openFileWithProviders(file2, focusEditor, searchForOpen).getFirst();
        if (fileEditorArray == null) {
            FileEditorManagerEx.$$$reportNull$$$0(4);
        }
        return fileEditorArray;
    }

    @NotNull
    public abstract Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile var1, boolean var2, boolean var3);

    @NotNull
    public abstract Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile var1, boolean var2, @NotNull EditorWindow var3);

    public abstract boolean isChanged(@NotNull EditorComposite var1);

    public abstract EditorWindow getNextWindow(@NotNull EditorWindow var1);

    public abstract EditorWindow getPrevWindow(@NotNull EditorWindow var1);

    public abstract boolean isInsideChange();

    @Nullable
    public final Object getData(@NotNull String dataId, @NotNull Editor editor, @NotNull Caret caret) {
        if (dataId == null) {
            FileEditorManagerEx.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            FileEditorManagerEx.$$$reportNull$$$0(6);
        }
        if (caret == null) {
            FileEditorManagerEx.$$$reportNull$$$0(7);
        }
        for (EditorDataProvider dataProvider : this.myDataProviders) {
            Object o = dataProvider.getData(dataId, editor, caret);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public void registerExtraEditorDataProvider(@NotNull EditorDataProvider provider, Disposable parentDisposable) {
        if (provider == null) {
            FileEditorManagerEx.$$$reportNull$$$0(8);
        }
        this.myDataProviders.add(provider);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, () -> {
                if (provider == null) {
                    FileEditorManagerEx.$$$reportNull$$$0(11);
                }
                this.myDataProviders.remove(provider);
            });
        }
    }

    public void refreshIcons() {
        if (this instanceof FileEditorManagerImpl) {
            FileEditorManagerImpl mgr = (FileEditorManagerImpl)this;
            Set<EditorsSplitters> splitters = mgr.getAllSplitters();
            for (EditorsSplitters each : splitters) {
                for (VirtualFile file2 : mgr.getOpenFiles()) {
                    each.updateFileIcon(file2);
                }
            }
        }
    }

    public abstract EditorsSplitters getSplittersFor(Component var1);

    @NotNull
    public abstract ActionCallback notifyPublisher(@NotNull Runnable var1);

    public void runWhenLoaded(@NotNull Editor editor, @NotNull Runnable runnable2) {
        if (editor == null) {
            FileEditorManagerEx.$$$reportNull$$$0(9);
        }
        if (runnable2 == null) {
            FileEditorManagerEx.$$$reportNull$$$0(10);
        }
        AsyncEditorLoader.performWhenLoaded(editor, runnable2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/ex/FileEditorManagerEx";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/ex/FileEditorManagerEx";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "openFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceEx";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerExtraEditorDataProvider";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runWhenLoaded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$registerExtraEditorDataProvider$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

