/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.scheme;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssDescriptorOwner;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssMediaFeatureDescriptor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssValueOwnerDescriptor;
import com.intellij.psi.css.descriptor.value.CssAnyValue;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueMatchData;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.impl.descriptor.value.CssGroupValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueValidatorImpl;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssElementDescriptorFactory;
import com.intellij.psi.css.resolve.HtmlCssClassOrIdReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.lang.ref.Reference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssElementDescriptorProviderImpl
extends CssElementDescriptorProvider {
    private static final String[] KEYFRAMES_SELECTORS = new String[]{"to", "from"};
    private Reference<Set<String>> myHtmlTags;
    private long myCacheStamp = 0L;

    public boolean isMyContext(@Nullable PsiElement context) {
        return true;
    }

    @Nullable
    public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(0);
        }
        return CssElementDescriptorFactory.getDescriptor(propertyName);
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name, @Nullable PsiElement context) {
        if (name == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(1);
        }
        Collection<CssPseudoSelectorDescriptor> collection = CssElementDescriptorProviderImpl.factory().findPseudoSelector(name);
        if (collection == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssValueDescriptor> getNamedValueDescriptors(@NotNull String name, @Nullable CssValueDescriptor parent) {
        if (name == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(3);
        }
        Collection<CssValueDescriptor> collection = CssElementDescriptorProviderImpl.factory().findNamedValue(name, parent);
        if (collection == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        CssElementDescriptorFactory2 descriptorFactory;
        Collection<CssPropertyDescriptor> result;
        if (propertyName == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(5);
        }
        if (!(result = (descriptorFactory = CssElementDescriptorProviderImpl.factory()).findProperty(propertyName)).isEmpty()) {
            Collection<CssPropertyDescriptor> collection = result;
            if (collection == null) {
                CssElementDescriptorProviderImpl.$$$reportNull$$$0(6);
            }
            return collection;
        }
        if (propertyName.length() > 1 && CssUtil.isHackPropertyName(propertyName)) {
            Collection<CssPropertyDescriptor> collection = descriptorFactory.findProperty(propertyName.substring(1));
            if (collection == null) {
                CssElementDescriptorProviderImpl.$$$reportNull$$$0(7);
            }
            return collection;
        }
        List list = Collections.emptyList();
        if (list == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
        Collection propertyDescriptors;
        CssDeclaration declaration;
        if (functionName == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(9);
        }
        CssFunction function = (CssFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssFunction.class});
        if (functionName.equalsIgnoreCase("toggle") && (declaration = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context, CssDeclaration.class)) != null && !(propertyDescriptors = declaration.getDescriptors()).isEmpty()) {
            List list = ContainerUtil.map((Collection)propertyDescriptors, descriptor -> CssElementDescriptorProviderImpl.factory().createToggleFunctionDescriptorFromPropertyDescriptor((CssPropertyDescriptor)descriptor));
            if (list == null) {
                CssElementDescriptorProviderImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        if (functionName.equalsIgnoreCase("var") && function != null) {
            HashSet result = ContainerUtil.newHashSet();
            CssDescriptorOwner descriptorOwner = (CssDescriptorOwner)PsiTreeUtil.getParentOfType((PsiElement)context, CssDescriptorOwner.class);
            PsiElement functionTerm = function.getParent();
            if (descriptorOwner instanceof CssValueOwner && functionTerm instanceof CssTerm) {
                CssTermList value = ((CssValueOwner)descriptorOwner).getValue();
                Collection descriptors = descriptorOwner.getDescriptors();
                if (value != null && !descriptors.isEmpty()) {
                    result.addAll(ContainerUtil.mapNotNull((Collection)descriptors, descriptor -> {
                        CssValueDescriptor valueDescriptor;
                        CssValueMatchData valueMatchData;
                        CssValueDescriptor descriptorForFunction;
                        if (descriptor instanceof CssValueOwnerDescriptor && (descriptorForFunction = (valueMatchData = value.matchWithValueDescriptor(valueDescriptor = ((CssValueOwnerDescriptor)descriptor).getValueDescriptor())).findDeepestDescriptorForElement(functionTerm)) != null) {
                            CssValueDescriptor parentDescriptor = descriptorForFunction.getParent();
                            while (parentDescriptor instanceof CssGroupValue && ((CssGroupValue)parentDescriptor).getType() == CssGroupValue.Type.OR) {
                                descriptorForFunction = parentDescriptor;
                                parentDescriptor = descriptorForFunction.getParent();
                            }
                            return CssElementDescriptorProviderImpl.factory().createVarFunctionDescriptorFromPropertyDescriptors(descriptorForFunction);
                        }
                        return null;
                    }));
                }
            }
            if (result.isEmpty()) {
                CssAnyValue valueDescriptor = CssElementDescriptorProviderImpl.factory().createAnyValueDescriptor(1, 1, null);
                result.add(CssElementDescriptorProviderImpl.factory().createVarFunctionDescriptorFromPropertyDescriptors((CssValueDescriptor)valueDescriptor));
            }
            HashSet hashSet = result;
            if (hashSet == null) {
                CssElementDescriptorProviderImpl.$$$reportNull$$$0(11);
            }
            return hashSet;
        }
        Collection<CssFunctionDescriptor> collection = CssElementDescriptorProviderImpl.factory().findFunction(functionName);
        if (collection == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssMediaFeatureDescriptor> findMediaFeatureDescriptors(@NotNull String mediaFeatureName, @Nullable PsiElement context) {
        if (mediaFeatureName == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(13);
        }
        Collection<CssMediaFeatureDescriptor> collection = CssElementDescriptorProviderImpl.factory().findMediaFeature(mediaFeatureName);
        if (collection == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(14);
        }
        return collection;
    }

    private static CssElementDescriptorFactory2 factory() {
        return CssElementDescriptorFactory2.getInstance();
    }

    public boolean isPossibleSelector(@NotNull String selector, @NotNull PsiElement context) {
        if (selector == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(15);
        }
        if (context == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(16);
        }
        return super.isPossibleSelector(selector.toLowerCase(Locale.US), context);
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        Collection collection = CssDescriptorsUtil.filterDescriptorsByContext((Collection)CssElementDescriptorProviderImpl.factory().getPseudoSelectors().values(), (PsiElement)context);
        if (collection == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> getAllPropertyDescriptors(@Nullable PsiElement context) {
        Collection collection = CssDescriptorsUtil.filterDescriptorsByMediaType((Collection)CssDescriptorsUtil.filterDescriptorsByContext((Collection)CssElementDescriptorProviderImpl.factory().getProperties().values(), (PsiElement)context), (PsiElement)context);
        if (collection == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssMediaFeatureDescriptor> getAllMediaFeatureDescriptors(@Nullable PsiElement context) {
        Collection collection = CssDescriptorsUtil.filterDescriptorsByMediaType((Collection)CssDescriptorsUtil.filterDescriptorsByContext((Collection)CssElementDescriptorProviderImpl.factory().getMediaFeatures().values(), (PsiElement)context), (PsiElement)context);
        if (collection == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public String[] getSimpleSelectors(@NotNull PsiElement context) {
        if (context == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(20);
        }
        if (CssUtil.isInsideKeyframes(context)) {
            if (KEYFRAMES_SELECTORS == null) {
                CssElementDescriptorProviderImpl.$$$reportNull$$$0(21);
            }
            return KEYFRAMES_SELECTORS;
        }
        if (CssUtil.isInsideFontFace(context) || CssUtil.isInsidePageRuleset(context)) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                CssElementDescriptorProviderImpl.$$$reportNull$$$0(22);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = this.getHtmlTags(context);
        if (stringArray == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    @NotNull
    public PsiElement[] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(24);
        }
        PsiElement[] psiElementArray = new PsiElement[]{selector};
        if (psiElementArray == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(25);
        }
        return psiElementArray;
    }

    @NotNull
    public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
        HtmlCssClassOrIdReference htmlCssClassOrIdReference = new HtmlCssClassOrIdReference(element, start, end, caseSensitive, true);
        if (htmlCssClassOrIdReference == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(26);
        }
        return htmlCssClassOrIdReference;
    }

    @NotNull
    public CssValueValidator getValueValidator() {
        CssValueValidatorImpl cssValueValidatorImpl = new CssValueValidatorImpl(this);
        if (cssValueValidatorImpl == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(27);
        }
        return cssValueValidatorImpl;
    }

    public CssContextType getCssContextType(@Nullable PsiElement context) {
        if (context == null) {
            return CssContextType.ANY;
        }
        CssAtRule atRule = (CssAtRule)PsiTreeUtil.getParentOfType((PsiElement)context, CssAtRule.class);
        if (atRule != null) {
            CssContextType atRuleType = atRule.getType();
            if (atRuleType == CssContextType.MEDIA || atRuleType == CssContextType.SUPPORTS || atRuleType == CssContextType.KEYFRAMES) {
                CssContextType parentContextType = this.getCssContextType((PsiElement)atRule);
                return parentContextType != CssContextType.NONE ? parentContextType : CssContextType.NONAME;
            }
            return atRuleType;
        }
        CssRuleset ruleset = (CssRuleset)PsiTreeUtil.getParentOfType((PsiElement)context, CssRuleset.class);
        if (ruleset != null) {
            return CssContextType.NONAME;
        }
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
        if (attribute != null && "style".equalsIgnoreCase(attribute.getName())) {
            return CssContextType.NONAME;
        }
        return CssContextType.NONE;
    }

    public boolean shouldAskOtherProviders(@Nullable PsiElement context) {
        return false;
    }

    @NotNull
    private String[] getHtmlTags(@NotNull PsiElement context) {
        if (context == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(28);
        }
        HashSet tags = ContainerUtil.newHashSet();
        for (XmlElementDescriptor descriptor : HtmlUtil.getCustomTagDescriptors((PsiElement)context)) {
            tags.add(descriptor.getName());
        }
        Set cachedTags = (Set)SoftReference.dereference(this.myHtmlTags);
        ExternalResourceManager externalResourceManager = ExternalResourceManager.getInstance();
        if (cachedTags == null || externalResourceManager.getModificationCount() != this.myCacheStamp) {
            XmlNSDescriptor nsDescriptor;
            cachedTags = ContainerUtil.newHashSet();
            XmlTag htmlTag = XmlElementFactory.getInstance((Project)context.getProject()).createHTMLTagFromText("<div></div>");
            XmlElementDescriptor htmlTagDescriptor = htmlTag.getDescriptor();
            XmlNSDescriptor xmlNSDescriptor = nsDescriptor = htmlTagDescriptor != null ? htmlTagDescriptor.getNSDescriptor() : null;
            if (nsDescriptor != null) {
                XmlDocument document = ((XmlFile)htmlTag.getContainingFile()).getDocument();
                for (XmlElementDescriptor descriptor : nsDescriptor.getRootElementsDescriptors(document)) {
                    if (descriptor instanceof HtmlUtil.CustomXmlTagDescriptor) continue;
                    cachedTags.add(descriptor.getName());
                }
                this.myCacheStamp = externalResourceManager.getModificationCount();
                this.myHtmlTags = new SoftReference((Object)cachedTags);
            }
        }
        tags.addAll(cachedTags);
        String[] stringArray = ArrayUtil.toStringArray((Collection)tags);
        if (stringArray == null) {
            CssElementDescriptorProviderImpl.$$$reportNull$$$0(29);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mediaFeatureName";
                break;
            }
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 16: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/scheme/CssElementDescriptorProviderImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findPseudoSelectorDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedValueDescriptors";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertyDescriptors";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findFunctionDescriptors";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findMediaFeatureDescriptors";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPseudoSelectorDescriptors";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertyDescriptors";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMediaFeatureDescriptors";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleSelectors";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsForSimpleSelector";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleReference";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueValidator";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findPseudoSelectorDescriptors";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNamedValueDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyDescriptors";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionDescriptors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findMediaFeatureDescriptors";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPossibleSelector";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleSelectors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsForSimpleSelector";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getHtmlTags";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

