/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionEstablisher;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SimpleDatabaseConnection;
import com.intellij.database.dataSource.connection.ConnectionRequestor;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.ui.LocalDbParamEditor;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TObjectHashingStrategy;
import java.rmi.RemoteException;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseConnectionManager {
    private static final Logger LOG = Logger.getInstance(DatabaseConnectionManager.class);
    private static ConnectInterceptor ourInterceptor = null;
    public static final Topic<Listener> TOPIC = Topic.create((String)"DatabaseConnectionManager.Listener", Listener.class);
    public static final String SSH_HOST = "localhost";
    private final Listener myPublisher = (Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC);
    private final Set<DatabaseConnection> myConnections = ConcurrentCollectionFactory.createConcurrentSet((TObjectHashingStrategy)ContainerUtil.identityStrategy());

    @NotNull
    public static DatabaseConnectionManager getInstance() {
        DatabaseConnectionManager databaseConnectionManager = (DatabaseConnectionManager)ServiceManager.getService(DatabaseConnectionManager.class);
        if (databaseConnectionManager == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(0);
        }
        return databaseConnectionManager;
    }

    @NotNull
    public Builder build(@NotNull Project project, @NotNull DatabaseConnectionPoint connectionPoint) {
        if (project == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(1);
        }
        if (connectionPoint == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(2);
        }
        Builder builder = new Builder(project, connectionPoint);
        if (builder == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(3);
        }
        return builder;
    }

    public static void setInterceptor(ConnectInterceptor interceptor) {
        assert (ourInterceptor == null || interceptor == null) : "Already have interceptor";
        ourInterceptor = interceptor;
    }

    @Nullable
    public static String getSpecialMessage(@NotNull Throwable t, @NotNull String processName) {
        if (t == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(4);
        }
        if (processName == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(5);
        }
        Throwable cause = ExceptionUtil.getRootCause((Throwable)t);
        boolean remote = ExceptionUtil.causedBy((Throwable)t, RemoteException.class);
        String message2 = cause.getMessage();
        if (message2 == null) {
            return null;
        }
        if (cause instanceof SQLException && StringUtil.contains((CharSequence)message2, (CharSequence)"ORA-12705:")) {
            return DatabaseMessages.message((String)"error.message.ora.nls", (Object[])new Object[]{processName});
        }
        if (cause instanceof OutOfMemoryError && remote) {
            return DatabaseMessages.message((String)"error.message.remote.oomerror", (Object[])new Object[]{processName});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useDriver(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull ThrowableConsumer<Driver, Exception> user) throws Exception {
        if (project == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(6);
        }
        if (dataSource == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(7);
        }
        if (user == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(8);
        }
        JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(project);
        Driver driver = driverManager.getDriver(dataSource, driverManager.getDefaultRunConfiguration(dataSource));
        try {
            user.consume((Object)driver);
        }
        finally {
            DatabaseConnectionManager.releaseDriver(driverManager, dataSource);
        }
    }

    @Nullable
    public static String getEffectiveUrl(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull JdbcDriverManager driverManager) {
        Integer localPort;
        JdbcUrlParser parser;
        if (connectionPoint == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(9);
        }
        if (driverManager == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(10);
        }
        final String localDbInst = connectionPoint.getAdditionalJdbcProperties().get("LOCAL_DB_INSTANCE");
        final String localDbExec = connectionPoint.getAdditionalJdbcProperties().get("LOCAL_DB_EXECUTABLE");
        DatabaseDriver driver = connectionPoint.getDatabaseDriver();
        String url = connectionPoint.getUrl();
        if (driver == null || url == null) {
            return url;
        }
        if (localDbExec != null && localDbInst != null && (parser = JdbcUrlParserUtil.stateful(JdbcUrlParserUtil.select(driver.getJDBCUrlParsers(), url))) != null && parser.getParameters().contains("localdb_pipe")) {
            parser.setUrlText(url);
            if (parser.isValid()) {
                final Ref pipe = Ref.create();
                UIUtil.invokeAndWaitIfNeeded(() -> (new Task.Modal(null, "Actualizing LocalDB Instance Info", true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        pipe.set((Object)LocalDbParamEditor.getPipeForInstance(localDbInst, localDbExec, indicator));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseConnectionManager$1", "run"));
                    }
                }).queue());
                if (!StringUtil.isEmpty((String)((String)pipe.get()))) {
                    parser.setParameter("localdb_pipe", (String)pipe.get());
                    return parser.getUrlText();
                }
            }
        }
        if ((localPort = driverManager.getLocalPort(connectionPoint.getDataSource())) == null) {
            return url;
        }
        Ref parser2 = Ref.create();
        Pair.NonNull<String, String> hostPort = JdbcUrlParserUtil.extractHostPort(driver.getJDBCUrlParsers(), StringUtil.notNullize((String)url), (Ref<JdbcUrlParser>)parser2);
        if (hostPort == null) {
            return url;
        }
        ((JdbcUrlParser)parser2.get()).setParameter("host", SSH_HOST);
        ((JdbcUrlParser)parser2.get()).setParameter("port", String.valueOf(localPort));
        return ((JdbcUrlParser)parser2.get()).getUrlText();
    }

    private void releaseConnection(JdbcDriverManager driverManager, @NotNull DatabaseConnection connection2) {
        if (connection2 == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(11);
        }
        this.myConnections.remove(connection2);
        JdbcUtil.closeSafe((AutoCloseable)((SimpleDatabaseConnection)connection2).release());
        try {
            DatabaseConnectionManager.releaseDriver(driverManager, connection2.getConnectionPoint().getDataSource());
        }
        finally {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (connection2 == null) {
                    DatabaseConnectionManager.$$$reportNull$$$0(22);
                }
                this.myPublisher.connectionChanged(connection2, false);
            }, ModalityState.any());
        }
    }

    private static void releaseDriver(JdbcDriverManager driverManager, LocalDataSource dataSource) {
        if (dataSource.getUniqueId() == null) {
            driverManager.releaseDriver(dataSource, null);
        }
    }

    public static void handleConnectionError(@NotNull Throwable e, @NotNull ErrorHandler errorHandler, @NotNull String dsName) {
        if (e == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(12);
        }
        if (errorHandler == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(13);
        }
        if (dsName == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(14);
        }
        if (e instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)e;
        }
        if (e instanceof CompletionException) {
            e = e.getCause();
        }
        if (e instanceof SQLException) {
            errorHandler.addError(StringUtil.notNullize((String)DatabaseConnectionManager.getSpecialMessage(e, dsName), (String)DatabaseMessages.message((String)"message.text.cant.establish.connection.to", (Object[])new Object[]{dsName})), e);
        } else if (e instanceof ClassNotFoundException) {
            errorHandler.addError(DatabaseMessages.message((String)"message.driver.class.not.found.text", (Object[])new Object[]{e.getMessage()}), null);
        } else if (e instanceof ExecutionException) {
            Matcher matcher = Pattern.compile("java\\.lang\\.(ClassNotFoundException|InstantiationException):\\s+((?:\\w+\\.)*\\w+)").matcher(e.getMessage());
            if (matcher.find()) {
                if ("InstantiationException".equals(matcher.group(1))) {
                    errorHandler.addError(DatabaseMessages.message((String)"message.driver.class.not.instantiable", (Object[])new Object[]{matcher.group(2)}), null);
                } else {
                    errorHandler.addError(DatabaseMessages.message((String)"message.driver.class.not.found.text", (Object[])new Object[]{matcher.group(2)}), null);
                }
            } else {
                matcher = Pattern.compile(Pattern.quote("Missing native authentication library: ") + "(.*)").matcher(e.getMessage());
                if (matcher.find()) {
                    errorHandler.addError("Missing native authentication library: " + matcher.group(1) + "\nEnsure that supplied driver is up to date or jar with native library is added", null);
                } else {
                    errorHandler.addError(DatabaseMessages.message((String)"message.text.cant.establish.connection.because.of.error", (Object[])new Object[]{dsName, e.getMessage()}), e);
                }
            }
        } else if (e instanceof UnsatisfiedLinkError) {
            errorHandler.addError(DatabaseMessages.message((String)"message.text.native.library.cannot.be.loaded", (Object[])new Object[]{e.getMessage()}), e);
        } else if (e.getClass().getName().equals("com.jcraft.jsch.JSchException")) {
            errorHandler.addError("SSH tunnel creation failed:", e);
        } else {
            errorHandler.addError(DatabaseConnectionManager.getSpecialMessage(e, dsName), e);
        }
    }

    public static CompletionStage<DatabaseConnection> establishConnection(@NotNull DatabaseConnectionPoint connectionPoint, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull ConnectionRequestor requestor, @NotNull Project project, boolean askPassword) {
        if (connectionPoint == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(15);
        }
        if (runConfiguration == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(16);
        }
        if (requestor == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(17);
        }
        if (project == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(18);
        }
        return DatabaseConnectionEstablisher.establishConnection(connectionPoint, runConfiguration, requestor, project, askPassword);
    }

    @NotNull
    public List<DatabaseConnection> getActiveConnections() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.myConnections);
        if (arrayList == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    public void terminateConnections(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
        if (dataSource == null) {
            DatabaseConnectionManager.$$$reportNull$$$0(20);
        }
        List toTerminate = ContainerUtil.filter(this.myConnections, c2 -> {
            if (dataSource == null) {
                DatabaseConnectionManager.$$$reportNull$$$0(21);
            }
            return c2.getConnectionPoint().getDataSource() == dataSource && (configuration == null || c2.getConfiguration() == configuration);
        });
        for (DatabaseConnection connection2 : toTerminate) {
            ((SimpleDatabaseConnection)connection2).cancelAll();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseConnectionManager";
                break;
            }
            case 1: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectionPoint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processName";
                break;
            }
            case 7: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "user";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driverManager";
                break;
            }
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandler";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dsName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseConnectionManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveConnections";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialMessage";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "useDriver";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveUrl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "releaseConnection";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "handleConnectionError";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "establishConnection";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "terminateConnections";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$terminateConnections$1";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$releaseConnection$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Executor {
        private final Project myProject;
        private final ConsoleRunConfiguration myRunConfiguration;
        private final DatabaseConnectionPoint myConnectionPoint;
        private final ConnectionRequestor myRequestor;
        private final boolean myAskPassword;

        private Executor(Builder b2) {
            if (b2 == null) {
                Executor.$$$reportNull$$$0(0);
            }
            this.myProject = b2.getProject();
            this.myConnectionPoint = b2.getConnectionPoint();
            this.myRunConfiguration = b2.getRunConfiguration();
            this.myAskPassword = b2.getAskPassword();
            this.myRequestor = b2.getRequestor();
        }

        @NotNull
        public <T> CompletionStage<T> async(@NotNull Operation<T> user, @NotNull ErrorHandler errorHandler) {
            if (user == null) {
                Executor.$$$reportNull$$$0(1);
            }
            if (errorHandler == null) {
                Executor.$$$reportNull$$$0(2);
            }
            JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(this.myProject);
            CompletionStage<Object> completionStage = this.supplyAsync().handle((r, e) -> {
                if (errorHandler == null) {
                    Executor.$$$reportNull$$$0(13);
                }
                if (e == null) {
                    return r;
                }
                if (!AsyncUtil.isCancellation(e)) {
                    DatabaseConnectionManager.handleConnectionError(e, errorHandler, this.myConnectionPoint.getName());
                }
                throw new ProcessCanceledException();
            }).thenApply(AsyncUtil.captureIndicator(connection2 -> {
                if (errorHandler == null) {
                    Executor.$$$reportNull$$$0(11);
                }
                if (user == null) {
                    Executor.$$$reportNull$$$0(12);
                }
                try {
                    Object t = this.perform((DatabaseConnection)connection2, errorHandler, user);
                    return t;
                }
                finally {
                    this.release(driverManager, (DatabaseConnection)connection2);
                }
            }));
            if (completionStage == null) {
                Executor.$$$reportNull$$$0(3);
            }
            return completionStage;
        }

        public <T> T sync(@NotNull Operation<T> user, @NotNull ErrorHandler errorHandler) {
            if (user == null) {
                Executor.$$$reportNull$$$0(4);
            }
            if (errorHandler == null) {
                Executor.$$$reportNull$$$0(5);
            }
            return AsyncUtil.withAsyncFriendly(ProgressIndicatorProvider.getGlobalProgressIndicator(), () -> {
                if (errorHandler == null) {
                    Executor.$$$reportNull$$$0(9);
                }
                if (user == null) {
                    Executor.$$$reportNull$$$0(10);
                }
                try (GuardedRef<DatabaseConnection> ref = this.createInner();){
                    Object t = this.perform(ref == null ? null : ref.get(), errorHandler, user);
                    return t;
                }
                catch (Throwable e) {
                    if (AsyncUtil.isCancellation(e)) throw new ProcessCanceledException();
                    DatabaseConnectionManager.handleConnectionError(e, errorHandler, this.myConnectionPoint.getName());
                    throw new ProcessCanceledException();
                }
            });
        }

        @Nullable
        private GuardedRef<DatabaseConnection> create() throws SQLException {
            return (GuardedRef)AsyncUtil.withAsyncFriendly(ProgressIndicatorProvider.getGlobalProgressIndicator(), () -> this.createInner());
        }

        @Nullable
        private GuardedRef<DatabaseConnection> createInner() throws SQLException {
            CompletionStage<DatabaseConnection> connectionFuture = this.supplyAsync();
            final JdbcDriverManager driverManager = JdbcDriverManager.getDriverManager(this.myProject);
            try {
                DatabaseConnection connection2 = connectionFuture.toCompletableFuture().get();
                return connection2 == null ? null : new GuardedRef<DatabaseConnection>(connection2){

                    @Override
                    protected void close(@NotNull DatabaseConnection ref) {
                        if (ref == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        Executor.this.release(driverManager, ref);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/database/dataSource/DatabaseConnectionManager$Executor$1", "close"));
                    }
                };
            }
            catch (InterruptedException e) {
                connectionFuture.whenComplete((c2, ex) -> {
                    try {
                        this.release(driverManager, (DatabaseConnection)c2);
                    }
                    catch (Throwable er) {
                        LOG.warn(er);
                    }
                });
                Thread.currentThread().interrupt();
                throw new ProcessCanceledException();
            }
            catch (Exception e) {
                Throwable t = AsyncUtil.unwrap(e);
                if (t instanceof SQLException) {
                    throw (SQLException)t;
                }
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
                return null;
            }
        }

        private void release(@NotNull JdbcDriverManager driverManager, @NotNull DatabaseConnection ref) {
            if (driverManager == null) {
                Executor.$$$reportNull$$$0(6);
            }
            if (ref == null) {
                Executor.$$$reportNull$$$0(7);
            }
            DatabaseConnectionManager.this.releaseConnection(driverManager, ref);
        }

        @Nullable
        private <T> T perform(DatabaseConnection connection2, ErrorHandler errorHandler, Operation<T> op) {
            if (connection2 == null) {
                errorHandler.addError(DatabaseMessages.message((String)"wrong.driver.specified", (Object[])new Object[0]), null);
                throw new ProcessCanceledException();
            }
            try {
                return op.perform(connection2);
            }
            catch (Exception e) {
                if (!AsyncUtil.isCancellation(e)) {
                    errorHandler.addError(DatabaseConnectionManager.getSpecialMessage(e, this.myConnectionPoint.getName()), e);
                }
                throw new ProcessCanceledException();
            }
        }

        @NotNull
        private CompletionStage<DatabaseConnection> supplyAsync() {
            CompletionStage<DatabaseConnection> completionStage;
            boolean wasIndeterminate;
            ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            boolean bl = wasIndeterminate = indicator != null && indicator.isIndeterminate();
            if (indicator != null) {
                indicator.checkCanceled();
                indicator.setText("Connecting to database...");
                indicator.setIndeterminate(false);
            }
            try {
                completionStage = this.establishConnection().whenComplete((r, e) -> {
                    if (r != null) {
                        DatabaseConnectionManager.this.myConnections.add(r);
                        ApplicationManager.getApplication().invokeLater(() -> DatabaseConnectionManager.this.myPublisher.connectionChanged((DatabaseConnection)r, true), ModalityState.any());
                    }
                    if (indicator != null) {
                        indicator.setIndeterminate(wasIndeterminate);
                    }
                });
            }
            catch (Error | RuntimeException e2) {
                if (indicator != null) {
                    indicator.setIndeterminate(wasIndeterminate);
                }
                throw e2;
            }
            if (completionStage == null) {
                Executor.$$$reportNull$$$0(8);
            }
            return completionStage;
        }

        private CompletionStage<DatabaseConnection> establishConnection() {
            ConnectionRequestor requestor;
            ConnectionRequestor connectionRequestor = requestor = this.myRequestor == null ? new ConnectionRequestor.Anonymous() : this.myRequestor;
            if (ourInterceptor != null) {
                return ourInterceptor.establishConnection(this.myConnectionPoint, this.myRunConfiguration, requestor, this.myProject, this.myAskPassword);
            }
            return DatabaseConnectionEstablisher.establishConnection(this.myConnectionPoint, this.myRunConfiguration, requestor, this.myProject, this.myAskPassword);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
                case 1: 
                case 4: 
                case 10: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "user";
                    break;
                }
                case 2: 
                case 5: 
                case 9: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorHandler";
                    break;
                }
                case 3: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseConnectionManager$Executor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "driverManager";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseConnectionManager$Executor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "async";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "supplyAsync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "async";
                    break;
                }
                case 3: 
                case 8: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "sync";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "release";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$sync$2";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$async$1";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$async$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class Builder {
        private final Project myProject;
        private DatabaseConnectionPoint myConnectionPoint;
        private boolean myAskPassword;
        private ConsoleRunConfiguration myRunConfiguration;
        private ConnectionRequestor myRequestor;

        public Builder(@NotNull Project project, DatabaseConnectionPoint point) {
            if (DatabaseConnectionManager.this == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (project == null) {
                Builder.$$$reportNull$$$0(1);
            }
            if (point == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myAskPassword = true;
            this.myProject = project;
            this.myConnectionPoint = point;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return project;
        }

        @NotNull
        public DatabaseConnectionPoint getConnectionPoint() {
            DatabaseConnectionPoint databaseConnectionPoint = this.myConnectionPoint;
            if (databaseConnectionPoint == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return databaseConnectionPoint;
        }

        public Builder setDestination(@Nullable ObjectPath path) {
            if (path != null) {
                this.myConnectionPoint = JdbcUrlParserUtil.connectedTo(this.myConnectionPoint, path);
            }
            return this;
        }

        public boolean getAskPassword() {
            return this.myAskPassword;
        }

        public Builder setAskPassword(boolean askPassword) {
            this.myAskPassword = askPassword;
            return this;
        }

        public Builder setRunConfiguration(ConsoleRunConfiguration runConfiguration) {
            this.myRunConfiguration = runConfiguration;
            return this;
        }

        @NotNull
        public ConsoleRunConfiguration getRunConfiguration() {
            ConsoleRunConfiguration consoleRunConfiguration = this.myRunConfiguration == null ? JdbcDriverManager.getDriverManager(this.myProject).getDefaultRunConfiguration(this.myConnectionPoint.getDataSource()) : this.myRunConfiguration;
            if (consoleRunConfiguration == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return consoleRunConfiguration;
        }

        @NotNull
        public Builder setRequestor(@NotNull ConnectionRequestor requestor) {
            if (requestor == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myRequestor = requestor;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        public ConnectionRequestor getRequestor() {
            return this.myRequestor;
        }

        @NotNull
        public <T> CompletionStage<T> async(@NotNull Operation<T> user, @NotNull ErrorHandler errorHandler) {
            if (user == null) {
                Builder.$$$reportNull$$$0(8);
            }
            if (errorHandler == null) {
                Builder.$$$reportNull$$$0(9);
            }
            CompletionStage<T> completionStage = new Executor(this).async(user, errorHandler);
            if (completionStage == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return completionStage;
        }

        public <T> T sync(@NotNull Operation<T> user, @NotNull ErrorHandler errorHandler) {
            if (user == null) {
                Builder.$$$reportNull$$$0(11);
            }
            if (errorHandler == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return new Executor(this).sync(user, errorHandler);
        }

        @Nullable
        public GuardedRef<DatabaseConnection> create() throws SQLException {
            return new Executor(this).create();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "this$0";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseConnectionManager$Builder";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestor";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "user";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseConnectionManager$Builder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectionPoint";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunConfiguration";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRequestor";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "async";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 10: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setRequestor";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "async";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "sync";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ConnectInterceptor {
        public CompletionStage<DatabaseConnection> establishConnection(@NotNull DatabaseConnectionPoint var1, @NotNull ConsoleRunConfiguration var2, @NotNull ConnectionRequestor var3, @NotNull Project var4, boolean var5);
    }

    public static interface Operation<T> {
        public T perform(@NotNull DatabaseConnection var1) throws Exception;
    }

    public static interface Listener {
        public void connectionChanged(@NotNull DatabaseConnection var1, boolean var2);
    }
}

