/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oraplus;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.base.BidirectionalTokenMapper;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.oracle.OracleParser;
import com.intellij.sql.dialects.oraplus.OraPlusDialect;
import com.intellij.sql.dialects.oraplus.OraPlusGeneratedParser;
import com.intellij.sql.dialects.oraplus.OraPlusTokens;
import com.intellij.sql.psi.SqlTokens;
import java.util.regex.Pattern;

public class OraPlusParser
extends OracleParser {
    private static final Pattern PARAM_PATTERN = Pattern.compile("&\\d+");
    private static final BidirectionalTokenMapper TOKEN_MAPPER = BidirectionalTokenMapper.builder().add((IElementType)OraPlusTokens.ORAP_WS_DELIMITER_TOKEN, (IElementType)ORAP_DELIMITER_TOKEN).build();
    private boolean myPlusContext = true;

    public OraPlusParser() {
        super(OraPlusDialect.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        this.setPlusContext(builder, true);
        if (OraPlusGeneratedParser.root_statement(builder, level)) {
            return true;
        }
        try {
            this.setPlusContext(builder, false);
            boolean bl = super.parseSqlStatement(builder, level);
            return bl;
        }
        finally {
            this.setPlusContext(builder, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseJdbcProcedureCall(PsiBuilder builder, int level) {
        boolean prev = this.myPlusContext;
        try {
            this.setPlusContext(builder, false);
            boolean bl = super.parseJdbcProcedureCall(builder, level);
            return bl;
        }
        finally {
            this.setPlusContext(builder, prev);
        }
    }

    @Override
    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result2;
        String tokenText = builder.getTokenText();
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_IDENT) && PARAM_PATTERN.matcher(tokenText).matches()) {
            this.consumeIdentifier(builder);
            result2 = SQL_PARAMETER_REFERENCE;
        } else {
            result2 = super.consumeCustomParameterReference(builder);
        }
        return result2;
    }

    @Override
    protected boolean parseExternalParameterImpl(PsiBuilder builder, boolean checkStart, boolean checkEnd) {
        if ((builder.getTokenType() == SQL_OP_BITWISE_AND || builder.getTokenType() == SQL_OP_LOGICAL_AND) && this.isIdentifierToken(builder, builder.rawLookup(1), true, false)) {
            PsiBuilder.Marker mark2 = builder.mark();
            IElementType lookup = builder.rawLookup(2);
            IElementType lookupup = builder.rawLookup(3);
            if (lookup == SQL_PERIOD && lookupup == SQL_PERIOD) {
                builder.advanceLexer();
            }
            builder.advanceLexer();
            builder.advanceLexer();
            mark2.done((IElementType)SQL_PARAMETER_REFERENCE);
            this.myExternalReferenceJustParsed = true;
            return true;
        }
        return super.parseExternalParameterImpl(builder, checkStart, checkEnd);
    }

    @Override
    protected boolean isWhitespace(IElementType type) {
        return type == SqlTokens.ORAP_DELIMITER_TOKEN || OraPlusTokens.WHITE_SPACE_TOKENS.contains(type);
    }

    @Override
    public boolean statementRecoverPrefixParser(PsiBuilder builder, int level) {
        return super.statementRecoverPrefixParser(builder, level) || OraPlusGeneratedParser.statement_recover_prefix(builder, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean statementRecover(PsiBuilder builder, int level, GeneratedParserUtilBase.Parser prefixParser) {
        boolean prev = this.myPlusContext;
        try {
            this.setPlusContext(builder, true);
            boolean bl = super.statementRecover(builder, level, prefixParser);
            return bl;
        }
        finally {
            this.setPlusContext(builder, prev);
        }
    }

    private void setPlusContext(PsiBuilder builder, boolean plus2) {
        this.myPlusContext = plus2;
        builder.setTokenTypeRemapper(plus2 ? TOKEN_MAPPER.getDirect() : TOKEN_MAPPER.getReverse());
    }
}

