/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.Shape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt$WhenMappings;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlLineComment;
import com.intellij.sql.formatter.model.SqlPostfixClauseBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0001\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rH\u0000\u001a\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0000\u00a8\u0006\u0013"}, d2={"autodetectDelimiter", "", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "flow", "", "Lcom/intellij/sql/formatter/model/SqlBlock;", "configureAttributesForCortege", "", "host", "Lcom/intellij/sql/formatter/model/SqlFlowBlock;", "configureAttributesForPostfixOptions", "blocks", "", "configureLineComments", "decideSpacingForCortege", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "intellij.database.sql.impl"})
public final class SqlCommonHandlersKt {
    public static final void configureAttributesForCortege(@NotNull SqlFlowBlock host) {
        Indent i2;
        Iterable $receiver$iv;
        Alignment a2;
        Alignment a1;
        boolean c1st;
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        List<SqlBlock> blocks = host.getNestedBlocks();
        SqlCodeStyleSettings s = host.getContext().getSql();
        Wrap w = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(host, WrapType.NORMAL, false, 2, null);
        boolean bl = c1st = host.userDelimiterSetting() == 1;
        if (c1st) {
            SqlBlock it;
            a1 = SqlFormattingModelFunKt.makeLeftAlignment();
            a2 = SqlFormattingModelFunKt.makeLeftAlignmentBS();
            $receiver$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)blocks, BlockRole.PREFIX);
            for (Object element$iv : $receiver$iv) {
                it = (SqlBlock)element$iv;
                it.setMyAlign(a1);
            }
            $receiver$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)blocks, BlockRole.DELIMITER);
            for (Object element$iv : $receiver$iv) {
                it = (SqlBlock)element$iv;
                it.setMyWrap(w);
                it.setMyAlign(a1);
            }
            $receiver$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)blocks, BlockRole.ELEMENT);
            for (Object element$iv : $receiver$iv) {
                it = (SqlBlock)element$iv;
                it.setMyAlign(a2);
            }
            i2 = SqlFormattingFunKt.getNONE_INDENT();
        } else {
            SqlBlock it;
            a1 = s.CORTEGE_CLOSING == 1 ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
            a2 = SqlFormattingModelFunKt.makeLeftAlignment();
            Indent indent = Indent.getSpaceIndent((int)(s.CORTEGE_SPACE_WITHIN_PARENTHESES ? 2 : 1), (boolean)true);
            Intrinsics.checkExpressionValueIsNotNull((Object)indent, (String)"Indent.getSpaceIndent(if\u2026ENTHESES) 2 else 1, true)");
            i2 = indent;
            JBIterable jBIterable = SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)blocks, BlockRole.ELEMENT).skip(1);
            Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"blocks.filter(ELEMENT).skip(1)");
            $receiver$iv = (Iterable)jBIterable;
            for (Object element$iv : $receiver$iv) {
                it = (SqlBlock)element$iv;
                it.setMyWrap(w);
            }
            $receiver$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)blocks, BlockRole.ELEMENT);
            for (Object element$iv : $receiver$iv) {
                it = (SqlBlock)element$iv;
                it.setMyIndent(i2);
                it.setMyAlign(a2);
            }
        }
        switch (s.CORTEGE_CLOSING) {
            case 1: {
                SqlBlock it;
                SqlBlock sqlBlock;
                SqlBlock sqlBlock2 = SqlFormattingModelFunKt.find((Iterable<? extends SqlBlock>)blocks, BlockRole.SUFFIX);
                if (sqlBlock2 != null) {
                    it = sqlBlock = sqlBlock2;
                    it.setMyWrap(w);
                    it.setMyIndent(Indent.getSpaceIndent((int)0, (boolean)true));
                    it.setMyAlign(a1);
                }
                break;
            }
            case 2: {
                SqlBlock sqlBlock;
                SqlBlock sqlBlock3 = SqlFormattingModelFunKt.find((Iterable<? extends SqlBlock>)blocks, BlockRole.SUFFIX);
                if (sqlBlock3 == null) break;
                SqlBlock it = sqlBlock = sqlBlock3;
                it.setMyWrap(w);
                it.setMyIndent(i2);
                it.setMyAlign(a2);
                break;
            }
        }
    }

    @Nullable
    public static final Spacing decideSpacingForCortege(@NotNull SqlFlowBlock host, @NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Spacing spacing;
        boolean collapse;
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)block1, (String)"block1");
        Intrinsics.checkParameterIsNotNull((Object)block2, (String)"block2");
        SqlFormattingContext context = host.getContext();
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        boolean sip = context.getSql().CORTEGE_SPACE_WITHIN_PARENTHESES;
        boolean c1st = host.userDelimiterSetting() == 1;
        boolean bl = collapse = host.getShape() == Shape.COLLAPSE;
        if (r1 == BlockRole.PREFIX) {
            spacing = context.makeSpace(sip);
        } else if (r2 == BlockRole.ELEMENT) {
            spacing = r1 == BlockRole.DELIMITER ? context.makeSpace(context.getSql().CORTEGE_SPACE_AFTER_COMMA, !c1st && !collapse) : SqlFormattingContext.makeSpace$default(context, false, !c1st, 1, null);
        } else if (r1 == BlockRole.DELIMITER) {
            spacing = context.makeSpace(context.getSql().CORTEGE_SPACE_AFTER_COMMA);
        } else if (r2 == BlockRole.DELIMITER) {
            spacing = context.makeSpace(context.getSql().CORTEGE_SPACE_BEFORE_COMMA, c1st && !collapse);
        } else if (r2 == BlockRole.SUFFIX) {
            switch (context.getSql().CORTEGE_CLOSING) {
                case 1: 
                case 2: {
                    spacing = SqlFormattingContext.makeSmartSpacing$default(context, host.getShape(), new TextRange(host.getRange().getStartOffset(), block2.getRange().getStartOffset()), sip, false, 8, null);
                    break;
                }
                case 9: {
                    spacing = context.makeSpace(sip);
                    break;
                }
                default: {
                    spacing = context.makeSpace(sip, !collapse);
                    break;
                }
            }
        } else {
            spacing = host.decideSpacing$intellij_database_sql_impl(block1, block2);
        }
        return spacing;
    }

    public static final void configureAttributesForPostfixOptions(@NotNull SqlFlowBlock host, @NotNull List<? extends SqlBlock> blocks) {
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull(blocks, (String)"blocks");
        SqlCodeStyleSettings s = host.getContext().getSql();
        Wrap postWrap1 = null;
        Wrap postWrap2 = null;
        Alignment postAlign = null;
        Iterable $receiver$iv$iv = $receiver$iv = (Iterable)blocks;
        JBIterable jBIterable = JBIterable.from((Iterable)$receiver$iv$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.filter(SqlPostfixClauseBlock.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
        $receiver$iv = (Iterable)jBIterable2;
        for (Object element$iv : $receiver$iv) {
            SqlPostfixClauseBlock it = (SqlPostfixClauseBlock)element$iv;
            if (postWrap1 == null) {
                postWrap1 = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(host, s.POST_OPT_WRAP_1 ? WrapType.ALWAYS : WrapType.NORMAL, false, 2, null);
                postAlign = s.POST_OPT_ALIGN ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
                it.setMyWrap(postWrap1);
                it.setMyIndent(s.POST_OPT_INDENT ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
                it.setMyAlign(postAlign);
                continue;
            }
            if (postWrap2 == null) {
                postWrap2 = SqlFlowBlock.makeWrap$intellij_database_sql_impl$default(host, postWrap1, s.POST_OPT_WRAP_2 ? WrapType.ALWAYS : WrapType.NORMAL, false, 4, null);
            }
            it.setMyWrap(postWrap2);
            it.setMyIndent(s.POST_OPT_INDENT ? SqlFormattingFunKt.getNORMAL_INDENT() : SqlFormattingFunKt.getNONE_INDENT());
            it.setMyAlign(postAlign);
        }
    }

    public static final void configureLineComments(@NotNull SqlFlowBlock host) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        JBIterable jBIterable = TreeTraversal.LEAVES_DFS.traversal((Object)host, (Function)configureLineComments.traversable.1.INSTANCE).filter(SqlLineComment.class).filter((Condition)configureLineComments.traversable.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)jBIterable, (String)"TreeTraversal.LEAVES_DFS\u2026r { !it.isWholeString() }");
        JBIterable traversable2 = jBIterable;
        Alignment a = null;
        for (SqlLineComment b2 : traversable2) {
            if (b2.getMyAlign() != null) continue;
            if (a == null) {
                a = SqlFormattingModelFunKt.makeLeftAlignmentBS();
            }
            b2.setMyAlign(a);
        }
    }

    @SqlCodeStyleConst.CommaMagicValues
    public static final int autodetectDelimiter(@NotNull SqlFormattingContext context, @NotNull Iterable<? extends SqlBlock> flow) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(flow, (String)"flow");
        int c1stCount = 0;
        int cLastCount = 0;
        boolean wasAtLeastOneDelimiter = false;
        TextRange lastElement = null;
        TextRange lastDelimiter = null;
        BlockRole lastRole = BlockRole.NOTHING;
        for (SqlBlock sqlBlock : flow) {
            switch (SqlCommonHandlersKt$WhenMappings.$EnumSwitchMapping$0[sqlBlock.getRole().ordinal()]) {
                case 1: {
                    if (lastRole == BlockRole.DELIMITER && lastDelimiter != null && context.textContains(lastDelimiter.getEndOffset(), sqlBlock.getRange().getStartOffset(), '\n')) {
                        ++cLastCount;
                    }
                    lastElement = sqlBlock.getRange();
                    lastRole = BlockRole.ELEMENT;
                    break;
                }
                case 2: {
                    if (lastRole == BlockRole.ELEMENT && lastElement != null && context.textContains(lastElement.getEndOffset(), sqlBlock.getRange().getStartOffset(), '\n')) {
                        ++c1stCount;
                    }
                    lastDelimiter = sqlBlock.getRange();
                    lastRole = BlockRole.DELIMITER;
                    wasAtLeastOneDelimiter = true;
                }
            }
        }
        return cLastCount > c1stCount ? 2 : (c1stCount > cLastCount ? 1 : (wasAtLeastOneDelimiter ? -1 : 0));
    }
}

