/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCallbackFunctionUtil {
    private static final Set<String> functionCallback = new THashSet();
    private static final Set<String> classCallback = new THashSet();
    private static final Set<String> existsClassCallbacks = new THashSet();
    private static final Set<String> existsCallbacks = new THashSet();
    private static final String VARIABLE_CALLBACK = "compact";
    private static final String METHOD_CALLBACK = "method_exists";
    private static final String FIELD_CALLBACK = "property_exists";
    private static final String FUNCTION_EXISTS = "function_exists";
    private static final String IS_CALLABLE = "is_callable";
    public static final String CLASS_ALIAS = "class_alias";
    public static final Condition<PsiElement> FUNCTION_ARGUMENT;
    public static final Condition<PsiElement> ARRAY_VALUE;

    public static boolean isExistsCallbackFunction(@NotNull String name) {
        if (name == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(0);
        }
        return existsCallbacks.contains(name) || existsClassCallbacks.contains(name);
    }

    public static boolean isClassCallbackFunction(@NotNull FunctionReference function, int selectedIndex) {
        String name;
        if (function == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(1);
        }
        return classCallback.contains(name = function.getName()) && (selectedIndex != 1 || !CLASS_ALIAS.equals(name)) || selectedIndex == 0 && (METHOD_CALLBACK.equals(name) || FIELD_CALLBACK.equals(name));
    }

    public static boolean isMethodCallbackFunction(@NotNull FunctionReference function, int selectedIndex) {
        if (function == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(2);
        }
        return METHOD_CALLBACK.equals(function.getName()) && selectedIndex == 1;
    }

    public static boolean isVariableCallbackFunction(@NotNull FunctionReference function) {
        if (function == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(3);
        }
        return VARIABLE_CALLBACK.equals(function.getName());
    }

    public static boolean isFieldCallbackFunction(@NotNull FunctionReference function, int selectedIndex) {
        if (function == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(4);
        }
        return FIELD_CALLBACK.equals(function.getName()) && selectedIndex == 1;
    }

    public static boolean isFunctionCallbackFunction(@NotNull FunctionReference function, int selectedIndex) {
        String name;
        if (function == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(5);
        }
        if (StringUtil.isNotEmpty((String)(name = function.getName())) && !PhpCallbackFunctionUtil.isStandardFunctionCallbackFunction(name)) {
            Parameter[] parameters;
            PsiElement element = function.resolve();
            if (selectedIndex != -1 && element instanceof Function && (parameters = ((Function)element).getParameters()).length > selectedIndex) {
                return PhpCallbackFunctionUtil.isCallable(parameters[selectedIndex].getType());
            }
            return false;
        }
        return true;
    }

    public static boolean isStandardFunctionCallbackFunction(@NotNull String name) {
        if (name == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(6);
        }
        return functionCallback.contains(name);
    }

    public static boolean isCallable(@NotNull PhpType phpType) {
        if (phpType == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(7);
        }
        Set types = phpType.getTypes();
        for (String type : types) {
            if (!PhpType.isCallableType((String)type)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PhpType getClassReferenceType(@Nullable PsiElement element) {
        CharSequence name;
        if (element instanceof ClassConstantReference && (PhpLangUtil.equalsConstantNames(name = ((ClassConstantReference)element).getNameCS(), "class") || StringUtil.isEmpty((CharSequence)name) && PhpPsiUtil.getChildOfType(element, PhpTokenTypes.kwCLASS) != null)) {
            element = ((ClassConstantReference)element).getClassReference();
        }
        return element instanceof PhpExpression ? ((PhpExpression)element).getType().globalLocationAware(element) : null;
    }

    @Nullable
    public static PsiElement getArrayValueContent(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        StringLiteralExpression innerStringElement = (StringLiteralExpression)PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF);
        return innerStringElement == null ? PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF) : innerStringElement;
    }

    @Nullable
    public static String getCallbackString(@NotNull PsiElement element) {
        String name;
        if (element == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(8);
        }
        return (name = PhpCodeInsightUtil.toString(element)) == null ? null : StringUtil.replace((String)name, (String)"\\\\", (String)"\\");
    }

    @Nullable
    public static PhpCallbackInfoHolder createCallback(@NotNull PsiElement callback) {
        if (callback == null) {
            PhpCallbackFunctionUtil.$$$reportNull$$$0(9);
        }
        if (callback instanceof ArrayCreationExpression) {
            PsiElement firstValue = PhpPsiUtil.getChildOfType(callback, PhpElementTypes.ARRAY_VALUE);
            PsiElement classElement = PhpCallbackFunctionUtil.getArrayValueContent(firstValue);
            if (classElement != null) {
                PsiElement secondValue = PhpPsiUtil.getChildOfType(callback, PhpElementTypes.ARRAY_VALUE, firstValue);
                PsiElement callbackElement = PhpCallbackFunctionUtil.getArrayValueContent(secondValue);
                return callbackElement == null ? null : new PhpMemberCallbackInfoHolder(classElement, callbackElement);
            }
        } else if (callback instanceof StringLiteralExpression) {
            return new PhpCallbackInfoHolder(callback);
        }
        return null;
    }

    static {
        functionCallback.add(FUNCTION_EXISTS);
        functionCallback.add("unregister_tick_function");
        existsClassCallbacks.add("class_exists");
        existsClassCallbacks.add("interface_exists");
        existsClassCallbacks.add("trait_exists");
        classCallback.add("__autoload");
        classCallback.add(CLASS_ALIAS);
        classCallback.add("get_class_methods");
        classCallback.add("get_class_vars");
        classCallback.add("get_parent_class");
        classCallback.add("is_a");
        classCallback.add("is_subclass_of");
        classCallback.addAll(existsClassCallbacks);
        existsCallbacks.add(METHOD_CALLBACK);
        existsCallbacks.add(FIELD_CALLBACK);
        existsCallbacks.add(FUNCTION_EXISTS);
        existsCallbacks.add(IS_CALLABLE);
        FUNCTION_ARGUMENT = use -> use.getParent() instanceof ParameterList;
        ARRAY_VALUE = use -> PhpPsiUtil.isOfType(use.getParent(), PhpElementTypes.ARRAY_VALUE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/PhpCallbackFunctionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isExistsCallbackFunction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassCallbackFunction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isMethodCallbackFunction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isVariableCallbackFunction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFieldCallbackFunction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionCallbackFunction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isStandardFunctionCallbackFunction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallbackString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createCallback";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpMemberCallbackInfoHolder
    extends PhpCallbackInfoHolder {
        private final PsiElement myClassElement;

        public PhpMemberCallbackInfoHolder(@NotNull PsiElement clazzElement, @NotNull PsiElement callback) {
            if (clazzElement == null) {
                PhpMemberCallbackInfoHolder.$$$reportNull$$$0(0);
            }
            if (callback == null) {
                PhpMemberCallbackInfoHolder.$$$reportNull$$$0(1);
            }
            super(callback);
            this.myClassElement = clazzElement;
        }

        public PsiElement getClassElement() {
            return this.myClassElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "clazzElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callback";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/PhpCallbackFunctionUtil$PhpMemberCallbackInfoHolder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpCallbackInfoHolder {
        private final PsiElement myCallbackElement;

        public PhpCallbackInfoHolder(@NotNull PsiElement element) {
            if (element == null) {
                PhpCallbackInfoHolder.$$$reportNull$$$0(0);
            }
            this.myCallbackElement = element;
        }

        public PsiElement getCallbackElement() {
            return this.myCallbackElement;
        }

        @NotNull
        public String getCallbackText() {
            String string = StringUtil.notNullize((String)PhpCallbackFunctionUtil.getCallbackString(this.myCallbackElement));
            if (string == null) {
                PhpCallbackInfoHolder.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpCallbackFunctionUtil$PhpCallbackInfoHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpCallbackFunctionUtil$PhpCallbackInfoHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallbackText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

