/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.lexer.managers;

import com.jetbrains.php.lang.lexer._PhpLexer;
import gnu.trove.TIntStack;

public class StatesManager {
    private final TIntStack statesStack;
    private final _PhpLexer lexer;

    public StatesManager(_PhpLexer lexer) {
        this.lexer = lexer;
        this.statesStack = new TIntStack();
    }

    public void reset() {
        this.statesStack.reset();
    }

    public void toPreviousState() {
        assert (this.statesStack.size() >= 2) : this.statesStack.peek() + ":" + this.lexer.getBuffer();
        this.statesStack.pop();
        this.lexer.yybegin(this.statesStack.peek());
    }

    public void toState(int state) {
        if (state % 2 == 1) {
            --state;
        }
        this.statesStack.push(state);
        this.lexer.yybegin(state);
    }

    public int getStackSize() {
        return this.statesStack.size();
    }
}

