/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.webpack;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfig;
import com.intellij.lang.javascript.buildTools.webpack.WebPackConfiguration;
import com.intellij.lang.javascript.buildTools.webpack.WebPackExecutor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.Alarm;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.KotlinUtils;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WebPackConfiguration")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001f\u001a\u00020\u000fH\u0002J\u0006\u0010\n\u001a\u00020\fJ\b\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020\u000fJ\b\u0010#\u001a\u00020\u0002H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0002H\u0016J\u0018\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002J\u000e\u0010+\u001a\u00020!2\u0006\u0010\n\u001a\u00020\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/lang/javascript/buildTools/webpack/WebPackConfigManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/lang/javascript/buildTools/webpack/WebPackConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/FileDocumentManager;)V", "alarm", "Lcom/intellij/util/Alarm;", "config", "Lcom/intellij/util/CachedValueImpl;", "Lcom/intellij/lang/javascript/buildTools/webpack/WebPackConfig;", "configuration", "defaultPath", "", "getDefaultPath", "()Ljava/lang/String;", "defaultPath$delegate", "Lkotlin/Lazy;", "executor", "Lcom/intellij/lang/javascript/buildTools/webpack/WebPackExecutor;", "getFileDocumentManager", "()Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "forceConfig", "getProject", "()Lcom/intellij/openapi/project/Project;", "tracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "webpackNames", "", "calcDefaultPath", "configChanged", "", "getConfigPathOrDefault", "getState", "loadState", "state", "saveAndUpdate", "document", "Lcom/intellij/openapi/editor/Document;", "timeout", "", "setConfig", "Companion", "intellij.javascript.impl"})
public final class WebPackConfigManager
implements PersistentStateComponent<WebPackConfiguration> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final WebPackExecutor executor;
    private final WebPackConfiguration configuration;
    private final List<String> webpackNames;
    private volatile WebPackConfig forceConfig;
    private final Lazy defaultPath$delegate;
    private final CachedValueImpl<WebPackConfig> config;
    private final SimpleModificationTracker tracker;
    private final Alarm alarm;
    @NotNull
    private final Project project;
    @NotNull
    private final FileDocumentManager fileDocumentManager;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(WebPackConfigManager.class), "defaultPath", "getDefaultPath()Ljava/lang/String;"))};
        Companion = new Companion(null);
    }

    private final String getDefaultPath() {
        Lazy lazy = this.defaultPath$delegate;
        WebPackConfigManager webPackConfigManager = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    @NotNull
    public final WebPackConfig config() {
        if (this.forceConfig != null) {
            WebPackConfig webPackConfig = this.forceConfig;
            if (webPackConfig == null) {
                Intrinsics.throwNpe();
            }
            return webPackConfig;
        }
        Object object = this.config.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"config.value");
        return (WebPackConfig)object;
    }

    public final void setConfig(@NotNull WebPackConfig config2) {
        Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
        this.forceConfig = config2;
    }

    @NotNull
    public final String getConfigPathOrDefault() {
        String string = this.configuration.getPath();
        if (string == null) {
            string = this.getDefaultPath();
        }
        return string;
    }

    private final String calcDefaultPath() {
        Iterable $receiver$iv = this.webpackNames;
        for (Object element$iv : $receiver$iv) {
            String name = (String)element$iv;
            if (LocalFileSystem.getInstance().findFileByPath(this.project.getBasePath() + "/" + name) == null) continue;
            return this.project.getBasePath() + "/" + name;
        }
        return "";
    }

    @NotNull
    public WebPackConfiguration getState() {
        return this.configuration;
    }

    public void loadState(@NotNull WebPackConfiguration state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        String path = state.getPath();
        String newPath = path != null ? FileUtil.toSystemIndependentName((String)path) : null;
        this.configuration.setPath(Intrinsics.areEqual((Object)newPath, (Object)this.getDefaultPath()) ? null : newPath);
        this.configChanged();
    }

    private final void saveAndUpdate(Document document, int timeout) {
        this.alarm.cancelAllRequests();
        this.alarm.addRequest(new Runnable(this, document){
            final /* synthetic */ WebPackConfigManager this$0;
            final /* synthetic */ Document $document;

            public final void run() {
                PsiDocumentManager.getInstance((Project)this.this$0.getProject()).commitDocument(this.$document);
                this.this$0.getFileDocumentManager().saveDocument(this.$document);
                WebPackConfigManager.access$configChanged(this.this$0);
            }
            {
                this.this$0 = webPackConfigManager;
                this.$document = document;
            }
        }, timeout);
    }

    private final void configChanged() {
        this.tracker.incModificationCount();
        DaemonCodeAnalyzer.getInstance((Project)this.project).restart();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final FileDocumentManager getFileDocumentManager() {
        return this.fileDocumentManager;
    }

    public WebPackConfigManager(@NotNull Project project, @NotNull FileDocumentManager fileDocumentManager) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)fileDocumentManager, (String)"fileDocumentManager");
        this.project = project;
        this.fileDocumentManager = fileDocumentManager;
        this.executor = new WebPackExecutor();
        this.configuration = new WebPackConfiguration(null);
        this.webpackNames = CollectionsKt.listOf((Object[])new String[]{"webpack.config.js", "webpack.config.ts", "webpack.base.conf.js", "webpack.dev.conf.js", "webpack.prod.conf.js", "webpack.babel.js"});
        this.defaultPath$delegate = KotlinUtils.lazyPub((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ WebPackConfigManager this$0;

            @NotNull
            public final String invoke() {
                return WebPackConfigManager.access$calcDefaultPath(this.this$0);
            }
            {
                this.this$0 = webPackConfigManager;
                super(0);
            }
        }));
        this.config = new CachedValueImpl(new CachedValueProvider<T>(this){
            final /* synthetic */ WebPackConfigManager this$0;

            @Nullable
            public final CachedValueProvider.Result<WebPackConfig> compute() {
                CachedValueProvider.Result result2;
                VirtualFile file2;
                String path = this.this$0.getConfigPathOrDefault();
                CharSequence charSequence = path;
                VirtualFile virtualFile = file2 = !(charSequence.length() == 0) ? VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)path)) : null;
                if (file2 != null) {
                    long start = System.currentTimeMillis();
                    WebPackConfig conf = WebPackConfigManager.access$getExecutor$p(this.this$0).loadConfig(this.this$0.getProject(), path);
                    Logger.getInstance(WebPackConfigManager.class).info("webpack config evaluation took " + (System.currentTimeMillis() - start) + " ms");
                    result2 = new CachedValueProvider.Result((Object)conf, new Object[]{file2, WebPackConfigManager.access$getTracker$p(this.this$0)});
                } else {
                    result2 = new CachedValueProvider.Result((Object)new WebPackConfig(null, null, 3, null), new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, WebPackConfigManager.access$getTracker$p(this.this$0)});
                }
                return result2;
            }
            {
                this.this$0 = webPackConfigManager;
            }
        });
        this.tracker = new SimpleModificationTracker();
        this.alarm = new Alarm((Disposable)this.project);
        if (!this.project.isDefault()) {
            EditorFactory editorFactory = EditorFactory.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
            editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    VirtualFile virtualFile = this.getFileDocumentManager().getFile(event.getDocument());
                    if (Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getPath() : null), (Object)this.getConfigPathOrDefault())) {
                        Document document = event.getDocument();
                        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"event.document");
                        this.saveAndUpdate(document, 5000);
                    }
                }
            }, (Disposable)this.project);
            this.project.getMessageBus().connect((Disposable)this.project).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                public void after(@NotNull List<? extends VFileEvent> events) {
                    Intrinsics.checkParameterIsNotNull(events, (String)"events");
                    for (VFileEvent vFileEvent : events) {
                        Document document;
                        VirtualFile virtualFile = vFileEvent.getFile();
                        if (!Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getPath() : null), (Object)this.getConfigPathOrDefault())) continue;
                        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                        VirtualFile virtualFile2 = vFileEvent.getFile();
                        if (virtualFile2 == null) {
                            Intrinsics.throwNpe();
                        }
                        if ((document = fileDocumentManager.getDocument(virtualFile2)) == null) continue;
                        this.saveAndUpdate(document, 300);
                        return;
                    }
                }
            });
        }
    }

    public static final /* synthetic */ void access$configChanged(WebPackConfigManager $this) {
        $this.configChanged();
    }

    @NotNull
    public static final /* synthetic */ String access$calcDefaultPath(WebPackConfigManager $this) {
        return $this.calcDefaultPath();
    }

    @NotNull
    public static final /* synthetic */ WebPackExecutor access$getExecutor$p(WebPackConfigManager $this) {
        return $this.executor;
    }

    @NotNull
    public static final /* synthetic */ SimpleModificationTracker access$getTracker$p(WebPackConfigManager $this) {
        return $this.tracker;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/javascript/buildTools/webpack/WebPackConfigManager$Companion;", "", "()V", "instance", "Lcom/intellij/lang/javascript/buildTools/webpack/WebPackConfigManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.impl"})
    public static final class Companion {
        @NotNull
        public final WebPackConfigManager instance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, WebPackConfigManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026onfigManager::class.java)");
            return (WebPackConfigManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

