/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.parser;

import com.intellij.indentation.AbstractIndentParser;
import com.intellij.indentation.OperationParserHelper;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.coffeescript.lang.parser.CoffeeScriptElementTypes;
import org.coffeescript.lang.parser.CoffeeScriptPsiBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCoffeeScriptParser
extends AbstractIndentParser
implements OperationParserHelper.BinaryOperationParser,
OperationParserHelper.CustomBinaryOperationParser,
PsiParser {
    private static final IElementType[] BINARY_OPERATIONS_ELEMENT = new IElementType[]{CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.BINARY_EXPRESSION, CoffeeScriptElementTypes.ASSIGN_EXPRESSION};
    private final TokenSet ARRAY_PREFIX = TokenSet.andNot((TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{CoffeeScriptTokenTypes.BRACKET_START, CoffeeScriptTokenTypes.BRACE_START, CoffeeScriptTokenTypes.PARENTHESIS_START, CoffeeScriptTokenTypes.EQ, CoffeeScriptTokenTypes.COLON, CoffeeScriptTokenTypes.WHITE_SPACE, CoffeeScriptTokenTypes.COMMA, CoffeeScriptTokenTypes.INTERPOLATION_START, CoffeeScriptTokenTypes.EXIST_EQ}), CoffeeScriptTokenTypes.OPERATION_SIGNS, CoffeeScriptTokenTypes.EQUALITY_OPERATIONS}), (TokenSet)TokenSet.create((IElementType[])new IElementType[]{CoffeeScriptTokenTypes.EXIST}));
    protected CoffeeScriptPsiBuilder myCoffeeScriptPsiBuilder;

    protected IElementType getIndentElementType() {
        return null;
    }

    protected IElementType getEolElementType() {
        return null;
    }

    protected void startScope() {
        this.myCoffeeScriptPsiBuilder.startScope();
    }

    protected void endScope() {
        this.myCoffeeScriptPsiBuilder.endScope();
    }

    protected void addVariableInCurrentScope(@NotNull String variableName) {
        if (variableName == null) {
            BaseCoffeeScriptParser.$$$reportNull$$$0(0);
        }
        this.myCoffeeScriptPsiBuilder.addVariableInCurrentScope(variableName);
    }

    protected boolean isInScope(String name) {
        return this.myCoffeeScriptPsiBuilder.isInScope(name);
    }

    public void advance() {
        this.myBuilder.advanceLexer();
    }

    protected boolean nextTokenOnNewLine() {
        PsiBuilder.Marker marker = this.mark(true);
        this.advance();
        boolean result = this.isNewLine();
        marker.rollbackTo();
        return result;
    }

    @NotNull
    protected String getTokenText(int stepAhead) {
        PsiBuilder.Marker marker = this.mark(true);
        for (int i = 0; i < stepAhead; ++i) {
            this.myBuilder.advanceLexer();
        }
        String result = this.getTokenText();
        marker.rollbackTo();
        String string = result;
        if (string == null) {
            BaseCoffeeScriptParser.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected int getCurrentOffset() {
        return this.myBuilder.getCurrentOffset();
    }

    protected char charAt(int offset) {
        return this.myBuilder.getOriginalText().charAt(offset);
    }

    protected void skipCommaAndTerminator() {
        while (!this.eof() && (this.isComma() || this.isExpressionTerminator())) {
            this.advance();
        }
    }

    protected boolean isExpressionTerminator() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.SEMICOLON);
    }

    protected static boolean isTokenIn(IElementType tokenType, IElementType ... types) {
        if (types != null) {
            for (IElementType type : types) {
                if (tokenType != type) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isCurrentTokenIn(IElementType ... types) {
        IElementType token = this.myBuilder.getTokenType();
        if (token != null) {
            return BaseCoffeeScriptParser.isTokenIn(token, types);
        }
        return false;
    }

    protected boolean isPostfixOperator() {
        return CoffeeScriptTokenTypes.POSTFIX_OPERATORS.contains(this.getTokenType());
    }

    protected boolean isOperationSymbol() {
        return CoffeeScriptTokenTypes.ARITHMETIC_MUL_OPERATORS.contains(this.getTokenType()) || CoffeeScriptTokenTypes.ARITHMETIC_SUM_OPERATORS.contains(this.getTokenType()) && (this.rawLookup(-1) != CoffeeScriptTokenTypes.WHITE_SPACE || this.rawLookup(1) == CoffeeScriptTokenTypes.WHITE_SPACE) || CoffeeScriptTokenTypes.ARITHMETIC_BIT_OPERATORS.contains(this.getTokenType()) || CoffeeScriptTokenTypes.RELATIONAL_OPERATIONS.contains(this.getTokenType()) || CoffeeScriptTokenTypes.EQUALITY_OPERATIONS.contains(this.getTokenType()) || CoffeeScriptTokenTypes.ASSIGNMENT_OPERATIONS.contains(this.getTokenType()) || CoffeeScriptTokenTypes.BIT_AND.contains(this.getTokenType()) || CoffeeScriptTokenTypes.BIT_OR.contains(this.getTokenType()) || CoffeeScriptTokenTypes.BIT_XOR.contains(this.getTokenType()) || CoffeeScriptTokenTypes.LOGIC_AND.contains(this.getTokenType()) || CoffeeScriptTokenTypes.LOGIC_OR.contains(this.getTokenType());
    }

    protected boolean isIf() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.IF, CoffeeScriptTokenTypes.UNLESS);
    }

    protected boolean isPrototype() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.PROTOTYPE);
    }

    protected boolean isIdentifier() {
        return BaseCoffeeScriptParser.isIdentifier(this.getTokenType());
    }

    protected static boolean isIdentifier(@Nullable IElementType tokenType) {
        return BaseCoffeeScriptParser.isTokenIn(tokenType, CoffeeScriptTokenTypes.IDENTIFIER);
    }

    protected boolean isSuper() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.SUPER);
    }

    protected boolean isComma() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.COMMA);
    }

    protected boolean isParenthetical() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_START);
    }

    protected boolean isThis() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.THIS);
    }

    protected boolean isShortThis() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.THIS) && this.getTokenText().equals("@");
    }

    protected boolean isSplatSymbol() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.SPLAT);
    }

    protected boolean isSplatOrRange() {
        return this.isSplatSymbol() || this.isCurrentTokenIn(CoffeeScriptTokenTypes.RANGE);
    }

    protected boolean isRangeSymbol() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.RANGE) || this.isSplatSymbol();
    }

    protected boolean isArray() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACKET_START)) {
            IElementType previousElement = this.rawLookup(-1);
            return this.getCurrentOffset() == 0 || CoffeeScriptTokenTypes.OPERATION_SIGNS.contains(previousElement) && !CoffeeScriptTokenTypes.EXIST_OPERATORS.contains(previousElement) || this.ARRAY_PREFIX.contains(previousElement);
        }
        return false;
    }

    protected boolean isIndex() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.BRACKET_START)) {
            return !this.isArray();
        }
        return false;
    }

    protected boolean isAccessor(int indent) {
        if (this.isExist()) {
            return true;
        }
        if (indent > this.getCurrentIndent()) {
            return false;
        }
        IElementType tokenType = this.getTokenType();
        if (tokenType == CoffeeScriptTokenTypes.DOT) {
            tokenType = this.lookAhead(1);
            String tokenText = this.getTokenText(1);
            if (BaseCoffeeScriptParser.isIdentifier(tokenType) || tokenText.equals("is") || BaseCoffeeScriptParser.isTokenIn(tokenType, CoffeeScriptTokenTypes.BOOL)) {
                return true;
            }
        } else {
            if (this.isPrototype() || this.isIndex()) {
                return true;
            }
            if (this.isExist()) {
                return true;
            }
        }
        return false;
    }

    protected boolean isExist() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXIST) && (!this.hasSpaceBefore() || this.isNewLine());
    }

    protected boolean hasSpaceBefore() {
        return this.rawLookup(-1) == CoffeeScriptTokenTypes.WHITE_SPACE;
    }

    protected boolean isSimpleAssignable() {
        return this.isIdentifier() || this.isThis();
    }

    protected boolean isThisProperty() {
        return this.isThis() && BaseCoffeeScriptParser.isIdentifier(this.rawLookup(1));
    }

    protected boolean isSwitchEnd() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.CATCH, CoffeeScriptTokenTypes.FINALLY);
    }

    protected boolean isInvocationWithBraces() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.PARENTHESIS_START) && !this.isNewLine() && this.charAt(this.getCurrentOffset() - 1) != ' ';
    }

    protected boolean isString() {
        return this.isString(this.getTokenType());
    }

    protected boolean isString(IElementType tokenType) {
        return BaseCoffeeScriptParser.isTokenIn(tokenType, CoffeeScriptTokenTypes.HEREDOC_START, CoffeeScriptTokenTypes.STRING_LITERAL);
    }

    protected boolean isRegexp() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.HEREGEX_START, CoffeeScriptTokenTypes.HEREGEX_START, CoffeeScriptTokenTypes.REGEX_START);
    }

    protected boolean isWhile() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.WHILE, CoffeeScriptTokenTypes.UNTIL);
    }

    protected boolean isThrow() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.THROW);
    }

    protected boolean isCode() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.FUNCTION, CoffeeScriptTokenTypes.FUNCTION_BIND) || this.isParenthetical();
    }

    protected boolean isReturn() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.RETURN);
    }

    protected boolean isSwitch() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.SWITCH);
    }

    protected boolean isAlphaNumeric() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.NUMBER, CoffeeScriptTokenTypes.STRING_LITERAL) || this.isString();
    }

    protected boolean isLiteral() {
        return this.isAlphaNumeric() || this.isRegexp() || this.isCurrentTokenIn(CoffeeScriptTokenTypes.JAVASCRIPT_LITERAL, CoffeeScriptTokenTypes.BOOL);
    }

    protected boolean isObjAssignable() {
        return this.isIdentifier() || this.isAlphaNumeric() || this.isThisProperty();
    }

    protected boolean isStatement() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.BREAK, CoffeeScriptTokenTypes.DEBUGGER, CoffeeScriptTokenTypes.CONTINUE) || this.isReturn();
    }

    protected boolean isVariable() {
        return this.isIdentifier() && BaseCoffeeScriptParser.isTokenIn(this.lookAhead(1), CoffeeScriptTokenTypes.EQ) && !this.isInScope(this.getTokenText());
    }

    protected boolean isForBody() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.FOR);
    }

    protected boolean isLoop() {
        return this.isCurrentTokenIn(CoffeeScriptTokenTypes.LOOP);
    }

    protected abstract boolean parseExpression();

    protected boolean isRelationSymbol() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXCL)) {
            return CoffeeScriptTokenTypes.RELATIONAL_OPERATIONS.contains(this.lookAhead(1));
        }
        return CoffeeScriptTokenTypes.RELATIONAL_OPERATIONS.contains(this.getTokenType());
    }

    public boolean parseSimpleExpression() {
        return this.parseExpression();
    }

    public TokenSet getWhitespaceTokenSet() {
        return CoffeeScriptTokenTypes.WHITESPACES;
    }

    public TokenSet getPrefixOperators() {
        return CoffeeScriptTokenTypes.PREFIX_OPERATORS;
    }

    public TokenSet getPostfixOperators() {
        return CoffeeScriptTokenTypes.POSTFIX_OPERATORS;
    }

    @NotNull
    public TokenSet[] getOperatorsByPriority() {
        if (CoffeeScriptTokenTypes.BINARY_OPERATION_PRIORITY == null) {
            BaseCoffeeScriptParser.$$$reportNull$$$0(2);
        }
        return CoffeeScriptTokenTypes.BINARY_OPERATION_PRIORITY;
    }

    @Nullable
    public IElementType getPostfixExpressionElementType() {
        return CoffeeScriptElementTypes.POSTFIX_EXPRESSION;
    }

    @Nullable
    public IElementType getPrefixExpressionElementType() {
        return CoffeeScriptElementTypes.PREFIX_EXPRESSION;
    }

    @NotNull
    public IElementType[] getOperationElementTypes() {
        if (BINARY_OPERATIONS_ELEMENT == null) {
            BaseCoffeeScriptParser.$$$reportNull$$$0(3);
        }
        return BINARY_OPERATIONS_ELEMENT;
    }

    public boolean isBinaryOperator(int level) {
        IElementType tokenType = this.getTokenType();
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXCL) && CoffeeScriptTokenTypes.BINARY_OPERATION_PRIORITY[level] == CoffeeScriptTokenTypes.RELATIONAL_OPERATIONS) {
            tokenType = this.lookAhead(1);
        }
        return CoffeeScriptTokenTypes.BINARY_OPERATION_PRIORITY[level].contains(tokenType);
    }

    public void parseBinaryOperator() {
        if (this.isCurrentTokenIn(CoffeeScriptTokenTypes.EXCL)) {
            this.advance();
        }
        this.advance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/lang/parser/BaseCoffeeScriptParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/lang/parser/BaseCoffeeScriptParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperatorsByPriority";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationElementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addVariableInCurrentScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

