<?php

error_reporting(0);

function createErrorMessage($message) {
    return "#[error]:$message";
}

function find_autoload($behat_dir, $autoload_files)
{
    foreach ($autoload_files as $file) {
        if (file_exists($behat_dir . $file)) {
            return $behat_dir . $file;
        }
    }
    return null;
}

function init($autoload_files)
{
    if (isset($_SERVER['IDE_BEHAT_DIR'])) {
        $behat_dir = $_SERVER['IDE_BEHAT_DIR'];
        if (!file_exists($behat_dir)) {
            echo "The value \$_SERVER['IDE_BEHAT_DIR'] is specified, but file doesn't exist '$behat_dir'\n";
            exit(FAILURE_EXIT);
        }

        if (file_exists($behat_dir . "/bin/behat")) {
            define('BEHAT_BIN_PATH', $behat_dir . "/bin/behat");
        }

        $autoload = find_autoload($behat_dir, $autoload_files);
        if (is_null($autoload)) {
            echo "Can not find behat autoloader file by directory: '$behat_dir'\n";
            exit(FAILURE_EXIT);
        }

        require_once $autoload;
    } else if (isset($_SERVER['IDE_BEHAT_PHAR'])) {
        $behat_phar = $_SERVER['IDE_BEHAT_PHAR'];
        if (!file_exists($behat_phar)) {
            echo "The value \$_SERVER['IDE_BEHAT_PHAR'] is specified, but file doesn't exist '$behat_phar'\n";
            exit(FAILURE_EXIT);
        }

        define('BEHAT_BIN_PATH', 'phar://' . $behat_phar . '/phar/stub.php');
        require_once 'phar://' . $behat_phar . '/vendor/autoload.php';
    }
}

init(array("/vendor/autoload.php", "/../../autoload.php"));

$version = isset($_SERVER['IDE_BEHAT_VERSION']) ? $_SERVER['IDE_BEHAT_VERSION'] : "UNKNOWN";

if (version_compare($version, "3.0") >= 0) {
    echo createErrorMessage("Snippet generation is not supported for Behat3 yet.");
} else {
    class PhpStormBehatFormatter extends \Behat\Behat\Formatter\ConsoleFormatter
    {
        private $content = '';

        protected function getDefaultParameters()
        {
            return array();
        }

        public static function getSubscribedEvents()
        {
            $events = array(
                'afterSuite', 'afterStep'
            );
            return array_combine($events, $events);
        }

        public function afterSuite(Behat\Behat\Event\SuiteEvent $event)
        {
            if (empty($this->content)) {
                $this->write(createErrorMessage("Can not generate snippet for the selected step."));
            } else {
                $this->write($this->content);
            }
        }

        public function afterStep(Behat\Behat\Event\StepEvent $event)
        {
            $step = $event->getStep();
            $testName = $step->getText();
            if (!empty($this->content) || !isset($_SERVER['IDE_BEHAT_STEP_NAME']) || strcmp($_SERVER['IDE_BEHAT_STEP_NAME'], $testName) != null) {
                return;
            }

            $result = $event->getResult();
            if ($result == Behat\Behat\Event\StepEvent::UNDEFINED || $result == Behat\Behat\Event\StepEvent::FAILED) {
                $snippet = $event->getSnippet();
                if (!is_null($snippet)) {
                    $this->content = $snippet->getSnippet();
                }
            }
        }
    }

    $app = new Behat\Behat\Console\BehatApplication($version);
    $app->run();
}
