/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.resolve.CssCustomPropertyReference;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CssUnresolvedCustomPropertyInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssUnresolvedCustomPropertyInspection.$$$reportNull$$$0(0);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitCssFunction(CssFunction function) {
                super.visitCssFunction(function);
                String name = function.getName();
                if ("var".equals(name)) {
                    CssTermList value = function.getValue();
                    if (value == null) {
                        return;
                    }
                    Object[] terms = value.getTerms();
                    CssTerm term = (CssTerm)ArrayUtil.getFirstElement((Object[])terms);
                    if (term == null) {
                        return;
                    }
                    PsiElement child = term.getFirstChild();
                    if (child == null) {
                        return;
                    }
                    for (PsiReference reference : child.getReferences()) {
                        ResolveResult[] results;
                        if (!(reference instanceof CssCustomPropertyReference) || (results = ((CssCustomPropertyReference)reference).multiResolve(false)).length != 0) continue;
                        String elementName = reference.getCanonicalText();
                        holder.registerProblem(child, CssBundle.message((String)"css.inspections.unresolved.custom.property.message", (Object[])new Object[]{elementName}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (cssElementVisitor == null) {
            CssUnresolvedCustomPropertyInspection.$$$reportNull$$$0(1);
        }
        return cssElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssUnresolvedCustomPropertyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssUnresolvedCustomPropertyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

