/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.execution;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.linter.tslint.TslintUtil;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.linter.tslint.highlight.TsLintFixInfo;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintOutputJsonParser {
    private static final Logger LOG = TslintUtil.LOG;
    public static final String FIX_PROPERTY = "fix";
    @Nullable
    private final String myPath;
    private final boolean myMyZeroBasedRowCol;
    @NotNull
    private final List<TsLinterError> myErrors;
    @NotNull
    private final Gson myGson;

    public TsLintOutputJsonParser(@Nullable String path, JsonElement root, boolean zeroBasedRowCol, @NotNull Gson gson) {
        if (gson == null) {
            TsLintOutputJsonParser.$$$reportNull$$$0(0);
        }
        this.myPath = path;
        this.myMyZeroBasedRowCol = zeroBasedRowCol;
        this.myGson = gson;
        if (root instanceof JsonNull || !root.isJsonArray()) {
            TsLintOutputJsonParser.logError("root element is not array");
            this.myErrors = ContainerUtil.emptyList();
        } else {
            JsonArray array = root.getAsJsonArray();
            int size = array.size();
            ArrayList errors = ContainerUtil.newArrayList();
            for (int i = 0; i < size; ++i) {
                JsonElement element = array.get(i);
                if (!element.isJsonObject()) {
                    TsLintOutputJsonParser.logError("element under root is not object");
                    continue;
                }
                JsonObject object = element.getAsJsonObject();
                errors.addAll(this.processError(object));
            }
            this.myErrors = errors;
        }
    }

    private List<TsLinterError> processError(JsonObject object) {
        ArrayList result = ContainerUtil.newArrayList();
        JsonElement name = object.get("name");
        if (name == null) {
            TsLintOutputJsonParser.logError("no name for error object");
            return result;
        }
        JsonElement failure = object.get("failure");
        if (failure == null || !failure.isJsonPrimitive() || !failure.getAsJsonPrimitive().isString()) {
            TsLintOutputJsonParser.logError("no failure for error object");
            return result;
        }
        JsonElement startPosition = object.get("startPosition");
        if (startPosition == null || !startPosition.isJsonObject()) {
            TsLintOutputJsonParser.logError("no startPosition for error object");
            return result;
        }
        JsonElement endPosition = object.get("endPosition");
        if (endPosition == null || !endPosition.isJsonObject()) {
            TsLintOutputJsonParser.logError("no endPosition for error object");
            return result;
        }
        JsonElement ruleName = object.get("ruleName");
        if (ruleName == null || !ruleName.isJsonPrimitive() || !ruleName.getAsJsonPrimitive().isString()) {
            TsLintOutputJsonParser.logError("no rule name for error object");
            return result;
        }
        String severityStr = JsonUtil.getChildAsString((JsonObject)object, (String)"ruleSeverity");
        Pair<Integer, Integer> start = this.parseLineColumn(startPosition.getAsJsonObject());
        Pair<Integer, Integer> end = this.parseLineColumn(endPosition.getAsJsonObject());
        if (start == null || end == null) {
            return result;
        }
        JsonElement element = object.get(FIX_PROPERTY);
        LocalFilePath localfilePath = (LocalFilePath)this.myGson.getAdapter(LocalFilePath.class).fromJsonTree(name);
        String filePath = LocalFilePath.getPath((LocalFilePath)localfilePath);
        result.add(new TsLinterError(StringUtil.isEmpty((String)filePath) ? this.myPath : filePath, (Integer)start.getFirst(), (Integer)start.getSecond(), (Integer)end.getFirst(), (Integer)end.getSecond(), failure.getAsString(), ruleName.getAsString(), StringUtil.equalsIgnoreCase((CharSequence)severityStr, (CharSequence)"warning"), TsLintFixInfo.createTsLintFixInfo(element)));
        return result;
    }

    private Pair<Integer, Integer> parseLineColumn(JsonObject position) {
        JsonElement line = position.get("line");
        if (line == null || !line.isJsonPrimitive() || !line.getAsJsonPrimitive().isNumber()) {
            TsLintOutputJsonParser.logError("no line for position");
            return null;
        }
        JsonElement character = position.get("character");
        if (character == null || !character.isJsonPrimitive() || !character.getAsJsonPrimitive().isNumber()) {
            TsLintOutputJsonParser.logError("no character for position");
            return null;
        }
        if (this.myMyZeroBasedRowCol) {
            return Pair.create((Object)line.getAsJsonPrimitive().getAsInt(), (Object)character.getAsJsonPrimitive().getAsInt());
        }
        return Pair.create((Object)(line.getAsJsonPrimitive().getAsInt() + 1), (Object)(character.getAsJsonPrimitive().getAsInt() + 1));
    }

    @NotNull
    public List<TsLinterError> getErrors() {
        List<TsLinterError> list = this.myErrors;
        if (list == null) {
            TsLintOutputJsonParser.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static void logError(String s) {
        LOG.info("TSLint result parsing: " + s);
    }

    public static boolean isVersionZeroBased(SemVer tsLintVersion) {
        return tsLintVersion != null && (tsLintVersion.getMajor() < 2 || tsLintVersion.getMajor() == 2 && tsLintVersion.getMinor() <= 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gson";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/execution/TsLintOutputJsonParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/execution/TsLintOutputJsonParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

