/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterGuesser
implements DirectoryProjectConfigurator {
    public static final Logger LOG = Logger.getInstance(JSLinterGuesser.class);
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Linters");

    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        if (baseDir == null) {
            JSLinterGuesser.$$$reportNull$$$0(0);
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> JSLinterGuesser.guessLinters(project));
    }

    public static void guessLinters(@NotNull Project project) {
        if (project == null) {
            JSLinterGuesser.$$$reportNull$$$0(1);
        }
        if (project.isDefault()) {
            return;
        }
        if (Registry.is((String)"javascript.linters.prevent.detection")) {
            LOG.info("Linters detection disabled");
            return;
        }
        PackageJsonData packageJson = PackageJsonUtil.getTopLevelPackageJsonData(project);
        for (JSLinterDescriptor descriptor2 : JSLinterDescriptor.EP_NAME.getExtensionList()) {
            HashSet enableCases = ContainerUtil.newHashSet((int)3);
            String packageName = descriptor2.packageName();
            if (packageJson != null) {
                if (packageJson.getTopLevelProperties().contains(descriptor2.packageJsonSectionName())) {
                    enableCases.add(EnableCase.configSection);
                }
                if (packageJson.getAllDependencies().contains(packageName)) {
                    enableCases.add(EnableCase.dependency);
                }
            }
            if (enableCases.isEmpty() && descriptor2.hasConfigFiles(project)) {
                enableCases.add(EnableCase.configFile);
            }
            if (enableCases.isEmpty() || !JSLinterGuesser.checkInstalled(project, enableCases, descriptor2) || !descriptor2.enable(project)) continue;
            EnableCase selectedCase = EnableCase.select(enableCases);
            JSLinterGuesser.doLog(project, selectedCase, descriptor2);
            descriptor2.postEnable(project, selectedCase);
        }
    }

    private static boolean checkInstalled(@NotNull Project project, @NotNull Set<EnableCase> enableCases, @NotNull JSLinterDescriptor descriptor2) {
        String packageName;
        if (project == null) {
            JSLinterGuesser.$$$reportNull$$$0(2);
        }
        if (enableCases == null) {
            JSLinterGuesser.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            JSLinterGuesser.$$$reportNull$$$0(4);
        }
        if ((packageName = descriptor2.packageName()) == null) {
            return true;
        }
        if (enableCases.contains((Object)EnableCase.dependency)) {
            return true;
        }
        NodeJsInterpreter interpreter = ApplicationManager.getApplication().isUnitTestMode() ? NodeJsInterpreterManager.getInstance(project).getInterpreter() : NodeJsLocalInterpreterManager.getInstance().detectMostRelevant();
        List<NodePackage> available = new NodePackageDescriptor(packageName).listAvailable(project, interpreter, project.getBaseDir());
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        Iterator<NodePackage> iterator = available.iterator();
        while (iterator.hasNext()) {
            NodePackage nodePackage = iterator.next();
            if (lfs.refreshAndFindFileByPath(nodePackage.getSystemIndependentPath()) != null) continue;
            iterator.remove();
        }
        if (!available.isEmpty()) {
            LOG.info(String.format("For %s %s found, and linter in %s.", descriptor2.getDisplayName(), enableCases.stream().map(Enum::name).collect(Collectors.joining(",\n")), available.get(0).getSystemDependentPath()));
        }
        return !available.isEmpty();
    }

    private static void doLog(final @NotNull Project project, @NotNull EnableCase enableCase, final @NotNull JSLinterDescriptor descriptor2) {
        if (project == null) {
            JSLinterGuesser.$$$reportNull$$$0(5);
        }
        if (enableCase == null) {
            JSLinterGuesser.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            JSLinterGuesser.$$$reportNull$$$0(7);
        }
        String message = enableCase.getMessage(descriptor2);
        NOTIFICATION_GROUP.createNotification(message, MessageType.INFO).addAction((AnAction)new NotificationAction("Disable " + descriptor2.getDisplayName()){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                LOG.info(descriptor2.getDisplayName() + " disabled by user");
                descriptor2.disable(project);
                NOTIFICATION_GROUP.createNotification(JSBundle.message((String)"js.linter.guesser.linter.disabled", (Object[])new Object[]{descriptor2.getDisplayName()}), MessageType.INFO).notify(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterGuesser$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
        LOG.info(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableCases";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableCase";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterGuesser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "guessLinters";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInstalled";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doLog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class EnableCase
    extends Enum<EnableCase> {
        public static final /* enum */ EnableCase dependency = new EnableCase("js.linter.guesser.linter.enabled.because.of.dependency", JSLinterDescriptor::packageName);
        public static final /* enum */ EnableCase configSection = new EnableCase("js.linter.guesser.linter.enabled.because.of.package.json.section", JSLinterDescriptor::packageJsonSectionName);
        public static final /* enum */ EnableCase configFile = new EnableCase("js.linter.guesser.linter.enabled.because.of.config.file", null);
        private final String myMessageKey;
        @Nullable
        private final Function<JSLinterDescriptor, String> mySecondArgument;
        private static final EnableCase[] ORDER;
        private static final /* synthetic */ EnableCase[] $VALUES;

        public static EnableCase[] values() {
            return (EnableCase[])$VALUES.clone();
        }

        public static EnableCase valueOf(String name) {
            return Enum.valueOf(EnableCase.class, name);
        }

        private EnableCase(String key, Function<JSLinterDescriptor, String> argument) {
            if (key == null) {
                EnableCase.$$$reportNull$$$0(0);
            }
            this.myMessageKey = key;
            this.mySecondArgument = argument;
        }

        public String getMessage(@NotNull JSLinterDescriptor descriptor2) {
            if (descriptor2 == null) {
                EnableCase.$$$reportNull$$$0(1);
            }
            if (this.mySecondArgument == null) {
                return JSBundle.message((String)this.myMessageKey, (Object[])new Object[]{descriptor2.getDisplayName()});
            }
            return JSBundle.message((String)this.myMessageKey, (Object[])new Object[]{descriptor2.getDisplayName(), this.mySecondArgument.apply(descriptor2)});
        }

        @NotNull
        public static EnableCase select(Set<EnableCase> cases) {
            assert (!cases.isEmpty());
            if (cases.size() == 1) {
                EnableCase enableCase = cases.iterator().next();
                if (enableCase == null) {
                    EnableCase.$$$reportNull$$$0(2);
                }
                return enableCase;
            }
            for (EnableCase aCase : ORDER) {
                if (!cases.contains((Object)aCase)) continue;
                EnableCase enableCase = aCase;
                if (enableCase == null) {
                    EnableCase.$$$reportNull$$$0(3);
                }
                return enableCase;
            }
            assert (false);
            EnableCase enableCase = dependency;
            if (enableCase == null) {
                EnableCase.$$$reportNull$$$0(4);
            }
            return enableCase;
        }

        static {
            $VALUES = new EnableCase[]{dependency, configSection, configFile};
            ORDER = new EnableCase[]{configSection, configFile, dependency};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterGuesser$EnableCase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterGuesser$EnableCase";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "select";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

