/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.validity;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.controlflow.instruction.JSBranchInstruction;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JSGroupNames;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnreachableCodeJSInspection
extends JavaScriptInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionJSBundle.message("unreachable.code.display.name", new Object[0]);
        if (string == null) {
            UnreachableCodeJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = JSGroupNames.VALIDITY_GROUP_NAME;
        if (string == null) {
            UnreachableCodeJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return InspectionJSBundle.message("unreachable.code.error.string", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static boolean isUnreachableInstruction(@NotNull Instruction instruction) {
        Collection instructions;
        if (instruction == null) {
            UnreachableCodeJSInspection.$$$reportNull$$$0(2);
        }
        if ((instructions = instruction.allPred()).isEmpty()) {
            return true;
        }
        if (instruction instanceof JSBranchInstruction) {
            return false;
        }
        return instructions.stream().allMatch(el -> el instanceof JSBranchInstruction && !((JSBranchInstruction)el).isReachable());
    }

    private static boolean isFirstInstruction(Instruction instruction) {
        return instruction.num() == 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/inspectjs/validity/UnreachableCodeJSInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/inspectjs/validity/UnreachableCodeJSInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUnreachableInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFile(JSFile file2) {
            this.visitExecutionScope((JSExecutionScope)file2);
            super.visitJSFile(file2);
        }

        public void visitJSElement(JSElement node) {
            if (node instanceof JSExecutionScope) {
                this.visitExecutionScope((JSExecutionScope)node);
            }
            super.visitJSElement(node);
        }

        private void visitExecutionScope(@NotNull JSExecutionScope node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            JSControlFlowService.JSControlFlow flow = JSControlFlowService.getService(node.getProject()).getControlFlow((JSElement)node);
            Instruction[] instructions = flow.getInstructions();
            ArrayList unreachable = new ArrayList();
            if (instructions.length > 0) {
                ControlFlowUtil.iteratePrev((int)(instructions.length - 1), (Instruction[])instructions, instruction -> {
                    PsiElement element;
                    if (!UnreachableCodeJSInspection.isFirstInstruction(instruction) && UnreachableCodeJSInspection.isUnreachableInstruction(instruction) && (element = instruction.getElement()) instanceof JSStatement) {
                        unreachable.add((JSStatement)element);
                    }
                    return ControlFlowUtil.Operation.NEXT;
                });
            }
            unreachable.forEach(el -> {
                JSStatement[] statements;
                if (el instanceof JSBlockStatement && (statements = ((JSBlockStatement)el).getStatements()).length > 0) {
                    this.registerStatementError(statements[0], new Object[0]);
                    return;
                }
                this.registerStatementError((JSStatement)el, new Object[0]);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/sixrr/inspectjs/validity/UnreachableCodeJSInspection$Visitor", "visitExecutionScope"));
        }
    }
}

