/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc.pooling;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ImplementationAccessibleService;
import org.jetbrains.dekaf.util.Objects;

public class SimpleDataSource
implements DataSource,
ImplementationAccessibleService {
    @NotNull
    private final String myConnectionString;
    @NotNull
    private final Properties myConnectionProperties;
    @NotNull
    private final Driver myDriver;
    @Nullable
    private PrintWriter myLogWriter;

    public SimpleDataSource(@NotNull String connectionString, @Nullable Properties connectionProperties, @NotNull Driver driver) {
        this.myConnectionString = connectionString;
        this.myConnectionProperties = SimpleDataSource.cloneProperties(connectionProperties);
        this.myDriver = driver;
    }

    public void setConnectionProperty(@NotNull String name, @Nullable String value) {
        if (value != null) {
            this.myConnectionProperties.setProperty(name, value);
        } else {
            this.myConnectionProperties.remove(name);
        }
    }

    @NotNull
    private static Properties cloneProperties(@Nullable Properties properties) {
        Properties p = new Properties();
        if (properties != null) {
            p.putAll((Map<?, ?>)properties);
        }
        return p;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.myDriver.connect(this.myConnectionString, this.myConnectionProperties);
    }

    @Override
    public Connection getConnection(String username, String password) {
        throw new IllegalArgumentException("SimpleDataSource.getConnection(username, password) is not supported. You can pass credentials via connection string or via connection properties.");
    }

    @Override
    @Nullable
    public PrintWriter getLogWriter() {
        return this.myLogWriter;
    }

    @Override
    public void setLogWriter(@Nullable PrintWriter writer) {
        this.myLogWriter = writer;
    }

    @Override
    public void setLoginTimeout(int seconds) {
        throw new RuntimeException("The SimpleDataSource.setLoginTimeout has not been implemented yet.");
    }

    @Override
    public int getLoginTimeout() {
        throw new RuntimeException("The SimpleDataSource.getLoginTimeout has not been implemented yet.");
    }

    @Override
    @NotNull
    public <T> T unwrap(Class<T> iface) {
        if (iface.isAssignableFrom(SimpleDataSource.class)) {
            return (T)this;
        }
        throw new IllegalArgumentException(String.format("%s is not a wrapper for %s", SimpleDataSource.class.getSimpleName(), iface.getName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(SimpleDataSource.class);
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        if (serviceName.equalsIgnoreCase("jdbc-driver")) {
            return Objects.castTo(serviceClass, this.myDriver);
        }
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("The SimpleDataSource.getParentLogger is not supported by Dekaf 2.0.");
    }
}

