/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.ide.DataManager;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Url;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartBrowserPanel {
    private JCheckBox myStartBrowserCheckBox;
    private JComponent myBrowserComboBox;
    private JCheckBox myStartJavaScriptDebuggerCheckBox;
    private TextFieldWithBrowseButton myUrlField;
    private BrowserSelector myBrowserSelector;
    private JPanel myRoot;

    public StartBrowserPanel() {
        this.$$$setupUI$$$();
        this.myStartJavaScriptDebuggerCheckBox.setVisible(JavaScriptDebuggerStarter.Util.hasStarters());
        this.myRoot.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                StartBrowserPanel.this.myRoot.removeAncestorListener((AncestorListener)((Object)this));
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)StartBrowserPanel.this.myRoot));
                if (project == null) {
                    DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> {
                        Project project1 = (Project)CommonDataKeys.PROJECT.getData(context);
                        if (project1 == null) {
                            project1 = ProjectManager.getInstance().getDefaultProject();
                        }
                        StartBrowserPanel.setupUrlField(StartBrowserPanel.this.myUrlField, project1);
                    });
                } else {
                    StartBrowserPanel.setupUrlField(StartBrowserPanel.this.myUrlField, project);
                }
            }
        });
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myRoot;
        if (jPanel == null) {
            StartBrowserPanel.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Deprecated
    @Nullable
    public String getUrl() {
        return this.getNormalizedUrl();
    }

    @Nullable
    public String getNormalizedUrl() {
        String url = StringUtil.nullize((String)this.myUrlField.getText(), (boolean)true);
        if (url != null && !URLUtil.containsScheme((String)(url = url.trim()))) {
            return VirtualFileManager.constructUrl((String)"http", (String)url);
        }
        return url;
    }

    public void setUrl(@Nullable String url) {
        this.myUrlField.setText(url);
    }

    public boolean isSelected() {
        return this.myStartBrowserCheckBox.isSelected();
    }

    public void setSelected(boolean value) {
        this.myStartBrowserCheckBox.setSelected(value);
    }

    public JCheckBox getStartJavaScriptDebuggerCheckBox() {
        return this.myStartJavaScriptDebuggerCheckBox;
    }

    public BrowserSelector getBrowserSelector() {
        return this.myBrowserSelector;
    }

    private void createUIComponents() {
        this.myBrowserSelector = new BrowserSelector();
        this.myBrowserComboBox = this.myBrowserSelector.getMainComponent();
        if (UIUtil.isUnderAquaLookAndFeel()) {
            this.myBrowserComboBox.setBorder(new EmptyBorder(3, 0, 0, 0));
        }
    }

    @Nullable
    private static Url virtualFileToUrl(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            StartBrowserPanel.$$$reportNull$$$0(1);
        }
        if (project == null) {
            StartBrowserPanel.$$$reportNull$$$0(2);
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> {
            if (project == null) {
                StartBrowserPanel.$$$reportNull$$$0(6);
            }
            if (file2 == null) {
                StartBrowserPanel.$$$reportNull$$$0(7);
            }
            return PsiManager.getInstance((Project)project).findFile(file2);
        });
        return WebBrowserServiceImpl.getDebuggableUrl((PsiElement)psiFile);
    }

    @NotNull
    public StartBrowserSettings createSettings() {
        StartBrowserSettings browserSettings = new StartBrowserSettings();
        browserSettings.setSelected(this.isSelected());
        browserSettings.setBrowser(this.myBrowserSelector.getSelected());
        browserSettings.setStartJavaScriptDebugger(this.myStartJavaScriptDebuggerCheckBox.isSelected());
        browserSettings.setUrl(this.getNormalizedUrl());
        StartBrowserSettings startBrowserSettings = browserSettings;
        if (startBrowserSettings == null) {
            StartBrowserPanel.$$$reportNull$$$0(3);
        }
        return startBrowserSettings;
    }

    public void setFromSettings(StartBrowserSettings settings) {
        this.setSelected(settings.isSelected());
        this.setUrl(settings.getUrl());
        this.myStartJavaScriptDebuggerCheckBox.setSelected(settings.isStartJavaScriptDebugger());
        this.myBrowserSelector.setSelected(settings.getBrowser());
    }

    public static void setupUrlField(@NotNull TextFieldWithBrowseButton field, final @NotNull Project project) {
        if (field == null) {
            StartBrowserPanel.$$$reportNull$$$0(4);
        }
        if (project == null) {
            StartBrowserPanel.$$$reportNull$$$0(5);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file2) {
                return HtmlUtil.isHtmlFile(file2) || StartBrowserPanel.virtualFileToUrl(file2, project) != null;
            }
        };
        descriptor.setTitle(XmlBundle.message((String)"javascript.debugger.settings.choose.file.title", (Object[])new Object[0]));
        descriptor.setDescription(XmlBundle.message((String)"javascript.debugger.settings.choose.file.subtitle", (Object[])new Object[0]));
        descriptor.setRoots(ProjectRootManager.getInstance((Project)project).getContentRoots());
        field.addBrowseFolderListener(new TextBrowseFolderListener(descriptor, project){

            @NotNull
            protected String chosenFileToResultingText(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (chosenFile.isDirectory()) {
                    String string = chosenFile.getPath();
                    if (string == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                Url url = StartBrowserPanel.virtualFileToUrl(chosenFile, project);
                String string = url == null ? chosenFile.getUrl() : url.toDecodedForm();
                if (string == null) {
                    3.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chosenFile";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/browsers/StartBrowserPanel$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/browsers/StartBrowserPanel$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "chosenFileToResultingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "chosenFileToResultingText";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/StartBrowserPanel";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/StartBrowserPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "virtualFileToUrl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupUrlField";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$virtualFileToUrl$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/XmlBundle").getString("start.browser.border.label.open.browser"), (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        this.myStartBrowserCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/XmlBundle").getString("start.browser.checkbox.start.browser"));
        jCheckBox2.setVerticalTextPosition(0);
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComponent jComponent = this.myBrowserComboBox;
        jPanel.add((Component)jComponent, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myStartJavaScriptDebuggerCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/XmlBundle").getString("start.browser.with.js.debugger"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myUrlField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("URL:");
        jBLabel.setDisplayedMnemonic('U');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

