/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoFileItemProvider;
import com.intellij.ide.actions.NonProjectScopeDisablerEP;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.FilteringGotoByModel;
import com.intellij.ide.util.gotoByName.GotoFileCellRenderer;
import com.intellij.ide.util.gotoByName.GotoFileCustomizer;
import com.intellij.navigation.ChooseByNameContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.Matcher;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoFileModel
extends FilteringGotoByModel<FileType>
implements DumbAware,
Comparator<Object> {
    private final int myMaxSize;

    public GotoFileModel(@NotNull Project project) {
        if (project == null) {
            GotoFileModel.$$$reportNull$$$0(0);
        }
        super(project, ChooseByNameContributor.FILE_EP_NAME.getExtensionList());
        this.myMaxSize = ApplicationManager.getApplication().isUnitTestMode() ? Integer.MAX_VALUE : WindowManagerEx.getInstanceEx().getFrame((Project)project).getSize().width;
    }

    public boolean isSlashlessMatchingEnabled() {
        return true;
    }

    @Override
    @NotNull
    public ChooseByNameItemProvider getItemProvider(@Nullable PsiElement context) {
        for (GotoFileCustomizer customizer : GotoFileCustomizer.EP_NAME.getExtensionList()) {
            GotoFileItemProvider provider = customizer.createItemProvider(this.myProject, context, this);
            if (provider == null) continue;
            GotoFileItemProvider gotoFileItemProvider = provider;
            if (gotoFileItemProvider == null) {
                GotoFileModel.$$$reportNull$$$0(1);
            }
            return gotoFileItemProvider;
        }
        GotoFileItemProvider gotoFileItemProvider = new GotoFileItemProvider(this.myProject, context, this);
        if (gotoFileItemProvider == null) {
            GotoFileModel.$$$reportNull$$$0(2);
        }
        return gotoFileItemProvider;
    }

    @Override
    protected boolean acceptItem(NavigationItem item) {
        if (item instanceof PsiFile) {
            PsiFile file2 = (PsiFile)item;
            Collection types = this.getFilterItems();
            if (types != null) {
                if (types.contains(file2.getFileType())) {
                    return true;
                }
                VirtualFile vFile = file2.getVirtualFile();
                return vFile != null && types.contains(vFile.getFileType());
            }
            return true;
        }
        return super.acceptItem(item);
    }

    @Override
    @Nullable
    protected FileType filterValueFor(NavigationItem item) {
        return item instanceof PsiFile ? ((PsiFile)item).getFileType() : null;
    }

    public String getPromptText() {
        return IdeBundle.message((String)"prompt.gotofile.enter.file.name", (Object[])new Object[0]);
    }

    public String getCheckBoxName() {
        if (NonProjectScopeDisablerEP.isSearchInNonProjectDisabled()) {
            return null;
        }
        return IdeBundle.message((String)"checkbox.include.non.project.files", (Object[])new Object[]{IdeUICustomization.getInstance().getProjectConceptName()});
    }

    public String getNotInMessage() {
        return "";
    }

    public String getNotFoundMessage() {
        return IdeBundle.message((String)"label.no.files.found", (Object[])new Object[0]);
    }

    public boolean loadInitialCheckBoxState() {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        return propertiesComponent.isTrueValue("GoToClass.toSaveIncludeLibraries") && propertiesComponent.isTrueValue("GoToFile.includeJavaFiles");
    }

    public void saveInitialCheckBoxState(boolean state) {
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (propertiesComponent.isTrueValue("GoToClass.toSaveIncludeLibraries")) {
            propertiesComponent.setValue("GoToFile.includeJavaFiles", Boolean.toString(state));
        }
    }

    @Override
    public PsiElementListCellRenderer getListCellRenderer() {
        return new GotoFileCellRenderer(this.myMaxSize){

            @Override
            @NotNull
            protected PsiElementListCellRenderer.ItemMatchers getItemMatchers(@NotNull JList list2, @NotNull Object value) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiElementListCellRenderer.ItemMatchers defaultMatchers = super.getItemMatchers(list2, value);
                if (!(value instanceof PsiFileSystemItem)) {
                    PsiElementListCellRenderer.ItemMatchers itemMatchers = defaultMatchers;
                    if (itemMatchers == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return itemMatchers;
                }
                PsiElementListCellRenderer.ItemMatchers itemMatchers = GotoFileModel.convertToFileItemMatchers(defaultMatchers, (PsiFileSystemItem)value, GotoFileModel.this);
                if (itemMatchers == null) {
                    1.$$$reportNull$$$0(3);
                }
                return itemMatchers;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "list";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoFileModel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoFileModel$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getItemMatchers";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getItemMatchers";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    public boolean sameNamesForProjectAndLibraries() {
        return !FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping;
    }

    @Nullable
    public String getFullName(Object element) {
        return element instanceof PsiFileSystemItem ? this.getFullName(((PsiFileSystemItem)element).getVirtualFile()) : this.getElementName(element);
    }

    @Nullable
    public String getFullName(@NotNull VirtualFile file2) {
        VirtualFile root;
        if (file2 == null) {
            GotoFileModel.$$$reportNull$$$0(3);
        }
        return (root = this.getTopLevelRoot(file2)) != null ? GotoFileCellRenderer.getRelativePathFromRoot(file2, root) : GotoFileCellRenderer.getRelativePath(file2, this.myProject);
    }

    @Nullable
    public VirtualFile getTopLevelRoot(@NotNull VirtualFile file2) {
        VirtualFile root;
        if (file2 == null) {
            GotoFileModel.$$$reportNull$$$0(4);
        }
        return (root = this.getContentRoot(file2)) == null ? null : (VirtualFile)JBIterable.generate((Object)root, r -> this.getContentRoot(r.getParent())).last();
    }

    private VirtualFile getContentRoot(@Nullable VirtualFile file2) {
        return file2 == null ? null : GotoFileCellRenderer.getAnyRoot(file2, this.myProject);
    }

    @NotNull
    public String[] getSeparators() {
        String[] stringArray = new String[]{"/", "\\"};
        if (stringArray == null) {
            GotoFileModel.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    @Override
    public String getHelpId() {
        return "procedures.navigating.goto.class";
    }

    public boolean willOpenEditor() {
        return true;
    }

    @Override
    @NotNull
    public String removeModelSpecificMarkup(@NotNull String pattern) {
        if (pattern == null) {
            GotoFileModel.$$$reportNull$$$0(6);
        }
        if (pattern.endsWith("/") || pattern.endsWith("\\")) {
            String string = pattern.substring(0, pattern.length() - 1);
            if (string == null) {
                GotoFileModel.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = pattern;
        if (string == null) {
            GotoFileModel.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public int compare(Object o1, Object o2) {
        return 0;
    }

    @NotNull
    public static PsiElementListCellRenderer.ItemMatchers convertToFileItemMatchers(@NotNull PsiElementListCellRenderer.ItemMatchers defaultMatchers, @NotNull PsiFileSystemItem value, @NotNull GotoFileModel model) {
        if (defaultMatchers == null) {
            GotoFileModel.$$$reportNull$$$0(9);
        }
        if (value == null) {
            GotoFileModel.$$$reportNull$$$0(10);
        }
        if (model == null) {
            GotoFileModel.$$$reportNull$$$0(11);
        }
        String shortName = model.getElementName(value);
        String fullName = model.getFullName(value);
        if (shortName != null && fullName != null && defaultMatchers.nameMatcher instanceof MinusculeMatcher) {
            String sanitized = GotoFileItemProvider.getSanitizedPattern(((MinusculeMatcher)defaultMatchers.nameMatcher).getPattern(), model);
            for (int i = sanitized.lastIndexOf(47) + 1; i < sanitized.length() - 1; ++i) {
                MinusculeMatcher nameMatcher = NameUtil.buildMatcher((String)("*" + sanitized.substring(i)), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
                if (!nameMatcher.matches(shortName)) continue;
                String locationPattern = FileUtil.toSystemDependentName((String)StringUtil.trimEnd((String)sanitized.substring(0, i), (String)"/"));
                PsiElementListCellRenderer.ItemMatchers itemMatchers = new PsiElementListCellRenderer.ItemMatchers((Matcher)nameMatcher, (Matcher)GotoFileItemProvider.getQualifiedNameMatcher(locationPattern));
                if (itemMatchers == null) {
                    GotoFileModel.$$$reportNull$$$0(12);
                }
                return itemMatchers;
            }
        }
        PsiElementListCellRenderer.ItemMatchers itemMatchers = defaultMatchers;
        if (itemMatchers == null) {
            GotoFileModel.$$$reportNull$$$0(13);
        }
        return itemMatchers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoFileModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMatchers";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoFileModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparators";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModelSpecificMarkup";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToFileItemMatchers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFullName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeModelSpecificMarkup";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertToFileItemMatchers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

