/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.idCache;

import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.lexer.Lexer;
import com.intellij.psi.impl.cache.CacheUtil;
import com.intellij.psi.impl.cache.impl.BaseFilterLexer;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.idCache.XmlFilterLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;

public class XHtmlFilterLexer
extends BaseFilterLexer {
    public XHtmlFilterLexer(Lexer originalLexer, OccurrenceConsumer table) {
        super(originalLexer, table);
    }

    public void advance() {
        IElementType tokenType = this.myDelegate.getTokenType();
        if (tokenType == XmlTokenType.XML_COMMENT_CHARACTERS) {
            this.scanWordsInToken(2, false, false);
            this.advanceTodoItemCountsInToken();
        } else if (tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN || tokenType == XmlTokenType.XML_NAME || tokenType == XmlTokenType.XML_TAG_NAME || tokenType == XmlTokenType.XML_DATA_CHARACTERS) {
            this.scanWordsInToken(24, tokenType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, false);
        } else if (tokenType.getLanguage() != XMLLanguage.INSTANCE && tokenType.getLanguage() != Language.ANY) {
            boolean inComments = CacheUtil.isInComments(tokenType);
            this.scanWordsInToken(inComments ? 2 : 24, true, false);
            if (inComments) {
                this.advanceTodoItemCountsInToken();
            }
        } else if (!XmlFilterLexer.NO_WORDS_TOKEN_SET.contains(tokenType)) {
            this.scanWordsInToken(16, false, false);
        }
        this.myDelegate.advance();
    }
}

