/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class CommonMoveUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.CommonMoveUtil");

    private CommonMoveUtil() {
    }

    public static NonCodeUsageInfo[] retargetUsages(UsageInfo[] usages, Map<PsiElement, PsiElement> oldToNewElementsMapping) throws IncorrectOperationException {
        Arrays.sort(usages, (o1, o2) -> {
            VirtualFile file2;
            VirtualFile file1 = o1.getVirtualFile();
            if (Comparing.equal((Object)file1, (Object)(file2 = o2.getVirtualFile()))) {
                ProperTextRange rangeInElement1 = o1.getRangeInElement();
                ProperTextRange rangeInElement2 = o2.getRangeInElement();
                if (rangeInElement1 != null && rangeInElement2 != null) {
                    return rangeInElement2.getStartOffset() - rangeInElement1.getStartOffset();
                }
                return 0;
            }
            if (file1 == null) {
                return -1;
            }
            if (file2 == null) {
                return 1;
            }
            return Comparing.compare((Comparable)((Object)file1.getPath()), (Comparable)((Object)file2.getPath()));
        });
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof NonCodeUsageInfo) {
                nonCodeUsages.add((NonCodeUsageInfo)usage);
                continue;
            }
            if (!(usage instanceof MoveRenameUsageInfo)) continue;
            MoveRenameUsageInfo moveRenameUsage = (MoveRenameUsageInfo)usage;
            PsiElement oldElement = moveRenameUsage.getReferencedElement();
            PsiElement newElement = oldToNewElementsMapping.get(oldElement);
            LOG.assertTrue(newElement != null, (Object)oldElement);
            PsiReference reference2 = moveRenameUsage.getReference();
            if (reference2 == null) continue;
            try {
                reference2.bindToElement(newElement);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        return nonCodeUsages.toArray(new NonCodeUsageInfo[0]);
    }
}

