/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialPromptDialog;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import gnu.trove.THashMap;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WSLDistribution {
    static final String WSL_MNT_ROOT = "/mnt/";
    private static final int RESOLVE_SYMLINK_TIMEOUT = 10000;
    private static final String RUN_PARAMETER = "run";
    private static final Logger LOG = Logger.getInstance(WSLDistribution.class);
    private static final Key<ProcessListener> SUDO_LISTENER_KEY = Key.create((String)"WSL sudo listener");
    @NotNull
    private final WslDistributionDescriptor myDescriptor;
    @NotNull
    private final Path myExecutablePath;

    protected WSLDistribution(@NotNull WSLDistribution dist) {
        if (dist == null) {
            WSLDistribution.$$$reportNull$$$0(0);
        }
        this(dist.myDescriptor, dist.myExecutablePath);
    }

    WSLDistribution(@NotNull WslDistributionDescriptor descriptor, @NotNull Path executablePath) {
        if (descriptor == null) {
            WSLDistribution.$$$reportNull$$$0(1);
        }
        if (executablePath == null) {
            WSLDistribution.$$$reportNull$$$0(2);
        }
        this.myDescriptor = descriptor;
        this.myExecutablePath = executablePath;
    }

    @NotNull
    public Path getExecutablePath() {
        Path path = this.myExecutablePath;
        if (path == null) {
            WSLDistribution.$$$reportNull$$$0(3);
        }
        return path;
    }

    @Nullable
    public String readReleaseInfo() {
        try {
            String key = "PRETTY_NAME";
            String releaseInfo = "/etc/os-release";
            ProcessOutput output = this.executeOnWsl(10000, "cat", "/etc/os-release");
            if (!output.checkSuccess(LOG)) {
                return null;
            }
            for (String line : output.getStdoutLines(true)) {
                if (!line.startsWith("PRETTY_NAME") || line.length() < "PRETTY_NAME".length() + 1) continue;
                String prettyName = line.substring("PRETTY_NAME".length() + 1);
                return StringUtil.nullize((String)StringUtil.unquoteString((String)prettyName));
            }
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
        return null;
    }

    @NotNull
    public GeneralCommandLine createWslCommandLine(String ... args) {
        if (args == null) {
            WSLDistribution.$$$reportNull$$$0(4);
        }
        GeneralCommandLine generalCommandLine = this.patchCommandLine(new GeneralCommandLine(args), null, null, false);
        if (generalCommandLine == null) {
            WSLDistribution.$$$reportNull$$$0(5);
        }
        return generalCommandLine;
    }

    public ProcessOutput executeOnWsl(int timeout, @Nullable Consumer<? super ProcessHandler> processHandlerConsumer, String ... args) throws ExecutionException {
        if (args == null) {
            WSLDistribution.$$$reportNull$$$0(6);
        }
        GeneralCommandLine commandLine = this.createWslCommandLine(args);
        CapturingProcessHandler processHandler2 = new CapturingProcessHandler(commandLine);
        if (processHandlerConsumer != null) {
            processHandlerConsumer.consume((Object)processHandler2);
        }
        return WSLUtil.addInputCloseListener(processHandler2).runProcess(timeout);
    }

    public ProcessOutput executeOnWsl(int timeout, String ... args) throws ExecutionException {
        if (args == null) {
            WSLDistribution.$$$reportNull$$$0(7);
        }
        return this.executeOnWsl(timeout, (Consumer<? super ProcessHandler>)null, args);
    }

    public ProcessOutput executeOnWsl(@Nullable Consumer<? super ProcessHandler> processHandlerConsumer, String ... args) throws ExecutionException {
        if (args == null) {
            WSLDistribution.$$$reportNull$$$0(8);
        }
        return this.executeOnWsl(-1, processHandlerConsumer, args);
    }

    public ProcessOutput copyFromWsl(@NotNull String wslPath, @NotNull String windowsPath, @Nullable List<String> additionalOptions, @Nullable Consumer<? super ProcessHandler> handlerConsumer) throws ExecutionException {
        if (wslPath == null) {
            WSLDistribution.$$$reportNull$$$0(9);
        }
        if (windowsPath == null) {
            WSLDistribution.$$$reportNull$$$0(10);
        }
        new File(windowsPath).mkdirs();
        ArrayList<String> command = new ArrayList<String>(Arrays.asList("rsync", "-cr"));
        if (additionalOptions != null) {
            command.addAll(additionalOptions);
        }
        command.add(wslPath + "/");
        String targetWslPath = this.getWslPath(windowsPath);
        if (targetWslPath == null) {
            throw new ExecutionException("Unable to copy files to " + windowsPath);
        }
        command.add(targetWslPath + "/");
        return this.executeOnWsl(handlerConsumer, ArrayUtil.toStringArray(command));
    }

    @NotNull
    public <T extends GeneralCommandLine> T patchCommandLine(@NotNull T commandLine, final @Nullable Project project, @Nullable String remoteWorkingDir, boolean askForSudo) {
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(11);
        }
        THashMap additionalEnvs = new THashMap(commandLine.getEnvironment());
        commandLine.getEnvironment().clear();
        LOG.info("[" + this.getId() + "] Patching: " + commandLine.getCommandLineString() + "; working dir: " + remoteWorkingDir + "; envs: " + additionalEnvs.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", ")) + (askForSudo ? "; with sudo" : ": without sudo"));
        StringBuilder commandLineString = new StringBuilder();
        ParametersList parametersList = commandLine.getParametersList();
        List realParamsList = parametersList.getList();
        if (realParamsList.size() == 2 && "bash".equals(commandLine.getExePath()) && "-c".equals(realParamsList.get(0))) {
            commandLineString.append((String)realParamsList.get(1));
        } else {
            commandLineString.append(commandLine.getCommandLineString());
        }
        if (askForSudo) {
            WSLDistribution.prependCommandLineString(commandLineString, "sudo", "-S", "-p", "''");
            SUDO_LISTENER_KEY.set(commandLine, (Object)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    OutputStream input;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((input = event.getProcessHandler().getProcessInput()) == null) {
                        return;
                    }
                    String password = CredentialPromptDialog.askPassword(project, "Enter Root Password", "Sudo password for " + WSLDistribution.this.getPresentableName() + " root:", new CredentialAttributes("WSL", "root", WSLDistribution.class), true);
                    if (password != null) {
                        try (PrintWriter pw = new PrintWriter(input);){
                            pw.println(password);
                        }
                    }
                    super.startNotified(event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/wsl/WSLDistribution$1", "startNotified"));
                }
            });
        }
        if (StringUtil.isNotEmpty((String)remoteWorkingDir)) {
            WSLDistribution.prependCommandLineString(commandLineString, "cd", remoteWorkingDir, "&&");
        }
        additionalEnvs.forEach((key, val) -> {
            if (StringUtil.containsChar((String)val, (char)'*') && !StringUtil.isQuotedString((String)val)) {
                val = "'" + val + "'";
            }
            WSLDistribution.prependCommandLineString(commandLineString, "export", key + "=" + val, "&&");
        });
        commandLine.setExePath(this.getExecutablePath().toString());
        parametersList.clearAll();
        parametersList.add(this.getRunCommandLineParameter());
        parametersList.add(commandLineString.toString());
        LOG.info("[" + this.getId() + "] Patched as: " + commandLine.getCommandLineString());
        T t = commandLine;
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(12);
        }
        return t;
    }

    @NotNull
    protected String getRunCommandLineParameter() {
        if (RUN_PARAMETER == null) {
            WSLDistribution.$$$reportNull$$$0(13);
        }
        return RUN_PARAMETER;
    }

    @NotNull
    public String resolveSymlink(@NotNull String path, int timeoutInMilliseconds) {
        block5: {
            String string;
            if (path == null) {
                WSLDistribution.$$$reportNull$$$0(14);
            }
            try {
                ProcessOutput output = this.executeOnWsl(timeoutInMilliseconds, "readlink", "-f", path);
                if (output.getExitCode() != 0) break block5;
                String stdout = output.getStdout().trim();
                if (output.getExitCode() != 0 || !StringUtil.isNotEmpty((String)stdout)) break block5;
                string = stdout;
            }
            catch (ExecutionException e) {
                LOG.debug("Error while resolving symlink: " + path, (Throwable)e);
            }
            if (string == null) {
                WSLDistribution.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String resolveSymlink(@NotNull String path) {
        if (path == null) {
            WSLDistribution.$$$reportNull$$$0(17);
        }
        String string = this.resolveSymlink(path, 10000);
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public <T extends ProcessHandler> T patchProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull T processHandler2) {
        ProcessListener listener2;
        if (commandLine == null) {
            WSLDistribution.$$$reportNull$$$0(19);
        }
        if (processHandler2 == null) {
            WSLDistribution.$$$reportNull$$$0(20);
        }
        if ((listener2 = (ProcessListener)SUDO_LISTENER_KEY.get((UserDataHolder)commandLine)) != null) {
            processHandler2.addProcessListener(listener2);
            SUDO_LISTENER_KEY.set((UserDataHolder)commandLine, null);
        }
        T t = processHandler2;
        if (t == null) {
            WSLDistribution.$$$reportNull$$$0(21);
        }
        return t;
    }

    @NotNull
    public Map<String, String> getEnvironment() {
        THashMap tHashMap;
        try {
            ProcessOutput processOutput = this.executeOnWsl(5000, "env");
            THashMap result2 = new THashMap();
            for (String string : processOutput.getStdoutLines()) {
                int assignIndex = string.indexOf(61);
                if (assignIndex == -1) {
                    result2.put(string, "");
                    continue;
                }
                result2.put(string.substring(0, assignIndex), string.substring(assignIndex + 1));
            }
            tHashMap = result2;
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                WSLDistribution.$$$reportNull$$$0(23);
            }
            return map;
        }
        if (tHashMap == null) {
            WSLDistribution.$$$reportNull$$$0(22);
        }
        return tHashMap;
    }

    @Nullable
    public String getWindowsPath(@NotNull String wslPath) {
        if (wslPath == null) {
            WSLDistribution.$$$reportNull$$$0(24);
        }
        return WSLUtil.getWindowsPath(wslPath);
    }

    @Nullable
    public String getWslPath(@NotNull String windowsPath) {
        if (windowsPath == null) {
            WSLDistribution.$$$reportNull$$$0(25);
        }
        if (FileUtil.isWindowsAbsolutePath((String)windowsPath)) {
            return WSL_MNT_ROOT + Character.toLowerCase(windowsPath.charAt(0)) + FileUtil.toSystemIndependentName((String)windowsPath.substring(2));
        }
        return null;
    }

    @NotNull
    public String getId() {
        String string = this.myDescriptor.getId();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public String getMsId() {
        String string = this.myDescriptor.getMsId();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myDescriptor.getPresentableName();
        if (string == null) {
            WSLDistribution.$$$reportNull$$$0(28);
        }
        return string;
    }

    public String toString() {
        return "WSLDistribution{myDescriptor=" + this.myDescriptor + '}';
    }

    private static void prependCommandLineString(@NotNull StringBuilder commandLineString, String ... commands) {
        if (commandLineString == null) {
            WSLDistribution.$$$reportNull$$$0(29);
        }
        if (commands == null) {
            WSLDistribution.$$$reportNull$$$0(30);
        }
        commandLineString.insert(0, WSLDistribution.createAdditionalCommand(commands) + " ");
    }

    private static String createAdditionalCommand(String ... commands) {
        if (commands == null) {
            WSLDistribution.$$$reportNull$$$0(31);
        }
        return new GeneralCommandLine(commands).getCommandLineString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WSLDistribution that = (WSLDistribution)o;
        return this.myDescriptor.equals(that.myDescriptor);
    }

    public int hashCode() {
        return this.myDescriptor.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WSLDistribution";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 9: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslPath";
                break;
            }
            case 10: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "windowsPath";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineString";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WSLDistribution";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutablePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createWslCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommandLine";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunCommandLineParameter";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveSymlink";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "patchProcessHandler";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getMsId";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createWslCommandLine";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeOnWsl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyFromWsl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 14: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymlink";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "patchProcessHandler";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getWindowsPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getWslPath";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "prependCommandLineString";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

