/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.undo;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.HashMap;

public class UmlUndoableAction
extends BasicUndoableAction {
    private DiagramBuilder myBuilder;
    private DiagramState myOldState;
    private DiagramState myNewState;

    public UmlUndoableAction(DiagramBuilder builder, DiagramState oldState, PsiFile[] files) {
        super(UmlUndoableAction.getAffectedDocuments(builder, files));
        this.myBuilder = builder;
        this.myOldState = oldState;
        this.myNewState = new DiagramState(builder);
        Disposer.register((Disposable)builder, () -> {
            this.myBuilder = null;
            this.myOldState = null;
            this.myNewState = null;
        });
    }

    public void undo() throws UnexpectedUndoException {
        this.checkState();
        PsiDocumentManager.getInstance((Project)this.myBuilder.getProject()).commitAllDocuments();
        this.myBuilder.getEditor().setUmlState(this.myOldState);
    }

    public void redo() throws UnexpectedUndoException {
        this.checkState();
        PsiDocumentManager.getInstance((Project)this.myBuilder.getProject()).commitAllDocuments();
        this.myBuilder.getEditor().setUmlState(this.myNewState);
    }

    private void checkState() throws UnexpectedUndoException {
        if (this.myBuilder == null) {
            throw new UnexpectedUndoException("Unexpected UML editor state");
        }
    }

    public static DocumentReference[] getAffectedDocuments(DiagramBuilder builder, PsiFile ... files) {
        if (files.length == 0) {
            return new DocumentReference[]{builder.getDocumentReference()};
        }
        ArrayList<DocumentReference> refs = new ArrayList<DocumentReference>();
        refs.add(builder.getDocumentReference());
        for (PsiFile file : files) {
            VirtualFile vf;
            if (!file.isValid() || (vf = file.getVirtualFile()) == null || !vf.isValid()) continue;
            refs.add(DocumentReferenceManager.getInstance().create(vf));
        }
        return refs.toArray(DocumentReference.EMPTY_ARRAY);
    }

    public boolean isNodeMoved() {
        String[] oldFqns = this.myOldState.getFQNs();
        String[] newFqns = this.myNewState.getFQNs();
        HashMap<String, Couple> oldCoord = new HashMap<String, Couple>();
        for (String fqn : oldFqns) {
            oldCoord.put(fqn, Couple.of((Object)this.myOldState.getNodeX(fqn), (Object)this.myOldState.getNodeY(fqn)));
        }
        for (String fqn : newFqns) {
            Couple coord = Couple.of((Object)this.myNewState.getNodeX(fqn), (Object)this.myNewState.getNodeY(fqn));
            Couple old = (Couple)oldCoord.remove(fqn);
            if (old != null && old.equals((Object)coord)) continue;
            return false;
        }
        return oldCoord.isEmpty();
    }
}

