/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.application;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.CvsVcs2;
import com.intellij.cvsSupport2.application.AddHandler;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.application.CvsFileOperationsHandler;
import com.intellij.cvsSupport2.application.DeleteHandler;
import com.intellij.cvsSupport2.application.DeletedCVSDirectoryStorage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class CvsStorageSupportingDeletionComponent
implements VirtualFileListener {
    private static final Logger LOG = Logger.getInstance(CvsStorageSupportingDeletionComponent.class);
    protected boolean myIsActive = false;
    private Project myProject;
    private DeletedCVSDirectoryStorage myDeletedStorage;
    private DeleteHandler myDeleteHandler = null;
    private AddHandler myAddHandler = null;
    private CvsFileOperationsHandler myFileOperationsHandler;
    private int myCommandLevel = 0;
    private boolean myAnotherProjectCommand = false;
    static final Key<AbstractVcs> FILE_VCS = new Key("File VCS");
    private Disposable myListenerDisposable = Disposer.newDisposable();

    @NotNull
    public static CvsStorageSupportingDeletionComponent getInstance(@NotNull Project project) {
        if (project == null) {
            CvsStorageSupportingDeletionComponent.$$$reportNull$$$0(0);
        }
        CvsStorageSupportingDeletionComponent cvsStorageSupportingDeletionComponent = (CvsStorageSupportingDeletionComponent)ServiceManager.getService((Project)project, CvsStorageSupportingDeletionComponent.class);
        if (cvsStorageSupportingDeletionComponent == null) {
            CvsStorageSupportingDeletionComponent.$$$reportNull$$$0(1);
        }
        return cvsStorageSupportingDeletionComponent;
    }

    public void init(@NotNull Project project) {
        if (project == null) {
            CvsStorageSupportingDeletionComponent.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.initializeDeletedStorage();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this, this.myListenerDisposable);
        CvsEntriesManager.getInstance().registerAsVirtualFileListener();
        project.getMessageBus().connect(this.myListenerDisposable).subscribe(CommandListener.TOPIC, (Object)new CommandListener(){

            public void commandStarted(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                CvsStorageSupportingDeletionComponent.this.myCommandLevel++;
                if (CvsStorageSupportingDeletionComponent.this.myCommandLevel == 1) {
                    CvsStorageSupportingDeletionComponent.this.myAnotherProjectCommand = event.getProject() == null == (event.getProject() == CvsStorageSupportingDeletionComponent.this.myProject);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Started" + event.getCommandName() + ", commandLevel: " + CvsStorageSupportingDeletionComponent.this.myCommandLevel);
                }
            }

            public void commandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                CvsStorageSupportingDeletionComponent.this.myCommandLevel--;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finished" + event.getCommandName() + ", commandLevel: " + CvsStorageSupportingDeletionComponent.this.myCommandLevel);
                }
                CvsStorageSupportingDeletionComponent.this.execute();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/cvsSupport2/application/CvsStorageSupportingDeletionComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myFileOperationsHandler = new CvsFileOperationsHandler(project, this);
        LocalFileSystem.getInstance().registerAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this.myFileOperationsHandler);
        this.myIsActive = true;
    }

    public void deactivate() {
        Disposable listenerDisposable = this.myListenerDisposable;
        if (listenerDisposable == null) {
            return;
        }
        this.myListenerDisposable = null;
        Disposer.dispose((Disposable)listenerDisposable);
        CvsEntriesManager.getInstance().unregisterAsVirtualFileListener();
        LocalFileSystem.getInstance().unregisterAuxiliaryFileOperationsHandler((LocalFileOperationsHandler)this.myFileOperationsHandler);
        this.myFileOperationsHandler = null;
        this.myIsActive = false;
        this.myProject = null;
    }

    public DeleteHandler getDeleteHandler() {
        if (this.myDeleteHandler == null) {
            this.myDeleteHandler = this.myDeletedStorage.createDeleteHandler(this.myProject, this);
        }
        return this.myDeleteHandler;
    }

    private boolean shouldProcessEvent(VirtualFileEvent event) {
        if (this.myAnotherProjectCommand) {
            return false;
        }
        VirtualFile file = event.getFile();
        return !this.disabled(file) && !event.isFromRefresh() && !CvsStorageSupportingDeletionComponent.isStorageEvent(event) && this.isUnderCvsManagedModuleRoot(file);
    }

    public boolean getIsActive() {
        return this.myIsActive;
    }

    private static boolean isStorageEvent(VirtualFileEvent event) {
        return event.getRequestor() instanceof DeletedCVSDirectoryStorage;
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        if (event == null) {
            CvsStorageSupportingDeletionComponent.$$$reportNull$$$0(3);
        }
        this.fileCreated((VirtualFileEvent)event);
    }

    private boolean processMoveOrRename() {
        return this.myDeleteHandler != null;
    }

    private AbstractVcs getFileVcs(VirtualFile file) {
        AbstractVcs storedData = (AbstractVcs)file.getUserData(FILE_VCS);
        if (storedData != null) {
            return storedData;
        }
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file);
    }

    private boolean isUnderCvsManagedModuleRoot(VirtualFile file) {
        return this.getFileVcs(file) == CvsVcs2.getInstance(this.myProject);
    }

    private boolean disabled(VirtualFile file) {
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file) != CvsVcs2.getInstance(this.myProject);
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            CvsStorageSupportingDeletionComponent.$$$reportNull$$$0(4);
        }
        if (!event.getPropertyName().equals("name")) {
            return;
        }
        if (!CvsUtil.fileIsUnderCvs(event.getFile())) {
            return;
        }
        this.beforeFileDeletion((VirtualFileEvent)event);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        if (event == null) {
            CvsStorageSupportingDeletionComponent.$$$reportNull$$$0(5);
        }
        if (this.processMoveOrRename()) {
            this.fileDeleted((VirtualFileEvent)event);
            this.fileCreated((VirtualFileEvent)event);
        }
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        if (event == null) {
            CvsStorageSupportingDeletionComponent.$$$reportNull$$$0(6);
        }
        if (!this.shouldProcessEvent(event)) {
            return;
        }
        Project project = this.myProject;
        if (project == null) {
            return;
        }
        VirtualFile file = event.getFile();
        if (this.myDeleteHandler != null) {
            this.myDeleteHandler.removeDeletedRoot(file);
        }
        this.myDeletedStorage.checkNeedForPurge(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        this.deleteIfAdminDirCreated(file);
        this.getAddHandler().addFile(file);
        this.execute();
    }

    public AddHandler getAddHandler() {
        if (this.myAddHandler == null) {
            this.myAddHandler = new AddHandler(this.myProject, this);
        }
        return this.myAddHandler;
    }

    private void execute() {
        if (this.myCommandLevel > 0) {
            return;
        }
        if (!this.myAnotherProjectCommand) {
            if (this.myDeleteHandler != null) {
                this.myDeleteHandler.execute();
            }
            if (this.myAddHandler != null) {
                this.myAddHandler.execute();
            }
        }
        this.myAnotherProjectCommand = false;
        this.myDeleteHandler = null;
        this.myAddHandler = null;
    }

    private void initializeDeletedStorage() {
        File storageRoot = CvsStorageSupportingDeletionComponent.getStorageRoot();
        FileUtilRt.createDirectory((File)storageRoot);
        this.myDeletedStorage = new DeletedCVSDirectoryStorage(storageRoot);
    }

    private static File getStorageRoot() {
        return new File(PathManager.getSystemPath(), "CVS-TO-DELETE");
    }

    public void sync() {
    }

    public void deleteIfAdminDirCreated(VirtualFile addedFile) {
        this.myDeletedStorage.deleteIfAdminDirCreated(addedFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cvsSupport2/application/CvsStorageSupportingDeletionComponent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cvsSupport2/application/CvsStorageSupportingDeletionComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fileMoved";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "beforePropertyChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fileCreated";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

