/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.run.filters;

import b.h.la;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.run.filters.FileLinksFilterUtil;
import org.jetbrains.plugins.ruby.ruby.run.filters.OpenSrcFileHyperlinkInfo;

public class RStackTraceFilter
implements Filter {
    public static final String FILE_PATH_WITHOUT_EXTENSION_PATTERN = "(?<=^|[\\s\\[])(?:\\.{1,2}|[A-Za-z]:|[/\\p{Alnum}_~])[^:\\s]+\\.";
    public static final String EXCEPTION_LINE_NUMBER_PATTERN = ":(\\d+)";
    private static final Pattern f;
    private final String i;
    private static final String d = "/app/";
    private static final String k = "/lib/";
    private static final String g = "/vendor/";
    private static final String e = "/config/";
    private static final String l = "/db/migrate/";
    private static final String j = "/test/";
    private static final String h = "/spec/";
    private static final TextAttributes b;
    private final Project a;
    private final List<String> c;
    private static final long m;

    public RStackTraceFilter(@NotNull Project project) {
        if (project == null) {
            RStackTraceFilter.a(0);
        }
        this(project, null);
    }

    public RStackTraceFilter(@NotNull Module module) {
        if (module == null) {
            RStackTraceFilter.a(1);
        }
        this(module, null);
    }

    public RStackTraceFilter(@NotNull Module module, @Nullable String workingDir) {
        if (module == null) {
            RStackTraceFilter.a(2);
        }
        this(module.getProject(), workingDir);
    }

    public RStackTraceFilter(@NotNull Project project, @Nullable String workingDir) {
        if (project == null) {
            RStackTraceFilter.a(3);
        }
        this.a = project;
        this.i = !StringUtil.isEmpty((String)workingDir) ? workingDir + '/' : null;
        this.c = RubyPsiUtil.collectNotNull(ContainerUtil.map((Object[])RModuleUtil.getInstance().getAllModulesWithRubySupport(project), module -> RStackTraceFilter.a(module)));
    }

    private static String a(Module module) {
        String string = RailsFacetUtil.getRailsAppHomeDirPath(module);
        if (string != null) {
            return string;
        }
        VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getContentRoots();
        return virtualFileArray.length > 0 ? virtualFileArray[0].getPath() : null;
    }

    public Filter.Result applyFilter(String line, int entireLength) {
        Matcher matcher;
        if (this.a.isDisposed()) {
            return null;
        }
        String string = FileLinksFilterUtil.cutLineIfLong(line);
        int n2 = 0;
        while ((matcher = RStackTraceFilter.matchLine(string, n2)) != null) {
            int n3;
            n2 = matcher.end();
            File file = this.a(matcher.group(1));
            if (file == null || FileLinksFilterUtil.hasExeExtension(file)) continue;
            try {
                n3 = matcher.group(2) == null ? 1 : Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            int n4 = entireLength - line.length();
            int n5 = n4 + matcher.start();
            int n6 = n4 + matcher.end();
            OpenSrcFileHyperlinkInfo openSrcFileHyperlinkInfo = new OpenSrcFileHyperlinkInfo(this.a, file, n3 - 1){

                @Override
                @Nullable
                protected VirtualFile findVirtualFile() {
                    return (VirtualFile)WriteAction.computeAndWait(() -> VfsUtil.findFileByIoFile((File)this.getFile(), (boolean)true));
                }
            };
            TextAttributes textAttributes = b.clone();
            if (!this.a(file)) {
                Color color = UIUtil.getInactiveTextColor();
                textAttributes.setForegroundColor(color);
                textAttributes.setEffectColor(color);
            }
            return new Filter.Result(n5, n6, (HyperlinkInfo)openSrcFileHyperlinkInfo, textAttributes);
        }
        return null;
    }

    @Nullable
    private File a(String string) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        long l2 = m ^ 0x40AB05094D3L;
        if (this.i != null && string.startsWith(".")) {
            string = this.i + string;
        }
        ArrayList arrayList = ContainerUtil.newArrayList(this.c);
        arrayList.add(this.i);
        File file = FileLinksFilterUtil.getFileByRubyLink(string, arrayList);
        if (file != null) {
            return file;
        }
        int n7 = (string = FileUtil.toSystemIndependentName((String)string)).indexOf(d);
        int n8 = n7 > 0 ? n7 : ((n6 = string.indexOf(k)) > 0 ? n6 : ((n5 = string.indexOf(g)) > 0 ? n5 : ((n4 = string.indexOf(l)) > 0 ? n4 : ((n3 = string.indexOf(e)) > 0 ? n3 : ((n2 = string.indexOf(j)) > 0 ? n2 : string.indexOf(h))))));
        if (n8 < 0) {
            return null;
        }
        for (String string2 : this.c) {
            string = (ApplicationManager.getApplication().isUnitTestMode() ? this.i : string2) + string.substring(n8);
            File file2 = FileLinksFilterUtil.getFileByRubyLink(string);
            if (file2 == null) continue;
            return file2;
        }
        return null;
    }

    private boolean a(@NotNull File file) {
        if (file == null) {
            RStackTraceFilter.a(4);
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        for (File file2 = file; file2 != null; file2 = file2.getParentFile()) {
            VirtualFile virtualFile = localFileSystem.findFileByIoFile(file2);
            if (virtualFile == null || !virtualFile.isValid()) continue;
            return ProjectRootManager.getInstance((Project)this.a).getFileIndex().isInContent(virtualFile);
        }
        return false;
    }

    protected static Pattern getPattern() {
        return f;
    }

    public static Matcher matchLine(@NotNull String line) {
        if (line == null) {
            RStackTraceFilter.a(5);
        }
        return RStackTraceFilter.matchLine(line, 0);
    }

    @Nullable
    public static Matcher matchLine(String cuttedLine, int offset) {
        Matcher matcher = f.matcher(cuttedLine);
        if (!matcher.find(offset)) {
            return null;
        }
        return matcher;
    }

    static {
        m = la.a(3331132746767983753L, -7092684463576580520L, MethodHandles.lookup().lookupClass()).a(237058529001167L);
        long l2 = m ^ 0x72DA43B8AF9DL;
        f = Pattern.compile("((?<=^|[\\s\\[])(?:\\.{1,2}|[A-Za-z]:|[/\\p{Alnum}_~])[^:\\s]+\\.[\\w~]+)(?::(\\d+))?");
        b = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = m ^ 0x320BF1B796F1L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/run/filters/RStackTraceFilter";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "matchLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

