/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.AbstractSdkRefresher;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkDataBase;

public abstract class SdkRefresherBase
extends AbstractSdkRefresher {
    private final Set<VirtualFile> e = ContainerUtil.newHashSet();
    private final AtomicNullableLazyValue<Path> d = AtomicNullableLazyValue.createValue(this::b);
    private static final long u = la.a(2760846951845171121L, -3005622360719960523L, MethodHandles.lookup().lookupClass()).a(272424769382289L);

    @Override
    public final boolean isManagedSdk(@Nullable Sdk sdk) {
        return RubyVersionManagerHandler.from(sdk) == this.getVersionManagerHandler() && !RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk);
    }

    @Override
    public final void onApplicationInit() {
        this.getInstallationsRoots().forEach(this::addRootToWatch);
        this.doAdditionalApplicationInit();
    }

    protected final synchronized void addRootToWatch(@NotNull VirtualFile root) {
        long l2 = u ^ 0x2E7B927DD50BL;
        if (root == null) {
            SdkRefresherBase.c(0);
        }
        if (this.e.add(root)) {
            this.myLog.debug("Setting watcher and listener to " + root);
            LocalFileSystem.getInstance().addRootToWatch(root.getPath(), false);
            LocalFileSystem.getInstance().addVirtualFileListener((VirtualFileListener)new SdkRootsListener(root));
        }
    }

    protected void doAdditionalApplicationInit() {
    }

    @NotNull
    protected Set<? extends RubySdkInfo> getSdkInfos() {
        long l2 = u ^ 0x7A4DC9BCFEC5L;
        Path path = this.getVersionManagerPath();
        if (path == null) {
            this.myLog.debug("Could not find version manager path");
            Set set = Collections.emptySet();
            if (set == null) {
                SdkRefresherBase.c(1);
            }
            return set;
        }
        this.myLog.debug("Found version manager in " + path);
        String string = path.toString();
        Set set = this.getInstallationsRoots().stream().flatMap(virtualFile -> {
            long l2 = u ^ 0x16C064F2A267L;
            this.myLog.debug("Looking for installations in: " + virtualFile);
            return Arrays.stream(virtualFile.getChildren());
        }).filter(virtualFile -> virtualFile.isDirectory()).flatMap(virtualFile -> this.getSdkInfosForInterpreterHome(string, (VirtualFile)virtualFile)).collect(Collectors.toSet());
        if (set == null) {
            SdkRefresherBase.c(2);
        }
        return set;
    }

    @NotNull
    protected Stream<? extends RubySdkInfo> getSdkInfosForInterpreterHome(@NotNull String versionManagerPathName, @NotNull VirtualFile interpreterHome) {
        if (versionManagerPathName == null) {
            SdkRefresherBase.c(3);
        }
        if (interpreterHome == null) {
            SdkRefresherBase.c(4);
        }
        Stream<RubySdkInfo> stream2 = Stream.of(new RubySdkInfo(versionManagerPathName, interpreterHome, null));
        if (stream2 == null) {
            SdkRefresherBase.c(5);
        }
        return stream2;
    }

    @Override
    public final void doRefreshSDKs() {
        long l2 = u ^ 0x50B14680189EL;
        this.myLog.debug("Refreshing sdks");
        Set<? extends RubySdkInfo> set = this.getSdkInfos();
        this.myLog.debug("Got " + set.size() + " sdk infos");
        List<? extends Sdk> list2 = SdkRefresherBase.a();
        this.myLog.debug("Got " + list2.size() + " ruby sdks");
        List list3 = ContainerUtil.filter(list2, this::isManagedSdk);
        this.myLog.debug("Got " + list3.size() + " sks managed by me");
        List list4 = ContainerUtil.filter(set, rubySdkInfo -> {
            boolean bl2;
            long l2 = u ^ 0x21A41241ABB9L;
            boolean bl3 = bl2 = rubySdkInfo != null && rubySdkInfo.getSdkType() != null && rubySdkInfo.getRubyExecutable() != null && this.a((RubySdkInfo)rubySdkInfo, (Collection<? extends Sdk>)list2);
            if (bl2) {
                this.myLog.debug("Should be created: " + rubySdkInfo);
            }
            return bl2;
        });
        this.myLog.debug(list4.size() + " sdks should be created");
        List list5 = ContainerUtil.filter((Collection)list3, sdk -> {
            long l2 = u ^ 0x64CF62C6FFAEL;
            assert (sdk != null);
            for (RubySdkInfo rubySdkInfo : set) {
                if (!this.a(rubySdkInfo, (Sdk)sdk)) continue;
                return false;
            }
            this.myLog.debug("Should be removed: " + sdk);
            return true;
        });
        this.myLog.debug(list5.size() + " sdks should be removed");
        this.a(list5);
        for (RubySdkInfo rubySdkInfo2 : list4) {
            RubySdkType rubySdkType = rubySdkInfo2.getSdkType();
            VirtualFile virtualFile = rubySdkInfo2.getRubyExecutable();
            assert (virtualFile != null);
            assert (rubySdkType != null);
            this.myLog.debug("Creating new sdk: " + virtualFile);
            rubySdkType.createAndAddLocalSdk(virtualFile, (RubyVersionManagerSdkData)this.getVersionManagerHandler().createAdditionalData(rubySdkInfo2));
            this.runPostCreateSdkAction(rubySdkInfo2);
        }
        this.cancelQueuedUpdates();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public abstract RubyVersionManagerHandlerBase getVersionManagerHandler();

    protected void runPostCreateSdkAction(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            SdkRefresherBase.c(6);
        }
    }

    private boolean a(@NotNull RubySdkInfo rubySdkInfo, @NotNull Collection<? extends Sdk> collection) {
        long l2 = u ^ 0x12B7F3EB93EAL;
        if (rubySdkInfo == null) {
            SdkRefresherBase.c(7);
        }
        if (collection == null) {
            SdkRefresherBase.c(8);
        }
        for (Sdk sdk : collection) {
            if (!this.a(rubySdkInfo, sdk)) continue;
            this.myLog.debug("Already exists: " + rubySdkInfo + " => " + sdk);
            return false;
        }
        return true;
    }

    private boolean a(@NotNull RubySdkInfo rubySdkInfo, @NotNull Sdk sdk) {
        if (rubySdkInfo == null) {
            SdkRefresherBase.c(9);
        }
        if (sdk == null) {
            SdkRefresherBase.c(10);
        }
        return sdk.getSdkType() == rubySdkInfo.getSdkType() && Comparing.equal((Object)sdk.getHomeDirectory(), (Object)rubySdkInfo.getRubyExecutable()) && this.equalsInVersionsFramework(rubySdkInfo, sdk);
    }

    protected boolean equalsInVersionsFramework(@NotNull RubySdkInfo info, @NotNull Sdk sdk) {
        if (info == null) {
            SdkRefresherBase.c(11);
        }
        if (sdk == null) {
            SdkRefresherBase.c(12);
        }
        RubyVersionManagerHandlerBase rubyVersionManagerHandlerBase = this.getVersionManagerHandler();
        return ((RubyVersionManagerSdkDataBase)rubyVersionManagerHandlerBase.createAdditionalData(info)).equals(RubyVersionManagerSdkData.from(sdk));
    }

    private void a(@NotNull Collection<? extends Sdk> collection) {
        if (collection == null) {
            SdkRefresherBase.c(13);
        }
        if (collection.isEmpty()) {
            return;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        WriteAction.runAndWait(() -> {
            if (collection == null) {
                SdkRefresherBase.c(20);
            }
            collection.forEach(sdk -> {
                long l2 = u ^ 0x1D30A9F557E2L;
                this.myLog.debug("Removing sdk: " + sdk.getName());
                projectJdkTable.removeJdk(sdk);
            });
        });
    }

    @NotNull
    private static List<? extends Sdk> a() {
        List list2 = ContainerUtil.filter((Object[])ProjectJdkTable.getInstance().getAllJdks(), RubySdkUtil::isRubySDK);
        if (list2 == null) {
            SdkRefresherBase.c(14);
        }
        return list2;
    }

    @Override
    @Nullable
    public String suggestSdkName(@NotNull String executablePath, @NotNull String sdkHomePath, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        RubyVersionManagerHandlerBase rubyVersionManagerHandlerBase;
        long l2 = u ^ 0x326BB0B700BCL;
        if (executablePath == null) {
            SdkRefresherBase.c(15);
        }
        if (sdkHomePath == null) {
            SdkRefresherBase.c(16);
        }
        if (versionManagerSdkAdditionalData == null) {
            SdkRefresherBase.c(17);
        }
        if ((rubyVersionManagerHandlerBase = this.getVersionManagerHandler()) != versionManagerSdkAdditionalData.getHandler()) {
            return null;
        }
        return ((RubyVersionManagerHandler)rubyVersionManagerHandlerBase).getId() + ": " + sdkHomePath;
    }

    protected boolean isEnabled() {
        return !ApplicationManager.getApplication().isHeadlessEnvironment() && !SystemInfo.isWindows;
    }

    @Nullable
    protected Path getVersionManagerPath() {
        if (!this.isEnabled()) {
            return null;
        }
        ArrayList arrayList = ContainerUtil.newArrayList();
        ContainerUtil.addIfNotNull((Collection)arrayList, (Object)this.getUserDefinedPath());
        arrayList.addAll(this.getVersionManagerPathsFromExistingSdks());
        arrayList.addAll(this.getPossibleVersionManagersPaths());
        ObjectUtils.doIfNotNull((Object)PathEnvironmentVariableUtil.findInPath((String)this.getVersionManagerHandler().getVersionManagerExecutableName()), file -> arrayList.add(file.getPath()));
        return arrayList.stream().map(string -> Paths.get(FileUtil.expandUserHome((String)string), new String[0])).filter(path -> Files.exists(path, new LinkOption[0])).findFirst().orElseGet(() -> this.d.getValue());
    }

    @Nullable
    private Path b() {
        long l2 = u ^ 0x5F21D540EDBBL;
        String string = this.getVersionManagerHandler().getVersionManagerExecutableName();
        String string2 = "\\which " + string;
        this.myLog.debug("Attempting to discover " + string + " with " + string2);
        try {
            List list2;
            ProcessOutput processOutput = RubyLocalRunner.getRunner(null).execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create("bash", "-lc", string2).inSameThread(30, RBundle.message((String)"version.manager.seeking.version.manager", (Object[])new Object[]{string})));
            if (processOutput == null) {
                return null;
            }
            if (this.myLog.isDebugEnabled()) {
                this.myLog.debug("Got which output: ");
                this.myLog.debug("  stdout: " + processOutput.getStdout());
                this.myLog.debug("  stderr: " + processOutput.getStderr());
                this.myLog.debug("  exit code: " + processOutput.getExitCode());
            }
            Path path = (list2 = processOutput.getStdoutLines()).isEmpty() ? null : Paths.get((String)list2.get(0), new String[0]);
            this.myLog.debug("Found " + path);
            return path;
        }
        catch (ExecutionException executionException) {
            this.myLog.warn("Error executing bash -lc " + string2, (Throwable)executionException);
            return null;
        }
    }

    @NotNull
    protected abstract List<String> getPossibleVersionManagersPaths();

    @NotNull
    protected final List<VirtualFile> getInstallationsRoots() {
        List<VirtualFile> list2 = this.getInstallationsRootsPathNames().stream().map(string -> VfsUtil.findFileByIoFile((File)new File(FileUtil.expandUserHome((String)string)), (boolean)false)).filter(virtualFile -> virtualFile != null && virtualFile.exists() && virtualFile.isDirectory()).distinct().collect(Collectors.toList());
        if (list2 == null) {
            SdkRefresherBase.c(18);
        }
        return list2;
    }

    @NotNull
    protected List<String> getInstallationsRootsPathNames() {
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            SdkRefresherBase.c(19);
        }
        return list2;
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = u ^ 0x3514D1ABC3C4L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 14: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 14: 
            case 18: 
            case 19: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/SdkRefresherBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPathName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterHome";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registeredSdks";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/SdkRefresherBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfos";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredRubySdks";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallationsRoots";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallationsRootsPathNames";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRootToWatch";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runPostCreateSdkAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canBeRegistered";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalsInVersionsFramework";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpSDKs";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$cleanUpSDKs$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 14: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SdkRootsListener
    implements VirtualFileListener {
        @NotNull
        private final VirtualFile a;
        private static final long b = la.a(3695776328417394241L, 474307351401484263L, MethodHandles.lookup().lookupClass()).a(226240439383278L);

        SdkRootsListener(VirtualFile root) {
            if (root == null) {
                SdkRootsListener.a(0);
            }
            this.a = root;
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                SdkRootsListener.a(1);
            }
            this.a(event);
        }

        private void a(VirtualFileEvent virtualFileEvent) {
            VirtualFile virtualFile = virtualFileEvent.getFile();
            if (this.a.equals(virtualFile.getParent())) {
                SdkRefresherBase.this.refreshAsynchronously();
            }
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                SdkRootsListener.a(2);
            }
            this.a(event);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x5276F1DA5A0BL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/SdkRefresherBase$SdkRootsListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

