/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient;

import java.io.File;
import org.netbeans.lib.cvsclient.CvsRoot;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.ICvsRootProvider;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.admin.IAdminWriter;
import org.netbeans.lib.cvsclient.connection.IConnection;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.CvsFileSystem;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.file.IFileReadOnlyHandler;
import org.netbeans.lib.cvsclient.file.ILocalFileReader;
import org.netbeans.lib.cvsclient.file.ILocalFileWriter;
import org.netbeans.lib.cvsclient.util.BugLog;
import org.netbeans.lib.cvsclient.util.IIgnoreFileFilter;

public final class ClientEnvironment
implements IClientEnvironment {
    private final IConnection connection;
    private final CvsRoot cvsRoot;
    private final ICvsFileSystem cvsFileSystem;
    private final ILocalFileReader localFileReader;
    private final ILocalFileWriter localFileWriter;
    private final IAdminReader adminReader;
    private final IAdminWriter adminWriter;
    private final IIgnoreFileFilter ignoreFileFilter;
    private final IFileReadOnlyHandler fileReadOnlyHandler;
    private final String charset;
    private final ICvsRootProvider cvsRootProvider;

    public ClientEnvironment(IConnection connection, File localRootDirectory, File adminRootDirectory, CvsRoot cvsRoot, ILocalFileReader localFileReader, ILocalFileWriter localFileWriter, IAdminReader adminReader, IAdminWriter adminWriter, IIgnoreFileFilter ignoreFileFilter, IFileReadOnlyHandler fileReadOnlyHandler, String charset) {
        this(connection, localRootDirectory, adminRootDirectory, cvsRoot, localFileReader, localFileWriter, adminReader, adminWriter, ignoreFileFilter, fileReadOnlyHandler, charset, ICvsRootProvider.DUMMY);
    }

    public ClientEnvironment(IConnection connection, File localRootDirectory, File adminRootDirectory, CvsRoot cvsRoot, ILocalFileReader localFileReader, ILocalFileWriter localFileWriter, IAdminReader adminReader, IAdminWriter adminWriter, IIgnoreFileFilter ignoreFileFilter, IFileReadOnlyHandler fileReadOnlyHandler, String charset, ICvsRootProvider cvsRootProvider) {
        BugLog.getInstance().assertNotNull((Object)connection);
        BugLog.getInstance().assertNotNull((Object)localRootDirectory);
        BugLog.getInstance().assertNotNull((Object)adminRootDirectory);
        BugLog.getInstance().assertNotNull((Object)cvsRoot);
        BugLog.getInstance().assertNotNull((Object)localFileReader);
        BugLog.getInstance().assertNotNull((Object)localFileWriter);
        BugLog.getInstance().assertNotNull((Object)adminReader);
        BugLog.getInstance().assertNotNull((Object)adminWriter);
        BugLog.getInstance().assertNotNull((Object)ignoreFileFilter);
        BugLog.getInstance().assertNotNull((Object)fileReadOnlyHandler);
        BugLog.getInstance().assertNotNull((Object)cvsRootProvider);
        this.connection = connection;
        this.cvsRoot = cvsRoot;
        this.cvsFileSystem = new CvsFileSystem(localRootDirectory, adminRootDirectory, connection.getRepository());
        this.localFileReader = localFileReader;
        this.localFileWriter = localFileWriter;
        this.adminReader = adminReader;
        this.adminWriter = adminWriter;
        this.ignoreFileFilter = ignoreFileFilter;
        this.fileReadOnlyHandler = fileReadOnlyHandler;
        this.charset = charset;
        this.cvsRootProvider = cvsRootProvider;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public ICvsFileSystem getCvsFileSystem() {
        return this.cvsFileSystem;
    }

    public CvsRoot getCvsRoot() {
        return this.cvsRoot;
    }

    public IAdminReader getAdminReader() {
        return this.adminReader;
    }

    public IAdminWriter getAdminWriter() {
        return this.adminWriter;
    }

    public ILocalFileReader getLocalFileReader() {
        return this.localFileReader;
    }

    public ILocalFileWriter getLocalFileWriter() {
        return this.localFileWriter;
    }

    public IIgnoreFileFilter getIgnoreFileFilter() {
        return this.ignoreFileFilter;
    }

    public IFileReadOnlyHandler getFileReadOnlyHandler() {
        return this.fileReadOnlyHandler;
    }

    public String getCharset() {
        return this.charset;
    }

    public IClientEnvironment createEnvironmentForDirectory(DirectoryObject directory) {
        IConnection connection = this.cvsRootProvider.getConnection(directory, this.cvsFileSystem);
        if (connection == null) {
            return null;
        }
        CvsRoot cvsRoot = this.cvsRootProvider.getCvsRoot(directory, this.cvsFileSystem);
        if (cvsRoot == null) {
            return null;
        }
        return new ClientEnvironment(connection, this.cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)directory), this.cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directory), cvsRoot, this.getLocalFileReader(), this.getLocalFileWriter(), this.getAdminReader(), this.getAdminWriter(), this.getIgnoreFileFilter(), this.getFileReadOnlyHandler(), this.getCharset(), this.cvsRootProvider);
    }
}

