/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.rails;

import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.diagram.rails.associations.AssociationProperty;
import com.intellij.diagram.rails.associations.MigrationFiledType;
import icons.RubyIcons;
import org.jetbrains.plugins.ruby.rails.RailsIcons;

public class RailUmlCategoryManager
implements DiagramNodeContentManager {
    public static final DiagramCategory ASSOCIATION_FIELDS = new DiagramCategory("Association fields", RubyIcons.Rails.ProjectView.AssocColumn, true);
    public static final DiagramCategory MIGRATION_FIELDS = new DiagramCategory("Migration fields", RailsIcons.EXPLICIT_ICON_DB_FIELD, true);
    public static final DiagramCategory DB_FIELDS = new DiagramCategory("System DB fields", RubyIcons.Rails.ProjectView.SystemDbField);
    public static final DiagramCategory OWN_FIELDS = new DiagramCategory("Own fields", RubyIcons.Ruby.Nodes.Variable);
    private static final DiagramCategory[] CATEGORIES = new DiagramCategory[]{ASSOCIATION_FIELDS, MIGRATION_FIELDS, DB_FIELDS, OWN_FIELDS};

    public DiagramCategory[] getContentCategories() {
        return CATEGORIES;
    }

    public boolean isInCategory(Object element, DiagramCategory category, DiagramState presentation) {
        if (element instanceof AssociationProperty) {
            AssociationProperty associationProperty = (AssociationProperty)element;
            MigrationFiledType migrationFiledType = associationProperty.getMigrationFiledType();
            if (ASSOCIATION_FIELDS.equals((Object)category)) {
                return migrationFiledType == MigrationFiledType.ASSOCIATION;
            }
            if (MIGRATION_FIELDS.equals((Object)category)) {
                return migrationFiledType == MigrationFiledType.MIGRATION;
            }
            if (DB_FIELDS.equals((Object)category)) {
                return migrationFiledType == MigrationFiledType.SYSTEM_DB;
            }
        }
        return false;
    }
}

