/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GeneralVariable;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceType;

public class XSLGlobalVariable
extends XSLGeneralVariable
implements StylesheetProcedure {
    SlotManager slotManager;
    private int state = 0;
    protected boolean redundant = false;

    public XSLGlobalVariable() {
        this.sourceBinding.setProperty(2, true);
    }

    protected int getPermittedAttributes() {
        return 2496;
    }

    public SourceBinding getBindingInformation(StructuredQName name) {
        if (name.equals(this.sourceBinding.getVariableQName())) {
            return this.sourceBinding;
        }
        return null;
    }

    public void prepareAttributes() throws XPathException {
        if (this.state == 2) {
            return;
        }
        if (this.state == 1) {
            this.compileError("Circular reference to variable", "XTDE0640");
        }
        this.state = 1;
        this.sourceBinding.prepareAttributes(this.getPermittedAttributes());
        this.state = 2;
    }

    protected void index(Declaration decl, PrincipalStylesheetModule top) throws XPathException {
        top.indexVariableDeclaration(decl);
    }

    public void validate(Declaration decl) throws XPathException {
        this.slotManager = this.getConfiguration().makeSlotManager();
        super.validate(decl);
    }

    public boolean isAssignable() {
        return this.sourceBinding.hasProperty(64);
    }

    public boolean isDeclaration() {
        return true;
    }

    public boolean isInstruction() {
        return false;
    }

    public SequenceType getRequiredType() {
        return this.sourceBinding.getInferredType(true);
    }

    public void fixupReferences() throws XPathException {
        this.sourceBinding.fixupReferences();
        super.fixupReferences();
    }

    public void compileDeclaration(Executable exec, Declaration decl) throws XPathException {
        if (this.sourceBinding.getReferences().isEmpty() && !this.isAssignable()) {
            this.redundant = true;
        }
        if (!this.redundant) {
            this.sourceBinding.handleSequenceConstructor(exec, decl);
            GlobalVariable inst = new GlobalVariable();
            inst.setExecutable(exec);
            Expression select = this.sourceBinding.getSelectExpression();
            inst.setSelectExpression(select);
            if (select != null) {
                select.setContainer(inst);
            }
            inst.setVariableQName(this.sourceBinding.getVariableQName());
            this.initializeBinding(exec, decl, inst);
            inst.setAssignable(this.isAssignable());
            int slot = exec.getGlobalVariableMap().allocateSlotNumber(this.sourceBinding.getVariableQName());
            inst.setSlotNumber(slot);
            inst.setRequiredType(this.getRequiredType());
            this.sourceBinding.fixupBinding(inst);
            inst.setContainer(inst);
            this.compiledVariable = inst;
        }
    }

    protected void initializeBinding(Executable exec, Declaration decl, GeneralVariable var) throws XPathException {
        Expression select = var.getSelectExpression();
        GlobalVariable gvar = (GlobalVariable)var;
        var.setContainer(gvar);
        Expression exp2 = select;
        if (exp2 != null) {
            try {
                ExpressionVisitor visitor = this.makeExpressionVisitor();
                exp2.setContainer(gvar);
                exp2 = visitor.typeCheck(visitor.simplify(select), new ExpressionVisitor.ContextItemType(Type.ITEM_TYPE, true));
            }
            catch (XPathException err) {
                this.compileError(err);
            }
            exp2 = XSLGlobalVariable.makeTraceInstruction(this, exp2);
            this.allocateSlots(exp2);
        }
        if (this.slotManager != null && this.slotManager.getNumberOfVariables() > 0) {
            gvar.setContainsLocals(this.slotManager);
        }
        exec.registerGlobalVariable(gvar);
        this.setReferenceCount(gvar);
        if (exp2 != select) {
            gvar.setSelectExpression(exp2);
        }
    }

    public SlotManager getSlotManager() {
        return this.slotManager;
    }

    public void optimize(Declaration declaration) throws XPathException {
        if (!this.redundant && this.sourceBinding.getSelectExpression() != null) {
            Expression exp2 = this.sourceBinding.getSelectExpression();
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            Optimizer opt = this.getConfiguration().obtainOptimizer();
            try {
                if (opt.getOptimizationLevel() != 0) {
                    ExpressionTool.resetPropertiesWithinSubtree(exp2);
                    exp2 = exp2.optimize(visitor, new ExpressionVisitor.ContextItemType(AnyNodeTest.getInstance(), true));
                }
            }
            catch (XPathException err) {
                err.maybeSetLocation(this);
                this.compileError(err);
            }
            this.allocateSlots(exp2);
            if (this.slotManager != null && this.slotManager.getNumberOfVariables() > 0) {
                ((GlobalVariable)this.compiledVariable).setContainsLocals(this.slotManager);
            }
            if (exp2 != this.sourceBinding.getSelectExpression()) {
                this.compiledVariable.setSelectExpression(exp2);
            }
        }
    }

    public void setRedundant(boolean redundant) {
        this.redundant = redundant;
    }
}

