/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.fw.gui.MultipleLineLabel;
import net.sourceforge.squirrel_sql.fw.util.ProxySettings;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

final class ProxyPreferenceTabComponent
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ProxyPreferenceTabComponent.class);
    private static final long serialVersionUID = 1L;
    private JCheckBox _httpUseProxyChk = new JCheckBox(s_stringMgr.getString("ProxyPreferencesPanel.useproxy"));
    private JLabel _httpProxyServerLabel = new JLabel(s_stringMgr.getString("ProxyPreferencesPanel.server"), 4);
    private JTextField _httpProxyServer = new JTextField();
    private JLabel _httpProxyPortLabel = new JLabel(s_stringMgr.getString("ProxyPreferencesPanel.port"), 4);
    private JTextField _httpProxyPort = new JTextField();
    private JLabel _httpProxyUserLabel = new JLabel(s_stringMgr.getString("ProxyPreferencesPanel.user"), 4);
    private JTextField _httpProxyUser = new JTextField();
    private JLabel _httpProxyPasswordLabel = new JLabel(s_stringMgr.getString("ProxyPreferencesPanel.password"), 4);
    private JPasswordField _httpProxyPassword = new JPasswordField();
    private JLabel _httpNonProxyHostsLabel = new JLabel(s_stringMgr.getString("ProxyPreferencesPanel.noproxyfor"), 4);
    private JTextField _httpNonProxyHosts = new JTextField();
    private JCheckBox _socksUseProxyChk = new JCheckBox(s_stringMgr.getString("ProxyPreferencesPanel.useproxy"));
    private JLabel _socksProxyServerLabel = new JLabel(s_stringMgr.getString("ProxyPreferencesPanel.server"), 4);
    private JTextField _socksProxyServer = new JTextField();
    private JLabel _socksProxyPortLabel = new JLabel(s_stringMgr.getString("ProxyPreferencesPanel.port"), 4);
    private JTextField _socksProxyPort = new JTextField();

    ProxyPreferenceTabComponent() {
        super(new GridBagLayout());
        this.createUserInterface();
    }

    void loadData(IApplication app, SquirrelPreferences prefs) {
        ProxySettings proxySettings = prefs.getProxySettings();
        this._httpUseProxyChk.setSelected(proxySettings.getHttpUseProxy());
        this._httpProxyServer.setText(proxySettings.getHttpProxyServer());
        this._httpProxyPort.setText(proxySettings.getHttpProxyPort());
        this._httpNonProxyHosts.setText(proxySettings.getHttpNonProxyHosts());
        this._httpProxyUser.setText(proxySettings.getHttpProxyUser());
        this._httpProxyPassword.setText(proxySettings.getHttpProxyPassword());
        this._socksUseProxyChk.setSelected(proxySettings.getSocksUseProxy());
        this._socksProxyServer.setText(proxySettings.getSocksProxyServer());
        this._socksProxyPort.setText(proxySettings.getSocksProxyPort());
        this.updateControlStatus();
    }

    void applyChanges(SquirrelPreferences prefs) {
        ProxySettings proxySettings = new ProxySettings();
        proxySettings.setHttpUseProxy(this._httpUseProxyChk.isSelected());
        proxySettings.setHttpProxyServer(this._httpProxyServer.getText());
        proxySettings.setHttpProxyPort(this._httpProxyPort.getText());
        proxySettings.setHttpNonProxyHosts(this._httpNonProxyHosts.getText());
        proxySettings.setHttpProxyUser(this._httpProxyUser.getText());
        String password = new String(this._httpProxyPassword.getPassword());
        proxySettings.setHttpProxyPassword(password);
        proxySettings.setSocksUseProxy(this._socksUseProxyChk.isSelected());
        proxySettings.setSocksProxyServer(this._socksProxyServer.getText());
        proxySettings.setSocksProxyPort(this._socksProxyPort.getText());
        prefs.setProxySettings(proxySettings);
    }

    private void updateControlStatus() {
        boolean http = this._httpUseProxyChk.isSelected();
        this._httpProxyServerLabel.setEnabled(http);
        this._httpProxyServer.setEnabled(http);
        this._httpProxyPortLabel.setEnabled(http);
        this._httpProxyPort.setEnabled(http);
        this._httpNonProxyHostsLabel.setEnabled(http);
        this._httpNonProxyHosts.setEnabled(http);
        this._httpProxyUserLabel.setEnabled(http);
        this._httpProxyUser.setEnabled(http);
        this._httpProxyPasswordLabel.setEnabled(http);
        this._httpProxyPassword.setEnabled(http);
        boolean socks = this._socksUseProxyChk.isSelected();
        this._socksProxyServerLabel.setEnabled(socks);
        this._socksProxyServer.setEnabled(socks);
        this._socksProxyPortLabel.setEnabled(socks);
        this._socksProxyPort.setEnabled(socks);
    }

    private void createUserInterface() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.createHTTPPanel(), gbc);
        ++gbc.gridy;
        this.add((Component)this.createSOCKSPanel(), gbc);
        MyActionHandler lis = new MyActionHandler();
        this._httpUseProxyChk.addActionListener(lis);
        this._socksUseProxyChk.addActionListener(lis);
    }

    private JPanel createHTTPPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("ProxyPreferencesPanel.httpproxy")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)this._httpUseProxyChk, gbc);
        gbc.fill = 2;
        ++gbc.gridx;
        pnl.add((Component)this._httpProxyServerLabel, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._httpProxyPortLabel, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._httpProxyUserLabel, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._httpProxyPasswordLabel, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._httpNonProxyHostsLabel, gbc);
        ++gbc.gridy;
        --gbc.gridx;
        gbc.gridwidth = 0;
        pnl.add((Component)new MultipleLineLabel(s_stringMgr.getString("ProxyPreferencesPane.notes")), gbc);
        gbc.gridwidth = 1;
        ++gbc.gridx;
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        pnl.add((Component)this._httpProxyServer, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._httpProxyPort, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._httpProxyUser, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._httpProxyPassword, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._httpNonProxyHosts, gbc);
        return pnl;
    }

    private JPanel createSOCKSPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(s_stringMgr.getString("ProxyPreferencesPanel.socksproxy")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnl.add((Component)this._socksUseProxyChk, gbc);
        gbc.fill = 2;
        ++gbc.gridx;
        pnl.add((Component)this._socksProxyServerLabel, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._socksProxyPortLabel, gbc);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        pnl.add((Component)this._socksProxyServer, gbc);
        ++gbc.gridy;
        pnl.add((Component)this._socksProxyPort, gbc);
        return pnl;
    }

    private final class MyActionHandler
    implements ActionListener {
        private MyActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ProxyPreferenceTabComponent.this.updateControlStatus();
        }
    }
}

