/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.DumpSessionCommand;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.util.FileExtensionFilter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DumpSessionAction
extends SquirrelAction
implements ISessionAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DumpSessionAction.class);
    private static final ILogger s_log = LoggerController.createLogger(DumpSessionAction.class);
    private ISession _session;

    public DumpSessionAction(IApplication app) {
        super(app);
    }

    @Override
    public void setSession(ISession session) {
        this._session = session;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Frame parentFrame = this.getParentFrame(evt);
        FileExtensionFilter[] filters = new FileExtensionFilter[]{new FileExtensionFilter("Text files", new String[]{".txt"})};
        String label = s_stringMgr.getString("DumpSessionAction.warning");
        JLabel lbl = new JLabel(label);
        lbl.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        File outFile = Dialogs.selectFileForWriting(parentFrame, filters, lbl);
        if (outFile != null) {
            DumpSessionCommand cmd = new DumpSessionCommand(outFile);
            cmd.setSession(this._session);
            try {
                cmd.execute();
                String msg = s_stringMgr.getString("DumpSessionAction.success", outFile.getAbsolutePath());
                this._session.showMessage(msg);
            }
            catch (Throwable ex) {
                String msg = s_stringMgr.getString("DumpSessionAction.error", ex);
                this._session.showErrorMessage(msg);
                s_log.error(msg, ex);
            }
        }
    }
}

