/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispInteger;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SimpleVector;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class ComplexVector_IntBuffer
extends AbstractVector {
    private int capacity;
    private int fillPointer = -1;
    private boolean isDisplaced;
    private IntBuffer elements;
    private boolean directAllocation;
    private AbstractArray array;
    private int displacement;

    public ComplexVector_IntBuffer(int capacity) {
        this(capacity, false);
    }

    public ComplexVector_IntBuffer(int capacity, boolean directAllocation) {
        this.capacity = capacity;
        this.directAllocation = directAllocation;
        if (directAllocation) {
            ByteBuffer b = ByteBuffer.allocateDirect(capacity * 4);
            this.elements = b.asIntBuffer();
        } else {
            this.elements = IntBuffer.allocate(capacity);
        }
    }

    public ComplexVector_IntBuffer(int capacity, AbstractArray array, int displacement) {
        this(capacity, array, displacement, false);
    }

    public ComplexVector_IntBuffer(int capacity, AbstractArray array, int displacement, boolean directAllocation) {
        this.capacity = capacity;
        this.array = array;
        this.displacement = displacement;
        this.directAllocation = directAllocation;
        this.isDisplaced = true;
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.VECTOR, Lisp.UNSIGNED_BYTE_32, Fixnum.getInstance(this.capacity));
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.VECTOR;
    }

    @Override
    public boolean hasFillPointer() {
        return this.fillPointer >= 0;
    }

    @Override
    public int getFillPointer() {
        return this.fillPointer;
    }

    @Override
    public void setFillPointer(int n) {
        this.fillPointer = n;
    }

    @Override
    public void setFillPointer(LispObject obj) {
        if (obj == Lisp.T) {
            this.fillPointer = this.capacity();
        } else {
            int n = Fixnum.getValue(obj);
            if (n > this.capacity()) {
                StringBuffer sb = new StringBuffer("The new fill pointer (");
                sb.append(n);
                sb.append(") exceeds the capacity of the vector (");
                sb.append(this.capacity());
                sb.append(").");
                Lisp.error(new LispError(sb.toString()));
            } else if (n < 0) {
                StringBuffer sb = new StringBuffer("The new fill pointer (");
                sb.append(n);
                sb.append(") is negative.");
                Lisp.error(new LispError(sb.toString()));
            } else {
                this.fillPointer = n;
            }
        }
    }

    @Override
    public boolean isDisplaced() {
        return this.isDisplaced;
    }

    @Override
    public LispObject arrayDisplacement() {
        Fixnum value2;
        LispObject value1;
        if (this.array != null) {
            value1 = this.array;
            value2 = Fixnum.getInstance(this.displacement);
        } else {
            value1 = Lisp.NIL;
            value2 = Fixnum.ZERO;
        }
        return LispThread.currentThread().setValues(value1, value2);
    }

    @Override
    public LispObject getElementType() {
        return Lisp.UNSIGNED_BYTE_32;
    }

    @Override
    public boolean isSimpleVector() {
        return false;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int length() {
        return this.fillPointer >= 0 ? this.fillPointer : this.capacity;
    }

    @Override
    public LispObject elt(int index) {
        int limit = this.length();
        if (index < 0 || index >= limit) {
            this.badIndex(index, limit);
        }
        return this.AREF(index);
    }

    @Override
    public LispObject AREF(int index) {
        if (this.elements != null) {
            try {
                return Lisp.number((long)this.elements.get(index) & 0xFFFFFFFFL);
            }
            catch (IndexOutOfBoundsException e) {
                this.badIndex(index, this.elements.limit());
                return Lisp.NIL;
            }
        }
        if (index < 0 || index >= this.capacity) {
            this.badIndex(index, this.capacity);
        }
        return this.array.AREF(index + this.displacement);
    }

    @Override
    public void aset(int index, LispObject newValue) {
        if (newValue.isLessThan(Fixnum.ZERO) || newValue.isGreaterThan(Lisp.UNSIGNED_BYTE_32_MAX_VALUE)) {
            Lisp.type_error(newValue, Lisp.UNSIGNED_BYTE_32);
        }
        if (this.elements != null) {
            try {
                this.elements.put(index, (int)(newValue.longValue() & 0xFFFFFFFFL));
            }
            catch (IndexOutOfBoundsException e) {
                this.badIndex(index, this.elements.limit());
            }
        } else if (index < 0 || index >= this.capacity) {
            this.badIndex(index, this.capacity);
        } else {
            this.array.aset(index + this.displacement, newValue);
        }
    }

    @Override
    public LispObject subseq(int start, int end) {
        SimpleVector v = new SimpleVector(end - start);
        int i = start;
        int j = 0;
        try {
            while (i < end) {
                v.aset(j++, this.AREF(i++));
            }
            return v;
        }
        catch (IndexOutOfBoundsException e) {
            return Lisp.error(new TypeError("Array index out of bounds: " + i + "."));
        }
    }

    @Override
    public void fill(LispObject obj) {
        if (!(obj instanceof LispInteger)) {
            Lisp.type_error(obj, Symbol.INTEGER);
            return;
        }
        if (obj.isLessThan(Fixnum.ZERO) || obj.isGreaterThan(Lisp.UNSIGNED_BYTE_32_MAX_VALUE)) {
            Lisp.type_error(obj, Lisp.UNSIGNED_BYTE_32);
        }
        int i = this.capacity;
        while (i-- > 0) {
            this.elements.put(i, Lisp.coerceToJavaUnsignedInt(obj));
        }
    }

    @Override
    public void shrink(int n) {
        if (n < this.length()) {
            ((Buffer)this.elements).limit(n);
            this.capacity = n;
            return;
        }
        if (n == this.elements.limit()) {
            return;
        }
        Lisp.error(new LispError());
    }

    @Override
    public LispObject reverse() {
        int length = this.length();
        SimpleVector result = new SimpleVector(length);
        int i = 0;
        int j = length - 1;
        while (i < length) {
            result.aset(i, this.AREF(j));
            ++i;
            --j;
        }
        return result;
    }

    @Override
    public LispObject nreverse() {
        if (this.elements != null) {
            int i = 0;
            for (int j = this.length() - 1; i < j; ++i, --j) {
                int temp = this.elements.get(i);
                this.elements.put(i, this.elements.get(j));
                this.elements.put(j, temp);
            }
        } else {
            int length = this.length();
            IntBuffer data = null;
            if (this.directAllocation) {
                ByteBuffer b = ByteBuffer.allocateDirect(length * 4);
                data = b.asIntBuffer();
            } else {
                data = IntBuffer.allocate(length);
            }
            int i = 0;
            int j = length - 1;
            while (i < length) {
                data.put(i, Lisp.coerceToJavaUnsignedInt(this.AREF(j)));
                ++i;
                --j;
            }
            this.elements = data;
            this.capacity = length;
            this.array = null;
            this.displacement = 0;
            this.isDisplaced = false;
            this.fillPointer = -1;
        }
        return this;
    }

    @Override
    public void vectorPushExtend(LispObject element) {
        if (this.fillPointer < 0) {
            this.noFillPointer();
        }
        if (this.fillPointer >= this.capacity) {
            this.ensureCapacity(this.capacity * 2 + 1);
        }
        this.aset(this.fillPointer, element);
        ++this.fillPointer;
    }

    @Override
    public LispObject VECTOR_PUSH_EXTEND(LispObject element) {
        this.vectorPushExtend(element);
        return Fixnum.getInstance(this.fillPointer - 1);
    }

    @Override
    public LispObject VECTOR_PUSH_EXTEND(LispObject element, LispObject extension) {
        int ext = Fixnum.getValue(extension);
        if (this.fillPointer < 0) {
            this.noFillPointer();
        }
        if (this.fillPointer >= this.capacity) {
            ext = Math.max(ext, this.capacity + 1);
            this.ensureCapacity(this.capacity + ext);
        }
        this.aset(this.fillPointer, element);
        return Fixnum.getInstance(this.fillPointer++);
    }

    private final void ensureCapacity(int minCapacity) {
        if (this.elements != null) {
            if (this.capacity < minCapacity) {
                IntBuffer newBuffer = null;
                if (this.directAllocation) {
                    ByteBuffer b = ByteBuffer.allocateDirect(minCapacity * 4);
                    newBuffer = b.asIntBuffer();
                } else {
                    newBuffer = IntBuffer.allocate(minCapacity);
                }
                this.elements.position(0);
                newBuffer.put(this.elements);
                newBuffer.position(0);
                this.elements = newBuffer;
                this.capacity = minCapacity;
            }
        } else {
            Debug.assertTrue(this.array != null);
            if (this.capacity < minCapacity || this.array.getTotalSize() - this.displacement < minCapacity) {
                if (this.directAllocation) {
                    ByteBuffer b = ByteBuffer.allocateDirect(minCapacity * 4);
                    this.elements = b.asIntBuffer();
                } else {
                    this.elements = IntBuffer.allocate(minCapacity);
                }
                int limit = Math.min(this.capacity, this.array.getTotalSize() - this.displacement);
                for (int i = 0; i < limit; ++i) {
                    this.elements.put(i, Lisp.coerceToJavaUnsignedInt(this.AREF(this.displacement + i)));
                }
                this.capacity = minCapacity;
                this.array = null;
                this.displacement = 0;
                this.isDisplaced = false;
            }
        }
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            IntBuffer newElements = null;
            if (this.directAllocation) {
                ByteBuffer b = ByteBuffer.allocateDirect(newCapacity * 4);
                newElements = b.asIntBuffer();
            } else {
                newElements = IntBuffer.allocate(newCapacity);
            }
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    newElements.put(i, Lisp.coerceToJavaUnsignedInt(list.car()));
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    newElements.put(i, Lisp.coerceToJavaUnsignedInt(initialContents.elt(i)));
                }
            } else {
                Lisp.type_error(initialContents, Symbol.SEQUENCE);
            }
            this.elements = newElements;
        } else {
            if (this.elements == null) {
                if (this.directAllocation) {
                    ByteBuffer b = ByteBuffer.allocateDirect(newCapacity * 4);
                    this.elements = b.asIntBuffer();
                } else {
                    this.elements = IntBuffer.allocate(newCapacity);
                }
                int limit = Math.min(this.capacity, newCapacity);
                for (int i = 0; i < limit; ++i) {
                    this.elements.put(i, (int)(this.array.AREF(this.displacement + i).longValue() & 0xFFFFFFFFL));
                }
            } else if (this.capacity != newCapacity) {
                IntBuffer newElements = null;
                if (this.directAllocation) {
                    ByteBuffer b = ByteBuffer.allocateDirect(newCapacity * 4);
                    newElements = b.asIntBuffer();
                } else {
                    newElements = IntBuffer.allocate(newCapacity);
                }
                newElements.put(this.elements.array(), 0, Math.min(this.capacity, newCapacity));
                newElements.position(0);
                this.elements = newElements;
            }
            if (initialElement != null) {
                for (int i = this.capacity; i < newCapacity; ++i) {
                    this.elements.put(i, Lisp.coerceToJavaUnsignedInt(initialElement));
                }
            }
        }
        this.capacity = newCapacity;
        this.array = null;
        this.displacement = 0;
        this.isDisplaced = false;
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        this.capacity = newCapacity;
        this.array = displacedTo;
        this.displacement = displacement;
        this.elements = null;
        this.isDisplaced = true;
        return this;
    }
}

