/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.modeler.Registry;

public class HostConfig
implements LifecycleListener {
    protected static Log log = LogFactory.getLog(HostConfig.class);
    protected File appBase = null;
    protected File configBase = null;
    protected String configClass = "org.apache.catalina.startup.ContextConfig";
    protected String contextClass = "org.apache.catalina.core.StandardContext";
    protected Host host = null;
    protected ObjectName oname = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected boolean deployXML = false;
    protected boolean unpackWARs = false;
    protected HashMap<String, DeployedApplication> deployed = new HashMap();
    protected ArrayList<String> serviced = new ArrayList();
    protected boolean xmlValidation = false;
    protected boolean xmlNamespaceAware = false;
    protected static Digester digester = HostConfig.createDigester();
    protected Set<String> invalidWars = new HashSet<String>();

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String configClass) {
        this.configClass = configClass;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String contextClass) {
        this.contextClass = contextClass;
    }

    public boolean isDeployXML() {
        return this.deployXML;
    }

    public void setDeployXML(boolean deployXML) {
        this.deployXML = deployXML;
    }

    public boolean isUnpackWARs() {
        return this.unpackWARs;
    }

    public void setUnpackWARs(boolean unpackWARs) {
        this.unpackWARs = unpackWARs;
    }

    public void setXmlValidation(boolean xmlValidation) {
        this.xmlValidation = xmlValidation;
    }

    public boolean getXmlValidation() {
        return this.xmlValidation;
    }

    public boolean getXmlNamespaceAware() {
        return this.xmlNamespaceAware;
    }

    public void setXmlNamespaceAware(boolean xmlNamespaceAware) {
        this.xmlNamespaceAware = xmlNamespaceAware;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType().equals("periodic")) {
            this.check();
        }
        try {
            this.host = (Host)((Object)event.getLifecycle());
            if (this.host instanceof StandardHost) {
                this.setDeployXML(((StandardHost)this.host).isDeployXML());
                this.setUnpackWARs(((StandardHost)this.host).isUnpackWARs());
                this.setXmlNamespaceAware(((StandardHost)this.host).getXmlNamespaceAware());
                this.setXmlValidation(((StandardHost)this.host).getXmlValidation());
            }
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("hostConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("start")) {
            this.start();
        } else if (event.getType().equals("stop")) {
            this.stop();
        }
    }

    public synchronized void addServiced(String name) {
        this.serviced.add(name);
    }

    public synchronized boolean isServiced(String name) {
        return this.serviced.contains(name);
    }

    public synchronized void removeServiced(String name) {
        this.serviced.remove(name);
    }

    public long getDeploymentTime(String name) {
        DeployedApplication app = this.deployed.get(name);
        if (app == null) {
            return 0L;
        }
        return app.timestamp;
    }

    public boolean isDeployed(String name) {
        DeployedApplication app = this.deployed.get(name);
        return app != null;
    }

    protected static Digester createDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("Context", "org.apache.catalina.core.StandardContext", "className");
        digester.addSetProperties("Context");
        return digester;
    }

    protected File appBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            this.appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.appBase = file;
        }
        return this.appBase;
    }

    protected File configBase() {
        if (this.configBase != null) {
            return this.configBase;
        }
        File file = new File(System.getProperty("catalina.base"), "conf");
        Container parent = this.host.getParent();
        if (parent != null && parent instanceof Engine) {
            file = new File(file, parent.getName());
        }
        file = new File(file, this.host.getName());
        try {
            this.configBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.configBase = file;
        }
        return this.configBase;
    }

    public String getConfigBaseName() {
        return this.configBase().getAbsolutePath();
    }

    protected String getConfigFile(String path) {
        String basename = null;
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename;
    }

    protected String getDocBase(String path) {
        String basename = null;
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename;
    }

    protected void deployApps() {
        File appBase = this.appBase();
        File configBase = this.configBase();
        String[] filteredAppPaths = this.filterAppPaths(appBase.list());
        this.deployDescriptors(configBase, configBase.list());
        this.deployWARs(appBase, filteredAppPaths);
        this.deployDirectories(appBase, filteredAppPaths);
    }

    protected String[] filterAppPaths(String[] unfilteredAppPaths) {
        Pattern filter = this.host.getDeployIgnorePattern();
        if (filter == null) {
            return unfilteredAppPaths;
        }
        ArrayList<String> filteredList = new ArrayList<String>();
        Matcher matcher = null;
        for (String appPath : unfilteredAppPaths) {
            if (matcher == null) {
                matcher = filter.matcher(appPath);
            } else {
                matcher.reset(appPath);
            }
            if (matcher.matches()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("hostConfig.ignorePath", appPath));
                continue;
            }
            filteredList.add(appPath);
        }
        return filteredList.toArray(new String[filteredList.size()]);
    }

    protected void deployApps(String name) {
        File dir;
        File war;
        File appBase = this.appBase();
        File configBase = this.configBase();
        String baseName = this.getConfigFile(name);
        String docBase = this.getDocBase(name);
        File xml = new File(configBase, baseName + ".xml");
        if (xml.exists()) {
            this.deployDescriptor(name, xml, baseName + ".xml");
        }
        if ((war = new File(appBase, docBase + ".war")).exists()) {
            this.deployWAR(name, war, docBase + ".war");
        }
        if ((dir = new File(appBase, docBase)).exists()) {
            this.deployDirectory(name, dir, docBase);
        }
    }

    protected void deployDescriptors(File configBase, String[] files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF")) continue;
            File contextXml = new File(configBase, files[i]);
            if (!files[i].toLowerCase().endsWith(".xml")) continue;
            String nameTmp = files[i].substring(0, files[i].length() - 4);
            String contextPath = "/" + nameTmp.replace('#', '/');
            if (nameTmp.equals("ROOT")) {
                contextPath = "";
            }
            if (this.isServiced(contextPath)) continue;
            String file = files[i];
            this.deployDescriptor(contextPath, contextXml, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void deployDescriptor(String contextPath, File contextXml, String file) {
        Context context;
        DeployedApplication deployedApp;
        block21: {
            if (this.deploymentExists(contextPath)) {
                return;
            }
            deployedApp = new DeployedApplication(contextPath);
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("hostConfig.deployDescriptor", file));
            }
            context = null;
            try {
                File warDocBase;
                Digester digester = HostConfig.digester;
                // MONITORENTER : digester
                try {
                    context = (Context)HostConfig.digester.parse(contextXml);
                    if (context == null) {
                        log.error((Object)sm.getString("hostConfig.deployDescriptor.error", file));
                        Object var8_9 = null;
                        HostConfig.digester.reset();
                        // MONITOREXIT : digester
                        return;
                    }
                    Object var8_10 = null;
                    HostConfig.digester.reset();
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    HostConfig.digester.reset();
                    throw throwable;
                }
                if (context instanceof Lifecycle) {
                    Class<?> clazz = Class.forName(this.host.getConfigClass());
                    LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                    ((Lifecycle)((Object)context)).addLifecycleListener(listener);
                }
                context.setConfigFile(contextXml.getAbsolutePath());
                context.setPath(contextPath);
                boolean isExternalWar = false;
                boolean isExternal = false;
                if (context.getDocBase() != null) {
                    File docBase = new File(context.getDocBase());
                    if (!docBase.isAbsolute()) {
                        docBase = new File(this.appBase(), context.getDocBase());
                    }
                    if (!docBase.getCanonicalPath().startsWith(this.appBase().getAbsolutePath() + File.separator)) {
                        isExternal = true;
                        deployedApp.redeployResources.put(contextXml.getAbsolutePath(), new Long(contextXml.lastModified()));
                        deployedApp.redeployResources.put(docBase.getAbsolutePath(), new Long(docBase.lastModified()));
                        if (docBase.getAbsolutePath().toLowerCase().endsWith(".war")) {
                            isExternalWar = true;
                        }
                    } else {
                        log.warn((Object)sm.getString("hostConfig.deployDescriptor.localDocBaseSpecified", docBase));
                        context.setDocBase(null);
                    }
                }
                this.host.addChild(context);
                String name = null;
                String path = context.getPath();
                name = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1) : path);
                File expandedDocBase = new File(this.appBase(), name);
                if (context.getDocBase() != null && !(expandedDocBase = new File(context.getDocBase())).isAbsolute()) {
                    expandedDocBase = new File(this.appBase(), context.getDocBase());
                }
                if (isExternalWar && this.unpackWARs) {
                    deployedApp.redeployResources.put(expandedDocBase.getAbsolutePath(), new Long(expandedDocBase.lastModified()));
                    deployedApp.redeployResources.put(contextXml.getAbsolutePath(), new Long(contextXml.lastModified()));
                    this.addWatchedResources(deployedApp, expandedDocBase.getAbsolutePath(), context);
                    break block21;
                }
                if (!isExternal && (warDocBase = new File(expandedDocBase.getAbsolutePath() + ".war")).exists()) {
                    deployedApp.redeployResources.put(warDocBase.getAbsolutePath(), new Long(warDocBase.lastModified()));
                }
                if (this.unpackWARs) {
                    deployedApp.redeployResources.put(expandedDocBase.getAbsolutePath(), new Long(expandedDocBase.lastModified()));
                    this.addWatchedResources(deployedApp, expandedDocBase.getAbsolutePath(), context);
                } else {
                    this.addWatchedResources(deployedApp, null, context);
                }
                if (!isExternal) {
                    deployedApp.redeployResources.put(contextXml.getAbsolutePath(), new Long(contextXml.lastModified()));
                }
            }
            catch (Throwable t) {
                log.error((Object)sm.getString("hostConfig.deployDescriptor.error", file), t);
            }
        }
        if (context == null) return;
        if (this.host.findChild(context.getName()) == null) return;
        this.deployed.put(contextPath, deployedApp);
    }

    protected void deployWARs(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF")) continue;
            File dir = new File(appBase, files[i]);
            if (!files[i].toLowerCase().endsWith(".war") || !dir.isFile() || this.invalidWars.contains(files[i])) continue;
            String contextPath = "/" + files[i].replace('#', '/');
            int period = contextPath.lastIndexOf(".");
            if (!this.validateContextPath(appBase, contextPath = contextPath.substring(0, period))) {
                log.error((Object)sm.getString("hostConfig.illegalWarName", files[i]));
                this.invalidWars.add(files[i]);
                continue;
            }
            if (contextPath.equals("/ROOT")) {
                contextPath = "";
            }
            if (this.isServiced(contextPath)) continue;
            String file = files[i];
            this.deployWAR(contextPath, dir, file);
        }
    }

    private boolean validateContextPath(File appBase, String contextPath) {
        StringBuilder docBase;
        String canonicalDocBase = null;
        try {
            String canonicalAppBase = appBase.getCanonicalPath();
            docBase = new StringBuilder(canonicalAppBase);
            if (canonicalAppBase.endsWith(File.separator)) {
                docBase.append(contextPath.substring(1).replace('/', File.separatorChar));
            } else {
                docBase.append(contextPath.replace('/', File.separatorChar));
            }
            canonicalDocBase = new File(docBase.toString()).getCanonicalPath();
            if (canonicalDocBase.endsWith(File.separator)) {
                docBase.append(File.separator);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return canonicalDocBase.equals(docBase.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deployWAR(String contextPath, File war, String file) {
        block32: {
            block38: {
                if (this.deploymentExists(contextPath)) {
                    return;
                }
                jar = null;
                entry = null;
                istream = null;
                ostream = null;
                xml = new File(this.configBase, file.substring(0, file.lastIndexOf(".")) + ".xml");
                if (!this.deployXML || xml.exists()) break block32;
                try {
                    block31: {
                        try {
                            jar = new JarFile(war);
                            entry = jar.getJarEntry("META-INF/context.xml");
                            if (entry == null) break block31;
                            istream = jar.getInputStream(entry);
                            this.configBase.mkdirs();
                            ostream = new BufferedOutputStream(new FileOutputStream(xml), 1024);
                            buffer = new byte[1024];
                            while (true) {
                                if ((n = istream.read(buffer)) < 0) {
                                    ostream.flush();
                                    ostream.close();
                                    ostream = null;
                                    istream.close();
                                    istream = null;
                                    entry = null;
                                    jar.close();
                                    jar = null;
                                    break;
                                }
                                ostream.write(buffer, 0, n);
                            }
                        }
                        catch (Exception e) {
                            if (ostream != null) {
                                try {
                                    ostream.close();
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                                ostream = null;
                            }
                            if (istream != null) {
                                try {
                                    istream.close();
                                }
                                catch (Throwable t) {
                                    // empty catch block
                                }
                                istream = null;
                            }
                            var12_17 = null;
                            entry = null;
                            if (jar == null) break block32;
                            try {
                                jar.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            jar = null;
                            break block32;
                        }
                    }
                    var12_17 = null;
                    entry = null;
                    if (jar == null) break block32;
                }
                catch (Throwable var11_21) {
                    block36: {
                        block37: {
                            var12_18 = null;
                            entry = null;
                            if (jar == null) break block36;
                            ** try [egrp 4[TRYBLOCK] [6 : 277->285)] { 
lbl70:
                            // 1 sources

                            jar.close();
                            break block37;
lbl72:
                            // 1 sources

                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        jar = null;
                    }
                    throw var11_21;
                }
                ** try [egrp 4[TRYBLOCK] [6 : 277->285)] { 
lbl79:
                // 1 sources

                jar.close();
                break block38;
lbl81:
                // 1 sources

                catch (Throwable t) {
                    // empty catch block
                }
            }
            jar = null;
        }
        deployedApp = new DeployedApplication(contextPath);
        if (HostConfig.log.isInfoEnabled()) {
            HostConfig.log.info((Object)HostConfig.sm.getString("hostConfig.deployJar", file));
        }
        try {
            context = null;
            if (this.deployXML && xml.exists()) {
                var11_22 = HostConfig.digester;
                synchronized (var11_22) {
                    block34: {
                        try {
                            context = (Context)HostConfig.digester.parse(xml);
                            if (context != null) break block34;
                            HostConfig.log.error((Object)HostConfig.sm.getString("hostConfig.deployDescriptor.error", file));
                            var15_23 = null;
                        }
                        catch (Throwable var14_26) {
                            var15_25 = null;
                            HostConfig.digester.reset();
                            throw var14_26;
                        }
                        HostConfig.digester.reset();
                        return;
                    }
                    var15_24 = null;
                    HostConfig.digester.reset();
                }
                context.setConfigFile(xml.getAbsolutePath());
            } else {
                context = (Context)Class.forName(this.contextClass).newInstance();
            }
            deployedApp.redeployResources.put(war.getAbsolutePath(), new Long(war.lastModified()));
            if (this.deployXML && xml.exists()) {
                deployedApp.redeployResources.put(xml.getAbsolutePath(), new Long(xml.lastModified()));
            }
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.host.getConfigClass());
                listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)context).addLifecycleListener(listener);
            }
            context.setPath(contextPath);
            context.setDocBase(file);
            this.host.addChild(context);
            if (this.unpackWARs && context.getDocBase() != null) {
                name = null;
                path = context.getPath();
                name = path.equals("") != false ? "ROOT" : (path.startsWith("/") != false ? path.substring(1) : path);
                docBase = new File(name = name.replace('/', '#'));
                if (!docBase.isAbsolute()) {
                    docBase = new File(this.appBase(), name);
                }
                deployedApp.redeployResources.put(docBase.getAbsolutePath(), new Long(docBase.lastModified()));
                this.addWatchedResources(deployedApp, docBase.getAbsolutePath(), context);
            } else {
                this.addWatchedResources(deployedApp, null, context);
            }
        }
        catch (Throwable t) {
            HostConfig.log.error((Object)HostConfig.sm.getString("hostConfig.deployJar.error", file), t);
        }
        this.deployed.put(contextPath, deployedApp);
    }

    protected void deployDirectories(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File dir;
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || !(dir = new File(appBase, files[i])).isDirectory()) continue;
            String contextPath = "/" + files[i].replace('#', '/');
            if (files[i].equals("ROOT")) {
                contextPath = "";
            }
            if (this.isServiced(contextPath)) continue;
            this.deployDirectory(contextPath, dir, files[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deployDirectory(String contextPath, File dir, String file) {
        deployedApp = new DeployedApplication(contextPath);
        if (this.deploymentExists(contextPath)) {
            return;
        }
        if (HostConfig.log.isInfoEnabled()) {
            HostConfig.log.info((Object)HostConfig.sm.getString("hostConfig.deployDir", file));
        }
        try {
            block25: {
                block23: {
                    block24: {
                        context = null;
                        xml = new File(dir, "META-INF/context.xml");
                        xmlCopy = null;
                        if (!this.deployXML || !xml.exists()) break block23;
                        var8_9 = HostConfig.digester;
                        synchronized (var8_9) {
                            block21: {
                                try {
                                    context = (Context)HostConfig.digester.parse(xml);
                                    if (context != null) break block21;
                                    HostConfig.log.error((Object)HostConfig.sm.getString("hostConfig.deployDescriptor.error", xml));
                                    var10_10 = null;
                                }
                                catch (Throwable var9_13) {
                                    var10_12 = null;
                                    HostConfig.digester.reset();
                                    throw var9_13;
                                }
                                HostConfig.digester.reset();
                                return;
                            }
                            var10_11 = null;
                            HostConfig.digester.reset();
                        }
                        this.configBase.mkdirs();
                        xmlCopy = new File(this.configBase, file + ".xml");
                        is = null;
                        os = null;
                        try {
                            is = new FileInputStream(xml);
                            os = new FileOutputStream(xmlCopy);
                            IOTools.flow(is, os);
                            var13_15 = null;
                        }
                        catch (Throwable var12_19) {
                            var13_16 = null;
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            try {
                                if (os == null) throw var12_19;
                                os.close();
                                throw var12_19;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            throw var12_19;
                        }
                        ** try [egrp 4[TRYBLOCK] [8 : 260->273)] { 
lbl60:
                        // 1 sources

                        if (is != null) {
                            is.close();
                        }
                        break block24;
lbl63:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    try {}
                    catch (IOException e) {}
                    if (os != null) {
                        os.close();
                    }
                    context.setConfigFile(xmlCopy.getAbsolutePath());
                    break block25;
                }
                context = (Context)Class.forName(this.contextClass).newInstance();
            }
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.host.getConfigClass());
                listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)context).addLifecycleListener(listener);
            }
            context.setPath(contextPath);
            context.setDocBase(file);
            this.host.addChild(context);
            deployedApp.redeployResources.put(dir.getAbsolutePath(), new Long(dir.lastModified()));
            if (xmlCopy != null) {
                deployedApp.redeployResources.put(xmlCopy.getAbsolutePath(), new Long(xmlCopy.lastModified()));
            }
            this.addWatchedResources(deployedApp, dir.getAbsolutePath(), context);
        }
        catch (Throwable t) {
            HostConfig.log.error((Object)HostConfig.sm.getString("hostConfig.deployDir.error", file), t);
        }
        this.deployed.put(contextPath, deployedApp);
    }

    protected boolean deploymentExists(String contextPath) {
        return this.deployed.containsKey(contextPath) || this.host.findChild(contextPath) != null;
    }

    protected void addWatchedResources(DeployedApplication app, String docBase, Context context) {
        File docBaseFile = null;
        if (docBase != null && !(docBaseFile = new File(docBase)).isAbsolute()) {
            docBaseFile = new File(this.appBase(), docBase);
        }
        String[] watchedResources = context.findWatchedResources();
        for (int i = 0; i < watchedResources.length; ++i) {
            File resource = new File(watchedResources[i]);
            if (!resource.isAbsolute()) {
                if (docBase != null) {
                    resource = new File(docBaseFile, watchedResources[i]);
                } else {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Ignoring non-existent WatchedResource '" + resource.getAbsolutePath() + "'"));
                    continue;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Watching WatchedResource '" + resource.getAbsolutePath() + "'"));
            }
            app.reloadResources.put(resource.getAbsolutePath(), new Long(resource.lastModified()));
        }
    }

    protected synchronized void checkResources(DeployedApplication app) {
        String[] resources = app.redeployResources.keySet().toArray(new String[0]);
        for (int i = 0; i < resources.length; ++i) {
            long lastModified;
            File resource = new File(resources[i]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking context[" + app.name + "] redeploy resource " + resource));
            }
            if (resource.exists()) {
                long lastModified2 = app.redeployResources.get(resources[i]);
                if (resource.isDirectory() || resource.lastModified() <= lastModified2) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)sm.getString("hostConfig.undeploy", app.name));
                }
                ContainerBase context = (ContainerBase)this.host.findChild(app.name);
                try {
                    this.host.removeChild(context);
                }
                catch (Throwable t) {
                    log.warn((Object)sm.getString("hostConfig.context.remove", app.name), t);
                }
                try {
                    context.destroy();
                }
                catch (Throwable t) {
                    log.warn((Object)sm.getString("hostConfig.context.destroy", app.name), t);
                }
                for (int j = i + 1; j < resources.length; ++j) {
                    try {
                        File current = new File(resources[j]);
                        current = current.getCanonicalFile();
                        if (!current.getAbsolutePath().startsWith(this.appBase().getAbsolutePath() + File.separator) && !current.getAbsolutePath().startsWith(this.configBase().getAbsolutePath())) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Delete " + current));
                        }
                        ExpandWar.delete(current);
                        continue;
                    }
                    catch (IOException e) {
                        log.warn((Object)sm.getString("hostConfig.canonicalizing", app.name), (Throwable)e);
                    }
                }
                this.deployed.remove(app.name);
                return;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            if (resource.exists() || (lastModified = app.redeployResources.get(resources[i]).longValue()) == 0L) continue;
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("hostConfig.undeploy", app.name));
            }
            ContainerBase context = (ContainerBase)this.host.findChild(app.name);
            try {
                this.host.removeChild(context);
            }
            catch (Throwable t) {
                log.warn((Object)sm.getString("hostConfig.context.remove", app.name), t);
            }
            if (context != null) {
                try {
                    context.destroy();
                }
                catch (Throwable t) {
                    log.warn((Object)sm.getString("hostConfig.context.destroy", app.name), t);
                }
            }
            for (int j = i + 1; j < resources.length; ++j) {
                try {
                    File current = new File(resources[j]);
                    current = current.getCanonicalFile();
                    if (!current.getAbsolutePath().startsWith(this.appBase().getAbsolutePath() + File.separator) && !current.getAbsolutePath().startsWith(this.configBase().getAbsolutePath())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Delete " + current));
                    }
                    ExpandWar.delete(current);
                    continue;
                }
                catch (IOException e) {
                    log.warn((Object)sm.getString("hostConfig.canonicalizing", app.name), (Throwable)e);
                }
            }
            String[] resources2 = app.reloadResources.keySet().toArray(new String[0]);
            for (int j = 0; j < resources2.length; ++j) {
                try {
                    File current = new File(resources2[j]);
                    current = current.getCanonicalFile();
                    if (!current.getAbsolutePath().startsWith(this.appBase().getAbsolutePath() + File.separator) && (!current.getAbsolutePath().startsWith(this.configBase().getAbsolutePath()) || !current.getAbsolutePath().endsWith(".xml"))) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Delete " + current));
                    }
                    ExpandWar.delete(current);
                    continue;
                }
                catch (IOException e) {
                    log.warn((Object)sm.getString("hostConfig.canonicalizing", app.name), (Throwable)e);
                }
            }
            this.deployed.remove(app.name);
            return;
        }
        resources = app.reloadResources.keySet().toArray(new String[0]);
        boolean update = false;
        for (int i = 0; i < resources.length; ++i) {
            File resource = new File(resources[i]);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking context[" + app.name + "] reload resource " + resource));
            }
            long lastModified = app.reloadResources.get(resources[i]);
            if (resource.lastModified() != lastModified || update) {
                if (!update) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)sm.getString("hostConfig.reload", app.name));
                    }
                    Container context = this.host.findChild(app.name);
                    try {
                        ((Lifecycle)((Object)context)).stop();
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("hostConfig.context.restart", app.name), (Throwable)e);
                    }
                    try {
                        ((Lifecycle)((Object)context)).start();
                    }
                    catch (Exception e) {
                        log.warn((Object)sm.getString("hostConfig.context.restart", app.name), (Throwable)e);
                    }
                    update = true;
                }
                app.reloadResources.put(resources[i], resource.lastModified());
            }
            app.timestamp = System.currentTimeMillis();
        }
    }

    public void start() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.start"));
        }
        try {
            ObjectName hostON = new ObjectName(this.host.getObjectName());
            this.oname = new ObjectName(hostON.getDomain() + ":type=Deployer,host=" + this.host.getName());
            Registry.getRegistry(null, null).registerComponent((Object)this, this.oname, this.getClass().getName());
        }
        catch (Exception e) {
            log.error((Object)sm.getString("hostConfig.jmx.register", this.oname), (Throwable)e);
        }
        if (this.host.getDeployOnStartup()) {
            this.deployApps();
        }
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.stop"));
        }
        this.undeployApps();
        if (this.oname != null) {
            try {
                Registry.getRegistry(null, null).unregisterComponent(this.oname);
            }
            catch (Exception e) {
                log.error((Object)sm.getString("hostConfig.jmx.unregister", this.oname), (Throwable)e);
            }
        }
        this.oname = null;
        this.appBase = null;
        this.configBase = null;
    }

    protected void undeployApps() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("hostConfig.undeploying"));
        }
        DeployedApplication[] apps = this.deployed.values().toArray(new DeployedApplication[0]);
        for (int i = 0; i < apps.length; ++i) {
            try {
                this.host.removeChild(this.host.findChild(apps[i].name));
                continue;
            }
            catch (Throwable t) {
                log.warn((Object)sm.getString("hostConfig.context.remove", apps[i].name), t);
            }
        }
        this.deployed.clear();
    }

    protected void check() {
        if (this.host.getAutoDeploy()) {
            DeployedApplication[] apps = this.deployed.values().toArray(new DeployedApplication[0]);
            for (int i = 0; i < apps.length; ++i) {
                if (this.isServiced(apps[i].name)) continue;
                this.checkResources(apps[i]);
            }
            this.deployApps();
        }
    }

    public void check(String name) {
        DeployedApplication app = this.deployed.get(name);
        if (app != null) {
            this.checkResources(app);
        } else {
            this.deployApps(name);
        }
    }

    public void manageApp(Context context) {
        String contextPath = context.getPath();
        if (this.deployed.containsKey(contextPath)) {
            return;
        }
        DeployedApplication deployedApp = new DeployedApplication(contextPath);
        boolean isWar = false;
        if (context.getDocBase() != null) {
            File docBase = new File(context.getDocBase());
            if (!docBase.isAbsolute()) {
                docBase = new File(this.appBase(), context.getDocBase());
            }
            deployedApp.redeployResources.put(docBase.getAbsolutePath(), new Long(docBase.lastModified()));
            if (docBase.getAbsolutePath().toLowerCase().endsWith(".war")) {
                isWar = true;
            }
        }
        this.host.addChild(context);
        if (isWar && this.unpackWARs) {
            String name = null;
            String path = context.getPath();
            name = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1) : path);
            File docBase = new File(name);
            if (!docBase.isAbsolute()) {
                docBase = new File(this.appBase(), name);
            }
            deployedApp.redeployResources.put(docBase.getAbsolutePath(), new Long(docBase.lastModified()));
            this.addWatchedResources(deployedApp, docBase.getAbsolutePath(), context);
        } else {
            this.addWatchedResources(deployedApp, null, context);
        }
        this.deployed.put(contextPath, deployedApp);
    }

    public void unmanageApp(String contextPath) {
        if (this.isServiced(contextPath)) {
            this.deployed.remove(contextPath);
            this.host.removeChild(this.host.findChild(contextPath));
        }
    }

    protected class DeployedApplication {
        public String name;
        public LinkedHashMap<String, Long> redeployResources = new LinkedHashMap();
        public HashMap<String, Long> reloadResources = new HashMap();
        public long timestamp = System.currentTimeMillis();

        public DeployedApplication(String name) {
            this.name = name;
        }
    }
}

