/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.security.AccessControlException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.Prefs;
import org.igoweb.util.swing.TBlock;

public abstract class SelectFile {
    public static final String DEFAULT_DIR_PREF = "rTwGpq!q";
    private static File defaultDir = null;

    public static File getFile(Component parent, String title, String defName, boolean isSaving) {
        if (defName == null) {
            return SelectFile.getFile(parent, title, (File)null, isSaving);
        }
        if (defaultDir == null) {
            String ddn = Prefs.getString(DEFAULT_DIR_PREF, null);
            defaultDir = new File(ddn == null ? System.getProperty("user.dir") : ddn);
        }
        return SelectFile.getFile(parent, title, new File(defaultDir, defName), isSaving);
    }

    public static File getFile(Component parent, String title, File defaultFile, boolean isSaving) {
        try {
            if (defaultDir == null) {
                String ddn = Prefs.getString(DEFAULT_DIR_PREF, null);
                defaultDir = new File(ddn == null ? System.getProperty("user.dir") : ddn);
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle(title);
            chooser.setFileSelectionMode(0);
            if (defaultFile == null || defaultFile.getParent() == null) {
                chooser.setCurrentDirectory(defaultDir);
            } else {
                chooser.setCurrentDirectory(new File(defaultFile.getParent()));
            }
            if (isSaving) {
                chooser.setDialogType(1);
                chooser.setSelectedFile(defaultFile);
            } else {
                chooser.setDialogType(0);
                if (defaultFile != null) {
                    chooser.setSelectedFile(defaultFile);
                }
            }
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    String name = file.toString();
                    if (name == null) {
                        return false;
                    }
                    return name.endsWith(".sgf") || name.endsWith(".go");
                }

                @Override
                public String getDescription() {
                    return Defs.getString(1096335336);
                }
            });
            int returnVal = isSaving ? chooser.showSaveDialog(parent) : chooser.showOpenDialog(parent);
            if (returnVal == 0) {
                defaultDir = chooser.getCurrentDirectory();
                File result = chooser.getSelectedFile();
                if (isSaving && !result.getPath().endsWith(".sgf")) {
                    result = new File(result.getPath() + ".sgf");
                }
                if (isSaving && result.exists()) {
                    JOptionPane jop = new JOptionPane(new TBlock(Defs.getString(1096335328, result.toString()), 15), 2, 0);
                    final JDialog dlog = jop.createDialog(parent, Defs.getString(1096335310));
                    dlog.setModal(true);
                    WindowAdapter winList = new WindowAdapter(){

                        @Override
                        public void windowOpened(WindowEvent event) {
                            dlog.removeWindowListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    dlog.setSize(dlog.getPreferredSize());
                                }
                            });
                        }
                    };
                    dlog.addWindowListener(winList);
                    dlog.setVisible(true);
                    Object dlogValue = jop.getValue();
                    if (dlogValue == null || (Integer)dlogValue != 0) {
                        return null;
                    }
                }
                Prefs.putString(DEFAULT_DIR_PREF, defaultDir.toString());
                return result;
            }
            return null;
        }
        catch (AccessControlException excep) {
            new Errout(Defs.getString(1096335313), parent);
            Logger.getLogger("global").log(Level.WARNING, "SeletFile.getFile(): Error opening file dialog", excep);
            return null;
        }
    }

    public static void setDefaultDir(File newDefaultDir) {
        defaultDir = newDefaultDir;
        System.setProperty("user.dir", defaultDir.getPath());
    }
}

