/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser.processors;

import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.security.policy.WSSPolicyException;
import org.apache.ws.security.policy.model.TokenWrapper;
import org.apache.ws.security.policy.model.X509Token;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;

public class X509TokenProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedX509Token = false;

    private void initializeX509Token(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.requireKeyIdentifierReference.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.requireIssuerSerialReference.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.requireEmbeddedTokenReference.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.requireThumbprintReference.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wssX509V1Token10.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wssX509V3Token10.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wssX509Pkcs7Token10.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wssX509PkiPathV1Token10.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wssX509V1Token11.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wssX509V3Token11.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wssX509Pkcs7Token11.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wssX509PkiPathV1Token11.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
    }

    public Object doX509Token(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                PrimitiveAssertion pa;
                String text;
                if (!this.initializedX509Token) {
                    try {
                        this.initializeX509Token(spt);
                        X509Token token = (X509Token)spc.readCurrentPolicyEngineData();
                        String includetokenUri = spc.getAssertion().getAttribute(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", "IncludeToken"));
                        try {
                            if (includetokenUri != null) {
                                token.setInclusion(includetokenUri);
                            }
                            ((TokenWrapper)((Object)spc.readPreviousPolicyEngineData())).setToken(token);
                        }
                        catch (WSSPolicyException e) {
                            e.printStackTrace();
                        }
                        this.initializedX509Token = true;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        return new Boolean(false);
                    }
                }
                if ((text = (pa = spc.getAssertion()).getStrValue()) != null) {
                    text = text.trim();
                    this.log.debug((Object)("Value: '" + text.toString() + "'"));
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doRequireKeyIdentifierReference(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setRequireKeyIdentifierReference(true);
        }
        return new Boolean(true);
    }

    public Object doRequireIssuerSerialReference(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setRequireIssuerSerialReference(true);
        }
        return new Boolean(true);
    }

    public Object doRequireEmbeddedTokenReference(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setRequireEmbeddedTokenReference(true);
        }
        return new Boolean(true);
    }

    public Object doRequireThumbprintReference(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setRequireThumbprintReference(true);
        }
        return new Boolean(true);
    }

    public Object doWssX509V1Token10(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setTokenVersionAndType(spc.getAssertion().getName().getLocalPart());
        }
        return new Boolean(true);
    }

    public Object doWssX509V3Token10(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setTokenVersionAndType(spc.getAssertion().getName().getLocalPart());
        }
        return new Boolean(true);
    }

    public Object doWssX509Pkcs7Token10(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setTokenVersionAndType(spc.getAssertion().getName().getLocalPart());
        }
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setTokenVersionAndType(spc.getAssertion().getName().getLocalPart());
        }
        return new Boolean(true);
    }

    public Object doWssX509PkiPathV1Token10(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setTokenVersionAndType(spc.getAssertion().getName().getLocalPart());
        }
        return new Boolean(true);
    }

    public Object doWssX509V1Token11(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setTokenVersionAndType(spc.getAssertion().getName().getLocalPart());
        }
        return new Boolean(true);
    }

    public Object doWssX509V3Token11(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setTokenVersionAndType(spc.getAssertion().getName().getLocalPart());
        }
        return new Boolean(true);
    }

    public Object doWssX509Pkcs7Token11(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setTokenVersionAndType(spc.getAssertion().getName().getLocalPart());
        }
        return new Boolean(true);
    }

    public Object doWssX509PkiPathV1Token11(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((X509Token)spc.readCurrentPolicyEngineData()).setTokenVersionAndType(spc.getAssertion().getName().getLocalPart());
        }
        return new Boolean(true);
    }
}

