/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.util.StaticUtils;

public enum SubtreeAccessibilityState {
    ACCESSIBLE(0, "accessible"),
    READ_ONLY_BIND_ALLOWED(1, "read-only-bind-allowed"),
    READ_ONLY_BIND_DENIED(2, "read-only-bind-denied"),
    HIDDEN(3, "hidden");

    private final int intValue;
    private final String stateName;

    private SubtreeAccessibilityState(int intValue, String stateName) {
        this.intValue = intValue;
        this.stateName = stateName;
    }

    public int intValue() {
        return this.intValue;
    }

    public String getStateName() {
        return this.stateName;
    }

    public boolean isAccessible() {
        return this == ACCESSIBLE;
    }

    public boolean isHidden() {
        return this == HIDDEN;
    }

    public boolean isReadOnly() {
        return this == READ_ONLY_BIND_ALLOWED || this == READ_ONLY_BIND_DENIED;
    }

    public static SubtreeAccessibilityState valueOf(int intValue) {
        switch (intValue) {
            case 0: {
                return ACCESSIBLE;
            }
            case 1: {
                return READ_ONLY_BIND_ALLOWED;
            }
            case 2: {
                return READ_ONLY_BIND_DENIED;
            }
            case 3: {
                return HIDDEN;
            }
        }
        return null;
    }

    public static SubtreeAccessibilityState forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "accessible": {
                return ACCESSIBLE;
            }
            case "readonlybindallowed": 
            case "read-only-bind-allowed": 
            case "read_only_bind_allowed": {
                return READ_ONLY_BIND_ALLOWED;
            }
            case "readonlybinddenied": 
            case "read-only-bind-denied": 
            case "read_only_bind_denied": {
                return READ_ONLY_BIND_DENIED;
            }
            case "hidden": {
                return HIDDEN;
            }
        }
        return null;
    }

    public String toString() {
        return this.stateName;
    }
}

