/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.FinalizeJobExecutionAction;
import org.elasticsearch.xpack.core.ml.action.OpenJobAction;
import org.elasticsearch.xpack.core.ml.action.UpdateJobAction;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;
import org.elasticsearch.xpack.core.ml.job.config.DetectionRule;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.config.JobTaskState;
import org.elasticsearch.xpack.core.ml.job.config.JobUpdate;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.persistence.ElasticsearchMappings;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlConfigMigrationEligibilityCheck;
import org.elasticsearch.xpack.ml.job.ClusterStateJobUpdate;
import org.elasticsearch.xpack.ml.job.JobManager;
import org.elasticsearch.xpack.ml.job.persistence.JobConfigProvider;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsProvider;
import org.elasticsearch.xpack.ml.job.process.autodetect.AutodetectProcessManager;
import org.elasticsearch.xpack.ml.process.MlMemoryTracker;

public class TransportOpenJobAction
extends TransportMasterNodeAction<OpenJobAction.Request, AcknowledgedResponse> {
    private static final PersistentTasksCustomMetaData.Assignment AWAITING_LAZY_ASSIGNMENT = new PersistentTasksCustomMetaData.Assignment(null, "persistent task is awaiting node assignment.");
    static final PersistentTasksCustomMetaData.Assignment AWAITING_MIGRATION = new PersistentTasksCustomMetaData.Assignment(null, "job cannot be assigned until it has been migrated.");
    private final XPackLicenseState licenseState;
    private final PersistentTasksService persistentTasksService;
    private final Client client;
    private final JobConfigProvider jobConfigProvider;
    private final JobResultsProvider jobResultsProvider;
    private final JobManager jobManager;
    private final MlMemoryTracker memoryTracker;
    private final MlConfigMigrationEligibilityCheck migrationEligibilityCheck;

    @Inject
    public TransportOpenJobAction(Settings settings, TransportService transportService, ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService, PersistentTasksService persistentTasksService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, JobResultsProvider jobResultsProvider, JobManager jobManager, JobConfigProvider jobConfigProvider, MlMemoryTracker memoryTracker) {
        super(settings, "cluster:admin/xpack/ml/job/open", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, OpenJobAction.Request::new);
        this.licenseState = licenseState;
        this.persistentTasksService = persistentTasksService;
        this.client = client;
        this.jobResultsProvider = jobResultsProvider;
        this.jobConfigProvider = jobConfigProvider;
        this.jobManager = jobManager;
        this.memoryTracker = memoryTracker;
        this.migrationEligibilityCheck = new MlConfigMigrationEligibilityCheck(settings, clusterService);
    }

    static void validate(String jobId, Job job) {
        if (job == null) {
            throw ExceptionsHelper.missingJobException((String)jobId);
        }
        if (job.isDeleting()) {
            throw ExceptionsHelper.conflictStatusException((String)("Cannot open job [" + jobId + "] because it is being deleted"), (Object[])new Object[0]);
        }
        if (job.getJobVersion() == null) {
            throw ExceptionsHelper.badRequestException((String)("Cannot open job [" + jobId + "] because jobs created prior to version 5.5 are not supported"), (Object[])new Object[0]);
        }
    }

    static PersistentTasksCustomMetaData.Assignment selectLeastLoadedMlNode(String jobId, Job job, ClusterState clusterState, int maxConcurrentJobAllocations, int fallbackMaxNumberOfOpenJobs, int maxMachineMemoryPercent, MlMemoryTracker memoryTracker, boolean isMemoryTrackerRecentlyRefreshed, Logger logger) {
        DiscoveryNode minLoadedNode;
        boolean allocateByMemory = isMemoryTrackerRecentlyRefreshed;
        if (!isMemoryTrackerRecentlyRefreshed) {
            logger.warn("Falling back to allocating job [{}] by job counts because a memory requirement refresh could not be scheduled", (Object)jobId);
        }
        LinkedList<String> reasons = new LinkedList<String>();
        long maxAvailableCount = Long.MIN_VALUE;
        long maxAvailableMemory = Long.MIN_VALUE;
        DiscoveryNode minLoadedNodeByCount = null;
        DiscoveryNode minLoadedNodeByMemory = null;
        PersistentTasksCustomMetaData persistentTasks = (PersistentTasksCustomMetaData)clusterState.getMetaData().custom("persistent_tasks");
        for (DiscoveryNode node : clusterState.getNodes()) {
            long availableCount;
            String reason;
            Map nodeAttributes = node.getAttributes();
            String enabled = (String)nodeAttributes.get("ml.enabled");
            if (!Boolean.valueOf(enabled).booleanValue()) {
                reason = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameOrId(node) + "], because this node isn't a ml node.";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            if (!TransportOpenJobAction.nodeSupportsMlJobs(node.getVersion())) {
                reason = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndVersion(node) + "], because this node does not support machine learning jobs";
                logger.trace(reason);
                reasons.add(reason);
                continue;
            }
            Set compatibleJobTypes = Job.getCompatibleJobTypes((Version)node.getVersion());
            if (!compatibleJobTypes.contains(job.getJobType())) {
                String reason2 = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndVersion(node) + "], because this node does not support jobs of type [" + job.getJobType() + "]";
                logger.trace(reason2);
                reasons.add(reason2);
                continue;
            }
            if (TransportOpenJobAction.jobHasRules(job) && node.getVersion().before(DetectionRule.VERSION_INTRODUCED)) {
                String reason3 = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndVersion(node) + "], because jobs using custom_rules require a node of version [" + DetectionRule.VERSION_INTRODUCED + "] or higher";
                logger.trace(reason3);
                reasons.add(reason3);
                continue;
            }
            boolean jobConfigIsStoredInIndex = job.getJobVersion().onOrAfter(Version.V_6_6_0);
            if (jobConfigIsStoredInIndex && node.getVersion().before(Version.V_6_6_0)) {
                String reason4 = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameOrId(node) + "] version [" + node.getVersion() + "], because this node does not support jobs of version [" + job.getJobVersion() + "]";
                logger.trace(reason4);
                reasons.add(reason4);
                continue;
            }
            long numberOfAssignedJobs = 0L;
            int numberOfAllocatingJobs = 0;
            long assignedJobMemory = 0L;
            if (persistentTasks != null) {
                Collection assignedTasks = persistentTasks.findTasks("xpack/ml/job", task -> node.getId().equals(task.getExecutorNode()));
                for (PersistentTasksCustomMetaData.PersistentTask assignedTask : assignedTasks) {
                    OpenJobAction.JobParams params;
                    Long jobMemoryRequirement;
                    JobState jobState = MlTasks.getJobStateModifiedForReassignments((PersistentTasksCustomMetaData.PersistentTask)assignedTask);
                    if (jobState.isAnyOf(new JobState[]{JobState.CLOSED, JobState.FAILED})) continue;
                    ++numberOfAssignedJobs;
                    if (jobState == JobState.OPENING) {
                        ++numberOfAllocatingJobs;
                    }
                    if ((jobMemoryRequirement = memoryTracker.getJobMemoryRequirement((params = (OpenJobAction.JobParams)assignedTask.getParams()).getJobId())) == null) {
                        allocateByMemory = false;
                        logger.debug("Falling back to allocating job [{}] by job counts because the memory requirement for job [{}] was not available", (Object)jobId, (Object)params.getJobId());
                        continue;
                    }
                    assignedJobMemory += jobMemoryRequirement.longValue();
                }
            }
            if (numberOfAllocatingJobs >= maxConcurrentJobAllocations) {
                String reason5 = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndMlAttributes(node) + "], because node exceeds [" + numberOfAllocatingJobs + "] the maximum number of jobs [" + maxConcurrentJobAllocations + "] in opening state";
                logger.trace(reason5);
                reasons.add(reason5);
                continue;
            }
            String maxNumberOfOpenJobsStr = (String)nodeAttributes.get("ml.max_open_jobs");
            int maxNumberOfOpenJobs = fallbackMaxNumberOfOpenJobs;
            if (maxNumberOfOpenJobsStr != null) {
                try {
                    maxNumberOfOpenJobs = Integer.parseInt(maxNumberOfOpenJobsStr);
                }
                catch (NumberFormatException e) {
                    String reason6 = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndMlAttributes(node) + "], because " + "ml.max_open_jobs" + " attribute [" + maxNumberOfOpenJobsStr + "] is not an integer";
                    logger.trace(reason6);
                    reasons.add(reason6);
                    continue;
                }
            }
            if ((availableCount = (long)maxNumberOfOpenJobs - numberOfAssignedJobs) == 0L) {
                String reason7 = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndMlAttributes(node) + "], because this node is full. Number of opened jobs [" + numberOfAssignedJobs + "], " + AutodetectProcessManager.MAX_OPEN_JOBS_PER_NODE.getKey() + " [" + maxNumberOfOpenJobs + "]";
                logger.trace(reason7);
                reasons.add(reason7);
                continue;
            }
            if (maxAvailableCount < availableCount) {
                maxAvailableCount = availableCount;
                minLoadedNodeByCount = node;
            }
            String machineMemoryStr = (String)nodeAttributes.get("ml.machine_memory");
            long machineMemory = -1L;
            if (machineMemoryStr != null) {
                try {
                    machineMemory = Long.parseLong(machineMemoryStr);
                }
                catch (NumberFormatException e) {
                    String reason8 = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndMlAttributes(node) + "], because " + "ml.machine_memory" + " attribute [" + machineMemoryStr + "] is not a long";
                    logger.trace(reason8);
                    reasons.add(reason8);
                    continue;
                }
            }
            if (!allocateByMemory) continue;
            if (machineMemory > 0L) {
                long maxMlMemory = machineMemory * (long)maxMachineMemoryPercent / 100L;
                Long estimatedMemoryFootprint = memoryTracker.getJobMemoryRequirement(jobId);
                if (estimatedMemoryFootprint != null) {
                    long availableMemory = maxMlMemory - assignedJobMemory;
                    if (estimatedMemoryFootprint > availableMemory) {
                        String reason9 = "Not opening job [" + jobId + "] on node [" + TransportOpenJobAction.nodeNameAndMlAttributes(node) + "], because this node has insufficient available memory. Available memory for ML [" + maxMlMemory + "], memory required by existing jobs [" + assignedJobMemory + "], estimated memory required for this job [" + estimatedMemoryFootprint + "]";
                        logger.trace(reason9);
                        reasons.add(reason9);
                        continue;
                    }
                    if (maxAvailableMemory >= availableMemory) continue;
                    maxAvailableMemory = availableMemory;
                    minLoadedNodeByMemory = node;
                    continue;
                }
                allocateByMemory = false;
                logger.debug("Falling back to allocating job [{}] by job counts because its memory requirement was not available", (Object)jobId);
                continue;
            }
            allocateByMemory = false;
            logger.debug("Falling back to allocating job [{}] by job counts because machine memory was not available for node [{}]", (Object)jobId, (Object)TransportOpenJobAction.nodeNameAndMlAttributes(node));
        }
        DiscoveryNode discoveryNode = minLoadedNode = allocateByMemory ? minLoadedNodeByMemory : minLoadedNodeByCount;
        if (minLoadedNode != null) {
            logger.debug("selected node [{}] for job [{}]", minLoadedNode, (Object)jobId);
            return new PersistentTasksCustomMetaData.Assignment(minLoadedNode.getId(), "");
        }
        String explanation = String.join((CharSequence)"|", reasons);
        logger.debug("no node selected for job [{}], reasons [{}]", (Object)jobId, (Object)explanation);
        return new PersistentTasksCustomMetaData.Assignment(null, explanation);
    }

    static String nodeNameOrId(DiscoveryNode node) {
        String nodeNameOrID = node.getName();
        if (Strings.isNullOrEmpty((String)nodeNameOrID)) {
            nodeNameOrID = node.getId();
        }
        return nodeNameOrID;
    }

    static String nodeNameAndVersion(DiscoveryNode node) {
        String nodeNameOrID = TransportOpenJobAction.nodeNameOrId(node);
        StringBuilder builder = new StringBuilder("{").append(nodeNameOrID).append('}');
        builder.append('{').append("version=").append(node.getVersion()).append('}');
        return builder.toString();
    }

    static String nodeNameAndMlAttributes(DiscoveryNode node) {
        String nodeNameOrID = TransportOpenJobAction.nodeNameOrId(node);
        StringBuilder builder = new StringBuilder("{").append(nodeNameOrID).append('}');
        for (Map.Entry entry : node.getAttributes().entrySet()) {
            if (!((String)entry.getKey()).startsWith("ml.") && !((String)entry.getKey()).equals("node.ml")) continue;
            builder.append('{').append(entry).append('}');
        }
        return builder.toString();
    }

    static String[] indicesOfInterest(String resultsIndex) {
        if (resultsIndex == null) {
            return new String[]{AnomalyDetectorsIndex.jobStateIndexPattern(), ".ml-meta"};
        }
        return new String[]{AnomalyDetectorsIndex.jobStateIndexPattern(), resultsIndex, ".ml-meta"};
    }

    static List<String> verifyIndicesPrimaryShardsAreActive(String resultsWriteIndex, ClusterState clusterState) {
        IndexNameExpressionResolver resolver = new IndexNameExpressionResolver(Settings.EMPTY);
        String[] indices = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandOpen(), TransportOpenJobAction.indicesOfInterest(resultsWriteIndex));
        ArrayList<String> unavailableIndices = new ArrayList<String>(indices.length);
        for (String index : indices) {
            IndexRoutingTable routingTable;
            if (!clusterState.metaData().hasIndex(index) || (routingTable = clusterState.getRoutingTable().index(index)) != null && routingTable.allPrimaryShardsActive()) continue;
            unavailableIndices.add(index);
        }
        return unavailableIndices;
    }

    private static boolean nodeSupportsMlJobs(Version nodeVersion) {
        return nodeVersion.onOrAfter(Version.V_5_5_0);
    }

    private static boolean jobHasRules(Job job) {
        return job.getAnalysisConfig().getDetectors().stream().anyMatch(d -> !d.getRules().isEmpty());
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse newResponse() {
        return new AcknowledgedResponse();
    }

    protected ClusterBlockException checkBlock(OpenJobAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(OpenJobAction.Request request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        if (this.migrationEligibilityCheck.jobIsEligibleForMigration(request.getJobParams().getJobId(), state)) {
            listener.onFailure((Exception)((Object)ExceptionsHelper.configHasNotBeenMigrated((String)"open job", (String)request.getJobParams().getJobId())));
            return;
        }
        final OpenJobAction.JobParams jobParams = request.getJobParams();
        if (this.licenseState.isMachineLearningAllowed()) {
            boolean clusterSupportsMlMemoryTracker = state.getNodes().getMinNodeVersion().onOrAfter(Version.V_6_6_0);
            final ActionListener clearJobFinishTime = ActionListener.wrap(response -> {
                if (response.isAcknowledged()) {
                    this.clearJobFinishedTime(jobParams.getJobId(), listener);
                } else {
                    listener.onResponse(response);
                }
            }, arg_0 -> listener.onFailure(arg_0));
            ActionListener<PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams>> waitForJobToStart = new ActionListener<PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams>>(){

                public void onResponse(PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> task) {
                    TransportOpenJobAction.this.waitForJobStarted(task.getId(), jobParams, (ActionListener<AcknowledgedResponse>)clearJobFinishTime);
                }

                public void onFailure(Exception e) {
                    if (e instanceof ResourceAlreadyExistsException) {
                        e = new ElasticsearchStatusException("Cannot open job [" + jobParams.getJobId() + "] because it has already been opened", RestStatus.CONFLICT, e, new Object[0]);
                    }
                    listener.onFailure((Exception)e);
                }
            };
            ActionListener memoryRequirementRefreshListener = ActionListener.wrap(arg_0 -> this.lambda$masterOperation$3(jobParams, (ActionListener)waitForJobToStart, arg_0), arg_0 -> listener.onFailure(arg_0));
            ActionListener jobUpdateListener = ActionListener.wrap(response -> this.memoryTracker.refreshJobMemoryAndAllOthers(jobParams.getJobId(), (ActionListener<Long>)memoryRequirementRefreshListener), arg_0 -> listener.onFailure(arg_0));
            ActionListener missingMappingsListener = ActionListener.wrap(response -> {
                Version jobVersion;
                Job job;
                block6: {
                    block7: {
                        job = jobParams.getJob();
                        if (job == null) {
                            jobUpdateListener.onResponse(null);
                            return;
                        }
                        jobVersion = job.getJobVersion();
                        Long jobEstablishedModelMemory = job.getEstablishedModelMemory();
                        if (clusterSupportsMlMemoryTracker || jobVersion != null && !jobVersion.before(Version.V_6_1_0)) break block6;
                        if (jobEstablishedModelMemory == null) break block7;
                        if (jobEstablishedModelMemory != 0L) break block6;
                    }
                    this.jobResultsProvider.getEstablishedMemoryUsage(job.getId(), null, null, establishedModelMemory -> {
                        if (establishedModelMemory != null && establishedModelMemory > 0L) {
                            JobUpdate update = new JobUpdate.Builder(job.getId()).setEstablishedModelMemory(establishedModelMemory).build();
                            UpdateJobAction.Request updateRequest = UpdateJobAction.Request.internal((String)job.getId(), (JobUpdate)update);
                            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)UpdateJobAction.INSTANCE, (ActionRequest)updateRequest, (ActionListener)jobUpdateListener);
                        } else {
                            jobUpdateListener.onResponse(null);
                        }
                    }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                    return;
                }
                if (jobVersion != null && jobVersion.onOrAfter(Version.V_6_1_0) && jobVersion.before(Version.V_6_3_0)) {
                    if (job.getAnalysisLimits() != null && job.getAnalysisLimits().getModelMemoryLimit() != null && job.getAnalysisLimits().getModelMemoryLimit() < 512L) {
                        long updatedModelMemoryLimit = (long)((double)job.getAnalysisLimits().getModelMemoryLimit().longValue() * 1.3);
                        AnalysisLimits limits = new AnalysisLimits(Long.valueOf(updatedModelMemoryLimit), job.getAnalysisLimits().getCategorizationExamplesLimit());
                        JobUpdate update = new JobUpdate.Builder(job.getId()).setJobVersion(Version.CURRENT).setAnalysisLimits(limits).build();
                        UpdateJobAction.Request updateRequest = UpdateJobAction.Request.internal((String)job.getId(), (JobUpdate)update);
                        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)UpdateJobAction.INSTANCE, (ActionRequest)updateRequest, (ActionListener)jobUpdateListener);
                        return;
                    }
                    jobUpdateListener.onResponse(null);
                    return;
                }
                jobUpdateListener.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0));
            ActionListener getJobHandler = ActionListener.wrap(response -> ElasticsearchMappings.addDocMappingIfMissing((String)AnomalyDetectorsIndex.jobStateIndexWriteAlias(), ElasticsearchMappings::stateMapping, (Client)this.client, (ClusterState)state, (ActionListener)missingMappingsListener), arg_0 -> listener.onFailure(arg_0));
            this.jobManager.getJob(jobParams.getJobId(), (ActionListener<Job>)ActionListener.wrap(job -> {
                jobParams.setJob(job);
                getJobHandler.onResponse(null);
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }

    private void waitForJobStarted(String taskId, final OpenJobAction.JobParams jobParams, final ActionListener<AcknowledgedResponse> listener) {
        final JobPredicate predicate = new JobPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(taskId, (Predicate)predicate, jobParams.getTimeout(), (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<OpenJobAction.JobParams>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> persistentTask) {
                if (predicate.exception != null) {
                    if (predicate.shouldCancel) {
                        TransportOpenJobAction.this.cancelJobStart((PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams>)persistentTask, predicate.exception, (ActionListener<AcknowledgedResponse>)listener);
                    } else {
                        listener.onFailure(predicate.exception);
                    }
                } else {
                    listener.onResponse((Object)new AcknowledgedResponse(predicate.opened));
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)new ElasticsearchException("Opening job [" + jobParams.getJobId() + "] timed out after [" + timeout + "]", new Object[0]));
            }
        });
    }

    private void clearJobFinishedTime(final String jobId, final ActionListener<AcknowledgedResponse> listener) {
        boolean jobIsInClusterState = ClusterStateJobUpdate.jobIsInClusterState(this.clusterService.state(), jobId);
        if (jobIsInClusterState) {
            this.clusterService.submitStateUpdateTask("clearing-job-finish-time-for-" + jobId, (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

                public ClusterState execute(ClusterState currentState) {
                    MlMetadata mlMetadata = MlMetadata.getMlMetadata((ClusterState)currentState);
                    MlMetadata.Builder mlMetadataBuilder = new MlMetadata.Builder(mlMetadata);
                    Job.Builder jobBuilder = new Job.Builder((Job)mlMetadata.getJobs().get(jobId));
                    jobBuilder.setFinishedTime(null);
                    mlMetadataBuilder.putJob(jobBuilder.build(), true);
                    ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
                    return builder.metaData(new MetaData.Builder(currentState.metaData()).putCustom("ml", (MetaData.Custom)mlMetadataBuilder.build())).build();
                }

                public void onFailure(String source, Exception e) {
                    TransportOpenJobAction.this.logger.error("[" + jobId + "] Failed to clear finished_time; source [" + source + "]", (Throwable)e);
                    listener.onResponse((Object)new AcknowledgedResponse(true));
                }

                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse((Object)new AcknowledgedResponse(true));
                }
            });
        } else {
            JobUpdate update = new JobUpdate.Builder(jobId).setClearFinishTime(true).build();
            this.jobConfigProvider.updateJob(jobId, update, null, this.clusterService.state().nodes().getMinNodeVersion(), (ActionListener<Job>)ActionListener.wrap(job -> listener.onResponse((Object)new AcknowledgedResponse(true)), e -> {
                this.logger.error("[" + jobId + "] Failed to clear finished_time", (Throwable)e);
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }));
        }
    }

    private void cancelJobStart(final PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> persistentTask, final Exception exception, final ActionListener<AcknowledgedResponse> listener) {
        this.persistentTasksService.sendRemoveRequest(persistentTask.getId(), new ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetaData.PersistentTask<?> task) {
                listener.onFailure(exception);
            }

            public void onFailure(Exception e) {
                TransportOpenJobAction.this.logger.error("[" + ((OpenJobAction.JobParams)persistentTask.getParams()).getJobId() + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                listener.onFailure(exception);
            }
        });
    }

    static ElasticsearchException makeNoSuitableNodesException(Logger logger, String jobId, String explanation) {
        String msg = "Could not open job because no suitable nodes were found, allocation explanation [" + explanation + "]";
        logger.warn("[{}] {}", (Object)jobId, (Object)msg);
        IllegalStateException detail = new IllegalStateException(msg);
        return new ElasticsearchStatusException("Could not open job because no ML nodes with sufficient capacity were found", RestStatus.TOO_MANY_REQUESTS, (Throwable)detail, new Object[0]);
    }

    static ElasticsearchException makeCurrentlyBeingUpgradedException(Logger logger, String jobId, String explanation) {
        String msg = "Cannot open jobs when upgrade mode is enabled";
        logger.warn("[{}] {}", (Object)jobId, (Object)msg);
        return new ElasticsearchStatusException(msg, RestStatus.TOO_MANY_REQUESTS, new Object[0]);
    }

    private /* synthetic */ void lambda$masterOperation$3(OpenJobAction.JobParams jobParams, ActionListener waitForJobToStart, Long mem) throws Exception {
        this.persistentTasksService.sendStartRequest(MlTasks.jobTaskId((String)jobParams.getJobId()), "xpack/ml/job", (PersistentTaskParams)jobParams, waitForJobToStart);
    }

    private class JobPredicate
    implements Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> {
        private volatile boolean opened;
        private volatile Exception exception;
        private volatile boolean shouldCancel;

        private JobPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetaData.PersistentTask<?> persistentTask) {
            JobState jobState = JobState.CLOSED;
            if (persistentTask != null) {
                JobTaskState jobTaskState = (JobTaskState)persistentTask.getState();
                jobState = jobTaskState == null ? JobState.OPENING : jobTaskState.getState();
                PersistentTasksCustomMetaData.Assignment assignment = persistentTask.getAssignment();
                if (assignment != null && assignment.equals((Object)AWAITING_LAZY_ASSIGNMENT)) {
                    return true;
                }
                if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetaData.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                    OpenJobAction.JobParams params = (OpenJobAction.JobParams)persistentTask.getParams();
                    this.exception = TransportOpenJobAction.makeNoSuitableNodesException(TransportOpenJobAction.this.logger, params.getJobId(), assignment.getExplanation());
                    this.shouldCancel = true;
                    return true;
                }
            }
            switch (jobState) {
                case OPENING: 
                case CLOSED: {
                    return false;
                }
                case OPENED: {
                    this.opened = true;
                    return true;
                }
                case CLOSING: {
                    this.exception = ExceptionsHelper.conflictStatusException((String)("The job has been " + JobState.CLOSED + " while waiting to be " + JobState.OPENED), (Object[])new Object[0]);
                    return true;
                }
            }
            this.exception = ExceptionsHelper.serverError((String)("Unexpected job state [" + jobState + "] while waiting for job to be " + JobState.OPENED));
            return true;
        }
    }

    public static class JobTask
    extends AllocatedPersistentTask
    implements OpenJobAction.JobTaskMatcher {
        private static final Logger LOGGER = LogManager.getLogger(JobTask.class);
        private final String jobId;
        private volatile AutodetectProcessManager autodetectProcessManager;

        JobTask(String jobId, long id, String type, String action, TaskId parentTask, Map<String, String> headers) {
            super(id, type, action, "job-" + jobId, parentTask, headers);
            this.jobId = jobId;
        }

        public String getJobId() {
            return this.jobId;
        }

        protected void onCancelled() {
            String reason = this.getReasonCancelled();
            LOGGER.trace("[{}] Cancelling job task because: {}", (Object)this.jobId, (Object)reason);
            this.killJob(reason);
        }

        void killJob(String reason) {
            this.autodetectProcessManager.killProcess(this, false, reason);
        }

        void closeJob(String reason) {
            this.autodetectProcessManager.closeJob(this, false, reason);
        }
    }

    public static class OpenJobPersistentTasksExecutor
    extends PersistentTasksExecutor<OpenJobAction.JobParams> {
        private static final Logger logger = LogManager.getLogger(OpenJobPersistentTasksExecutor.class);
        private final AutodetectProcessManager autodetectProcessManager;
        private final MlMemoryTracker memoryTracker;
        private final Client client;
        private final ClusterService clusterService;
        private final int fallbackMaxNumberOfOpenJobs;
        private volatile int maxConcurrentJobAllocations;
        private volatile int maxMachineMemoryPercent;
        private volatile int maxLazyMLNodes;
        private volatile ClusterState clusterState;

        public OpenJobPersistentTasksExecutor(Settings settings, ClusterService clusterService, AutodetectProcessManager autodetectProcessManager, MlMemoryTracker memoryTracker, Client client) {
            super("xpack/ml/job", "ml_utility");
            this.autodetectProcessManager = autodetectProcessManager;
            this.memoryTracker = memoryTracker;
            this.client = client;
            this.fallbackMaxNumberOfOpenJobs = (Integer)AutodetectProcessManager.MAX_OPEN_JOBS_PER_NODE.get(settings);
            this.maxConcurrentJobAllocations = (Integer)MachineLearning.CONCURRENT_JOB_ALLOCATIONS.get(settings);
            this.maxMachineMemoryPercent = (Integer)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.get(settings);
            this.maxLazyMLNodes = (Integer)MachineLearning.MAX_LAZY_ML_NODES.get(settings);
            this.clusterService = clusterService;
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.CONCURRENT_JOB_ALLOCATIONS, this::setMaxConcurrentJobAllocations);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_MACHINE_MEMORY_PERCENT, this::setMaxMachineMemoryPercent);
            clusterService.getClusterSettings().addSettingsUpdateConsumer(MachineLearning.MAX_LAZY_ML_NODES, this::setMaxLazyMLNodes);
            clusterService.addListener(event -> {
                this.clusterState = event.state();
            });
        }

        public PersistentTasksCustomMetaData.Assignment getAssignment(OpenJobAction.JobParams params, ClusterState clusterState) {
            boolean scheduledRefresh;
            if (params.getJob() == null) {
                return AWAITING_MIGRATION;
            }
            if (MlMetadata.getMlMetadata((ClusterState)clusterState).isUpgradeMode()) {
                return MlTasks.AWAITING_UPGRADE;
            }
            String jobId = params.getJobId();
            String resultsWriteAlias = AnomalyDetectorsIndex.resultsWriteAlias((String)jobId);
            List<String> unavailableIndices = TransportOpenJobAction.verifyIndicesPrimaryShardsAreActive(resultsWriteAlias, clusterState);
            if (unavailableIndices.size() != 0) {
                String reason = "Not opening job [" + jobId + "], because not all primary shards are active for the following indices [" + String.join((CharSequence)",", unavailableIndices) + "]";
                logger.debug(reason);
                return new PersistentTasksCustomMetaData.Assignment(null, reason);
            }
            boolean isMemoryTrackerRecentlyRefreshed = this.memoryTracker.isRecentlyRefreshed();
            if (!isMemoryTrackerRecentlyRefreshed && (scheduledRefresh = this.memoryTracker.asyncRefresh())) {
                String reason = "Not opening job [" + jobId + "] because job memory requirements are stale - refresh requested";
                logger.debug(reason);
                return new PersistentTasksCustomMetaData.Assignment(null, reason);
            }
            PersistentTasksCustomMetaData.Assignment assignment = TransportOpenJobAction.selectLeastLoadedMlNode(jobId, params.getJob(), clusterState, this.maxConcurrentJobAllocations, this.fallbackMaxNumberOfOpenJobs, this.maxMachineMemoryPercent, this.memoryTracker, isMemoryTrackerRecentlyRefreshed, logger);
            if (assignment.getExecutorNode() == null) {
                int numMlNodes = 0;
                for (DiscoveryNode node : clusterState.getNodes()) {
                    if (!Boolean.valueOf((String)node.getAttributes().get("ml.enabled")).booleanValue()) continue;
                    ++numMlNodes;
                }
                if (numMlNodes < this.maxLazyMLNodes) {
                    assignment = AWAITING_LAZY_ASSIGNMENT;
                }
            }
            return assignment;
        }

        public void validate(OpenJobAction.JobParams params, ClusterState clusterState) {
            TransportOpenJobAction.validate(params.getJobId(), params.getJob());
            PersistentTasksCustomMetaData.Assignment assignment = this.getAssignment(params, clusterState);
            if (assignment.equals((Object)MlTasks.AWAITING_UPGRADE)) {
                throw TransportOpenJobAction.makeCurrentlyBeingUpgradedException(logger, params.getJobId(), assignment.getExplanation());
            }
            if (assignment.getExecutorNode() == null && !assignment.equals((Object)AWAITING_LAZY_ASSIGNMENT)) {
                throw TransportOpenJobAction.makeNoSuitableNodesException(logger, params.getJobId(), assignment.getExplanation());
            }
        }

        protected void nodeOperation(AllocatedPersistentTask task, OpenJobAction.JobParams params, PersistentTaskState state) {
            JobTask jobTask = (JobTask)task;
            jobTask.autodetectProcessManager = this.autodetectProcessManager;
            JobTaskState jobTaskState = (JobTaskState)state;
            if (jobTaskState != null && jobTaskState.getState().isAnyOf(new JobState[]{JobState.FAILED, JobState.CLOSING})) {
                return;
            }
            String jobId = jobTask.getJobId();
            this.autodetectProcessManager.openJob(jobTask, this.clusterState, (e2, shouldFinalizeJob) -> {
                if (e2 == null) {
                    if (shouldFinalizeJob.booleanValue()) {
                        FinalizeJobExecutionAction.Request finalizeRequest = new FinalizeJobExecutionAction.Request(new String[]{jobId});
                        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)FinalizeJobExecutionAction.INSTANCE, (ActionRequest)finalizeRequest, (ActionListener)ActionListener.wrap(response -> task.markAsCompleted(), e -> logger.error("error finalizing job [" + jobId + "]", (Throwable)e)));
                    } else {
                        task.markAsCompleted();
                    }
                } else {
                    task.markAsFailed(e2);
                }
            });
        }

        protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetaData.PersistentTask<OpenJobAction.JobParams> persistentTask, Map<String, String> headers) {
            return new JobTask(((OpenJobAction.JobParams)persistentTask.getParams()).getJobId(), id, type, action, parentTaskId, headers);
        }

        void setMaxConcurrentJobAllocations(int maxConcurrentJobAllocations) {
            logger.info("Changing [{}] from [{}] to [{}]", (Object)MachineLearning.CONCURRENT_JOB_ALLOCATIONS.getKey(), (Object)this.maxConcurrentJobAllocations, (Object)maxConcurrentJobAllocations);
            this.maxConcurrentJobAllocations = maxConcurrentJobAllocations;
        }

        void setMaxMachineMemoryPercent(int maxMachineMemoryPercent) {
            logger.info("Changing [{}] from [{}] to [{}]", (Object)MachineLearning.MAX_MACHINE_MEMORY_PERCENT.getKey(), (Object)this.maxMachineMemoryPercent, (Object)maxMachineMemoryPercent);
            this.maxMachineMemoryPercent = maxMachineMemoryPercent;
        }

        void setMaxLazyMLNodes(int maxLazyMLNodes) {
            logger.info("Changing [{}] from [{}] to [{}]", (Object)MachineLearning.MAX_LAZY_ML_NODES.getKey(), (Object)this.maxLazyMLNodes, (Object)maxLazyMLNodes);
            this.maxLazyMLNodes = maxLazyMLNodes;
        }
    }
}

