/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Objects;
import org.elasticsearch.xpack.core.ml.job.config.AnalysisLimits;

public class AnalysisLimitsWriter {
    private static final String MEMORY_STANZA_STR = "[memory]";
    private static final String RESULTS_STANZA_STR = "[results]";
    private static final String MODEL_MEMORY_LIMIT_CONFIG_STR = "modelmemorylimit";
    private static final String MAX_EXAMPLES_LIMIT_CONFIG_STR = "maxexamples";
    private final AnalysisLimits limits;
    private final OutputStreamWriter writer;

    public AnalysisLimitsWriter(AnalysisLimits limits, OutputStreamWriter writer) {
        this.limits = Objects.requireNonNull(limits);
        this.writer = Objects.requireNonNull(writer);
    }

    public void write() throws IOException {
        StringBuilder contents = new StringBuilder(MEMORY_STANZA_STR).append('\n');
        if (this.limits.getModelMemoryLimit() != null) {
            contents.append("modelmemorylimit = ").append(this.limits.getModelMemoryLimit()).append('\n');
        }
        contents.append(RESULTS_STANZA_STR).append('\n');
        if (this.limits.getCategorizationExamplesLimit() != null) {
            contents.append("maxexamples = ").append(this.limits.getCategorizationExamplesLimit()).append('\n');
        }
        this.writer.write(contents.toString());
    }
}

