/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.gen.processor;

import java.io.IOException;
import java.util.Objects;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.sql.expression.gen.processor.BinaryProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public abstract class FunctionalBinaryProcessor<T, U, R, F extends Enum<F>>
extends BinaryProcessor {
    private final F function;

    protected FunctionalBinaryProcessor(Processor left, Processor right, F function) {
        super(left, right);
        this.function = function;
    }

    protected FunctionalBinaryProcessor(StreamInput in, Writeable.Reader<F> reader) throws IOException {
        super(in);
        this.function = (Enum)reader.read(in);
    }

    public F function() {
        return this.function;
    }

    @Override
    protected void doWrite(StreamOutput out) throws IOException {
        out.writeEnum(this.function());
    }

    @Override
    protected Object doProcess(Object left, Object right) {
        return ((BiFunction)this.function).apply(left, right);
    }

    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.function());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionalBinaryProcessor other = (FunctionalBinaryProcessor)obj;
        return Objects.equals(this.function(), other.function()) && Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }
}

