/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.Comparisons;

final class Conditionals {
    private Conditionals() {
    }

    static Object coalesce(Collection<Object> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        for (Object object : values) {
            if (object == null) continue;
            return object;
        }
        return null;
    }

    static Object coalesceInput(List<Processor> processors, Object input) {
        for (Processor proc : processors) {
            Object result = proc.process(input);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static Object greatest(Collection<Object> values) {
        return Conditionals.extremum(values, Comparisons::gt);
    }

    static Object greatestInput(Collection<Processor> processors, Object input) {
        ArrayList<Object> values = new ArrayList<Object>(processors.size());
        for (Processor processor : processors) {
            values.add(processor.process(input));
        }
        return Conditionals.greatest(values);
    }

    static Object least(Collection<Object> values) {
        return Conditionals.extremum(values, Comparisons::lt);
    }

    static Object leastInput(List<Processor> processors, Object input) {
        ArrayList<Object> values = new ArrayList<Object>(processors.size());
        for (Processor processor : processors) {
            values.add(processor.process(input));
        }
        return Conditionals.least(values);
    }

    private static Object extremum(Collection<Object> values, BiFunction<Object, Object, Boolean> comparison) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        Object result = null;
        boolean isFirst = true;
        for (Object value : values) {
            if (isFirst || result == null || comparison.apply(value, result) == Boolean.TRUE) {
                result = value;
            }
            isFirst = false;
        }
        return result;
    }
}

