/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.capabilities.Resolvables;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class Aggregate
extends UnaryPlan {
    private final List<Expression> groupings;
    private final List<? extends NamedExpression> aggregates;

    public Aggregate(Source source, LogicalPlan child, List<Expression> groupings, List<? extends NamedExpression> aggregates) {
        super(source, child);
        this.groupings = groupings;
        this.aggregates = aggregates;
    }

    @Override
    protected NodeInfo<Aggregate> info() {
        return NodeInfo.create(this, Aggregate::new, this.child(), this.groupings, this.aggregates);
    }

    @Override
    protected Aggregate replaceChild(LogicalPlan newChild) {
        return new Aggregate(this.source(), newChild, this.groupings, this.aggregates);
    }

    public List<Expression> groupings() {
        return this.groupings;
    }

    public List<? extends NamedExpression> aggregates() {
        return this.aggregates;
    }

    @Override
    public boolean expressionsResolved() {
        return Resolvables.resolved(this.groupings) && Resolvables.resolved(this.aggregates);
    }

    @Override
    public List<Attribute> output() {
        return Expressions.asAttributes(this.aggregates);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.groupings, this.aggregates, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Aggregate other = (Aggregate)obj;
        return Objects.equals(this.groupings, other.groupings) && Objects.equals(this.aggregates, other.aggregates) && Objects.equals(this.child(), other.child());
    }
}

